/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.sbb.abstractclass;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.SbbUsageMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ServiceManagementMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ServiceUsageMBeanProxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.slee.ComponentID;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;

public class Test2339Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 2339;
    private static final String USAGE_SET = "foo";
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private DeployableUnitID duID;
    private ServiceID serviceID;
    private SbbID sbbID;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        ServiceManagementMBeanProxy serviceProxy = this.utils.getMBeanProxyFactory().createServiceManagementMBeanProxy(this.utils.getSleeManagementMBeanProxy().getServiceManagementMBean());
        ServiceUsageMBeanProxy serviceUsageProxy = this.utils.getMBeanProxyFactory().createServiceUsageMBeanProxy(serviceProxy.getServiceUsageMBean(this.serviceID));
        serviceUsageProxy.createUsageParameterSet(this.sbbID, USAGE_SET);
        SbbUsageMBeanProxy sbbUsageProxy = this.utils.getMBeanProxyFactory().createSbbUsageMBeanProxy(serviceUsageProxy.getSbbUsageMBean(this.sbbID, USAGE_SET));
        if (!sbbUsageProxy.getUsageParameterSet().equals(USAGE_SET)) {
            return TCKTestResult.failed(2339, "SbbUsageMBean.getUsageParameterSet() returned an incorrect value.");
        }
        sbbUsageProxy = this.utils.getMBeanProxyFactory().createSbbUsageMBeanProxy(serviceUsageProxy.getSbbUsageMBean(this.sbbID));
        if (sbbUsageProxy.getUsageParameterSet() != null) {
            return TCKTestResult.failed(2454, "SbbUsageMBean.getUsageParameterSet() returned non-null for the default usage parameter set.");
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        this.utils.getLog().fine("Installing and activating service");
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils.install(duPath);
        DeploymentMBeanProxy duProxy = this.utils.getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (components[i] instanceof ServiceID) {
                this.serviceID = (ServiceID)components[i];
            }
            if (!(components[i] instanceof SbbID)) continue;
            this.sbbID = (SbbID)components[i];
        }
    }

    public void tearDown() throws Exception {
        try {
            ServiceManagementMBeanProxy serviceProxy = this.utils.getMBeanProxyFactory().createServiceManagementMBeanProxy(this.utils.getSleeManagementMBeanProxy().getServiceManagementMBean());
            ServiceUsageMBeanProxy serviceUsageProxy = this.utils.getMBeanProxyFactory().createServiceUsageMBeanProxy(serviceProxy.getServiceUsageMBean(this.serviceID));
            serviceUsageProxy.removeUsageParameterSet(this.sbbID, USAGE_SET);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            HashMap map = (HashMap)message.getMessage();
            Boolean passed = (Boolean)map.get("Result");
            String msgString = (String)map.get("Message");
            Test2339Test.this.utils.getLog().info("Received message from SBB.");
            if (passed.booleanValue()) {
                Test2339Test.this.result.setPassed();
            } else {
                Test2339Test.this.result.setFailed(2339, msgString);
            }
        }

        public void onException(Exception e) throws RemoteException {
            Test2339Test.this.utils.getLog().warning("Received exception from SBB");
            Test2339Test.this.utils.getLog().warning(e);
            Test2339Test.this.result.setError(e);
        }
    }
}

