/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.sbb.abstractclass;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.util.Future;
import java.rmi.RemoteException;
import javax.slee.management.DeployableUnitID;

public class Test2056Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 2056;
    private boolean hasReceivedFirstMessage;
    private SleeTCKTestUtils utils;
    private TCKResourceListenerImpl resourceListener;
    private DeployableUnitID duID;
    private FutureResult futureResult;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCKTestResult run() throws Exception {
        this.futureResult = new FutureResult(this.utils.getLog());
        TCKResourceTestInterface resource = this.utils.getResourceInterface();
        TCKActivityID activityID = resource.createActivity("Test2056InitialActivity");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", activityID, null);
        try {
            return this.futureResult.waitForResult(this.utils.getTestTimeout());
        }
        catch (Future.TimeoutException e) {
            FutureResult futureResult = this.futureResult;
            synchronized (futureResult) {
                if (this.hasReceivedFirstMessage) {
                    this.utils.getLog().info("Timed out as expected waiting for notification of a second invocation of sbbExceptionThrown()");
                    return TCKTestResult.passed();
                }
                return TCKTestResult.error("Timed out waiting for a notification that the SBB received an sbbExceptionThrown() callback after throwing a RuntimeException from the sbbCreate() method", e);
            }
        }
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        this.utils.getLog().fine("Installing and activating service");
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils.install(duPath);
        this.utils.activateServices(this.duID, true);
    }

    public void tearDown() throws Exception {
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSbbMessage(TCKSbbMessage sbbMessage, TCKActivityID calledActivity) throws RemoteException {
            String exceptionMessage = (String)sbbMessage.getMessage();
            if ("Test2056:SLEEException from sbbCreate()".equals(exceptionMessage)) {
                if (!Test2056Test.this.hasReceivedFirstMessage) {
                    Test2056Test.this.utils.getLog().info("The SBB received the expected sbbExceptionThrown() callback for the exception thrown in sbbCreate()");
                    FutureResult futureResult = Test2056Test.this.futureResult;
                    synchronized (futureResult) {
                        Test2056Test.this.hasReceivedFirstMessage = true;
                    }
                } else {
                    Test2056Test.this.utils.getLog().info("The SBB received another sbbExceptionThrown() callback for an exception thrown in sbbCreate()");
                }
            } else if ("Test2056:SLEEException from sbbPostCreate()".equals(exceptionMessage)) {
                String failureMessage = "The SBB received an sbbExceptionThrown() callback for the exception thrown in sbbPostCreate(). sbbPostCreate() should never have even been called, as the SBB threw a RuntimeException in sbbCreate(), which should have caused a call to sbbExceptionThrown(), then the SBB should have been put in the Does Not Exist state.";
                FutureResult futureResult = Test2056Test.this.futureResult;
                synchronized (futureResult) {
                    if (!Test2056Test.this.hasReceivedFirstMessage) {
                        failureMessage = failureMessage + "Note: the call to sbbExceptionThrown() following sbbCreate() was not confirmed";
                    }
                }
                Test2056Test.this.futureResult.setFailed(2056, failureMessage);
            }
        }

        public void onException(Exception exception) throws RemoteException {
            Test2056Test.this.futureResult.setError(exception);
        }
    }
}

