/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.sbb.abstractclass;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import java.rmi.RemoteException;
import java.util.Map;

public class SbbExceptionThrownRolledBackOrdering
extends AbstractSleeTCKTest {
    private FutureResult result;
    private boolean sbbExceptionThrown = false;

    public void run(FutureResult result) throws Exception {
        this.result = result;
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        String activityName = "SbbExceptionThrownRolledBackOrdering";
        TCKActivityID activityID = resource.createActivity(activityName);
        this.utils().getLog().fine("Firing TCKResourceEventX.X1 on activity " + activityName);
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", activityID, null);
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to resource");
        TCKResourceListenerImpl resourceListener = new TCKResourceListenerImpl();
        this.setResourceListener(resourceListener);
        this.setupService("serviceDUPath", true);
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Map sbbData = (Map)message.getMessage();
            if (sbbData.containsKey("sbbExceptionThrown")) {
                if (SbbExceptionThrownRolledBackOrdering.this.sbbExceptionThrown) {
                    SbbExceptionThrownRolledBackOrdering.this.result.setFailed(470, "expected only one sbbExceptionThrown invocation");
                    return;
                }
                SbbExceptionThrownRolledBackOrdering.this.sbbExceptionThrown = true;
            } else if (sbbData.containsKey("sbbRolledBack")) {
                if (SbbExceptionThrownRolledBackOrdering.this.sbbExceptionThrown) {
                    SbbExceptionThrownRolledBackOrdering.this.result.setPassed();
                } else {
                    SbbExceptionThrownRolledBackOrdering.this.result.setFailed(470, "expected sbbRolledBack to be invoked before sbbExceptionThrown");
                }
            }
        }

        public void onException(Exception exception) throws RemoteException {
            SbbExceptionThrownRolledBackOrdering.this.getLog().warning("Received exception from SBB or resource:");
            SbbExceptionThrownRolledBackOrdering.this.getLog().warning(exception);
            SbbExceptionThrownRolledBackOrdering.this.result.setError(exception);
        }
    }
}

