/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.sbb.abstractclass;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import java.rmi.RemoteException;
import java.util.Map;

public class Fire1Event
extends AbstractSleeTCKTest {
    private FutureResult result;

    public void run(FutureResult result) throws Exception {
        this.result = result;
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        String activityName = this.utils().getTestParams().getProperty("activityName");
        TCKActivityID activityID = resource.createActivity(activityName);
        this.utils().getLog().fine("Firing TCKResourceEventX.X1 on activity " + activityName);
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", activityID, null);
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to resource");
        TCKResourceListenerImpl resourceListener = new TCKResourceListenerImpl();
        this.setResourceListener(resourceListener);
        this.setupService("serviceDUPath", true);
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Map sbbData = (Map)message.getMessage();
            Boolean sbbPassed = (Boolean)sbbData.get("result");
            String sbbTestMessage = (String)sbbData.get("message");
            int assertionID = sbbData.containsKey("id") ? (Integer)sbbData.get("id") : 0;
            Fire1Event.this.getLog().info("Received message from SBB: passed=" + sbbPassed + ", message=" + sbbTestMessage + (assertionID != 0 ? ", id=" + assertionID : ""));
            if (sbbPassed.booleanValue()) {
                Fire1Event.this.result.setPassed();
            } else {
                Fire1Event.this.result.setFailed(assertionID, sbbTestMessage);
            }
        }

        public void onException(Exception exception) throws RemoteException {
            Fire1Event.this.getLog().warning("Received exception from SBB or resource:");
            Fire1Event.this.getLog().warning(exception);
            Fire1Event.this.result.setError(exception);
        }
    }
}

