/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.resource.lifecycle;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.testsuite.resource.TCKMessage;
import com.opencloud.sleetck.lib.testsuite.resource.lifecycle.RAStateManager;
import com.opencloud.sleetck.lib.testutils.jmx.ResourceManagementMBeanProxy;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.ResourceAdaptorID;

public class Test1115504Test
extends AbstractSleeTCKTest {
    private static final String RA_NAME = "TCK_Lifecycle_Test_RA";
    private static final String RA_ENTITY_NAME = "TCK_Lifecycle_Test_RA_Entity";
    private static final String RA_VENDOR = "jain.slee.tck";
    private static final String RA_VERSION = "1.1";
    private static final String RESOURCE_DU_PATH_PARAM = "resourceDUPath";

    public TCKTestResult run() throws Exception {
        RMIObjectChannel in = this.utils().getRMIObjectChannel();
        ResourceManagementMBeanProxy resourceMBean = this.utils().getResourceManagementMBeanProxy();
        RAStateManager stateManager = new RAStateManager(this.getLog());
        ResourceAdaptorID raID = new ResourceAdaptorID(RA_NAME, RA_VENDOR, RA_VERSION);
        ConfigProperties configProperties = new ConfigProperties();
        resourceMBean.createResourceAdaptorEntity(raID, RA_ENTITY_NAME, configProperties);
        TCKMessage[] messages = this.castMessages(in.readQueue(10000L));
        stateManager.runStateMachine(messages);
        if (!stateManager.hasRAObjectInState(2)) {
            throw new TCKTestFailureException(1115517, "RA Entity did not have any RA Objects in the correct state (" + RAStateManager.getStateString(2) + ") after ResourceManagmentMBean.createResourceAdaptorEntity() returned");
        }
        resourceMBean.activateResourceAdaptorEntity(RA_ENTITY_NAME);
        messages = this.castMessages(in.readQueue(10000L));
        stateManager.runStateMachine(messages);
        if (!stateManager.hasRAObjectInState(3)) {
            throw new TCKTestFailureException(1115527, "RA Entity did not have any RA Objects in the correct state (" + RAStateManager.getStateString(3) + ") after ResourceManagmentMBean.activateResourceAdaptorEntity() returned");
        }
        resourceMBean.deactivateResourceAdaptorEntity(RA_ENTITY_NAME);
        messages = this.castMessages(in.readQueue(10000L));
        stateManager.runStateMachine(messages);
        if (!stateManager.hasRAObjectInState(2)) {
            throw new TCKTestFailureException(1115538, "RA Entity did not have any RA Objects in the correct state (" + RAStateManager.getStateString(2) + ") after ResourceManagmentMBean.deactivateResourceAdaptorEntity() returned");
        }
        resourceMBean.removeResourceAdaptorEntity(RA_ENTITY_NAME);
        messages = this.castMessages(in.readQueue(10000L));
        stateManager.runStateMachine(messages);
        if (stateManager.hasRAObjectInState(2) || stateManager.hasRAObjectInState(3) || stateManager.hasRAObjectInState(4)) {
            throw new TCKTestFailureException(1115522, "Resource Adaptor still had objects in the INACTIVE, ACTIVE, or STOPPING state after entity removal");
        }
        return TCKTestResult.passed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown() throws Exception {
        try {
            this.utils().removeRAEntities();
        }
        finally {
            super.tearDown();
        }
    }

    public void setUp() throws Exception {
        String duPath = this.utils().getTestParams().getProperty(RESOURCE_DU_PATH_PARAM);
        this.utils().install(duPath);
    }

    private TCKMessage[] castMessages(Object[] objects) {
        TCKMessage[] messages = new TCKMessage[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            messages[i] = (TCKMessage)objects[i];
        }
        return messages;
    }
}

