/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.resource.lifecycle;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.rautils.MessageHandler;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.rautils.UOID;
import com.opencloud.sleetck.lib.testsuite.resource.TCKMessage;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.ResourceManagementMBeanProxy;
import java.util.HashSet;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.ResourceAdaptorID;

public class Test1115037Test
extends AbstractSleeTCKTest {
    private static final String RA_NAME = "TCK_Lifecycle_Test_RA";
    private static final String RA_ENTITY_NAME1 = "TCK_Lifecycle_Test_RA_Entity1";
    private static final String RA_ENTITY_NAME2 = "TCK_Lifecycle_Test_RA_Entity2";
    private static final String RA_ENTITY_NAME3 = "TCK_Lifecycle_Test_RA_Entity3";
    private static final String RA_VENDOR = "jain.slee.tck";
    private static final String RA_VERSION = "1.1";
    private static final String RESOURCE_DU_PATH_PARAM = "resourceDUPath";

    public TCKTestResult run() throws Exception {
        ResourceManagementMBeanProxy resourceMBean = this.utils().getResourceManagementMBeanProxy();
        FutureResult future = new FutureResult(this.getLog());
        RMIObjectChannel in = this.utils().getRMIObjectChannel();
        in.setMessageHandler(new CallbackListener(future, 3));
        ResourceAdaptorID raID = new ResourceAdaptorID(RA_NAME, RA_VENDOR, RA_VERSION);
        resourceMBean.createResourceAdaptorEntity(raID, RA_ENTITY_NAME1, new ConfigProperties());
        resourceMBean.createResourceAdaptorEntity(raID, RA_ENTITY_NAME2, new ConfigProperties());
        resourceMBean.createResourceAdaptorEntity(raID, RA_ENTITY_NAME3, new ConfigProperties());
        return future.waitForResultOrFail(this.utils().getTestTimeout(), "Test did not receive the expected number of Resource Adaptor Entity Creation callbacks", 1115037);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown() throws Exception {
        try {
            this.utils().removeRAEntities();
        }
        finally {
            super.tearDown();
        }
    }

    public void setUp() throws Exception {
        String duPath = this.utils().getTestParams().getProperty(RESOURCE_DU_PATH_PARAM);
        this.utils().install(duPath);
    }

    private class CallbackListener
    implements MessageHandler {
        private FutureResult result;
        private int expectedCount;
        private HashSet raEntities = new HashSet();

        public CallbackListener(FutureResult result, int expectedCount) {
            this.result = result;
            this.expectedCount = expectedCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean handleMessage(Object objectMessage) {
            if (objectMessage instanceof TCKMessage) {
                TCKMessage message = (TCKMessage)objectMessage;
                UOID uoid = message.getUID();
                int method = message.getMethod();
                if (method == 5) {
                    HashSet hashSet = this.raEntities;
                    synchronized (hashSet) {
                        this.raEntities.add(uoid);
                        if (this.raEntities.size() == this.expectedCount) {
                            this.result.setPassed();
                        }
                    }
                }
                if (method == 6) {
                    HashSet hashSet = this.raEntities;
                    synchronized (hashSet) {
                        this.raEntities.remove(uoid);
                    }
                }
                return true;
            }
            return false;
        }
    }
}

