/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.resource.endpoint;

import com.opencloud.sleetck.lib.rautils.UOID;
import com.opencloud.sleetck.lib.resource.adaptor11.TCKActivityHandleImpl;
import com.opencloud.sleetck.lib.testsuite.resource.BaseResourceSbb;
import com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent;
import java.io.Serializable;
import java.util.HashMap;
import javax.slee.ActivityContextInterface;
import javax.slee.EventTypeID;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.SleeEndpoint;

public abstract class Test1115413Sbb1
extends BaseResourceSbb {
    private static final EventTypeID eventTypeID = new EventTypeID("com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent", "jain.slee.tck", "1.1");
    private static final UOID sbbUID = UOID.createUOID();

    public void onSimpleEvent(SimpleEvent event, ActivityContextInterface aci) {
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        int sequenceID = event.getSequenceID();
        FireableEventType fireableEventType = null;
        if (!"from RA".equals(event.getPayload())) {
            this.tracer.info("Ignoring event on SBB 1: " + event);
            this.detach(aci);
            return;
        }
        SleeEndpoint endpoint = null;
        try {
            endpoint = this.getSbbInterface().getResourceAdaptorContext().getSleeEndpoint();
            fireableEventType = this.getSbbInterface().getResourceAdaptorContext().getEventLookupFacility().getFireableEventType(eventTypeID);
        }
        catch (Exception e) {
            this.tracer.severe("Failure during ResourceAdaptorContext access from SBB.", (Throwable)e);
            results.put("result-sbb1", e);
            this.sendSbbMessage(sbbUID, sequenceID, 52, results);
            this.detach(aci);
            return;
        }
        try {
            this.tracer.info("(SBB 1) onSimpleEvent() event handler called with event: " + event);
            TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), sequenceID);
            this.tracer.info("Starting new activity.");
            endpoint.startActivity((ActivityHandle)handle, (Object)handle, 4);
            this.tracer.info("Getting ACI for new activity from ACI factory.");
            ActivityContextInterface newAci = this.getACIFactory().getActivityContextInterface(handle);
            this.tracer.info("Attaching this SBB to new activity.");
            newAci.attach(this.getSbbContext().getSbbLocalObject());
            this.tracer.info("Calling suspendActivity() on new activity.");
            endpoint.suspendActivity((ActivityHandle)handle);
            this.tracer.info("Firing new event on new activity.");
            SimpleEvent newEvent = new SimpleEvent(sequenceID, "from SBB");
            endpoint.fireEvent((ActivityHandle)handle, fireableEventType, (Object)newEvent, null, null);
            this.tracer.info("Sleeping for 10 seconds.");
            Thread.sleep(10000L);
            this.tracer.info("SBB processing resuming.");
            this.tracer.info("Sending notification of event firing to TCK.");
            HashMap<String, Boolean> token = new HashMap<String, Boolean>();
            token.put("result-token", Boolean.TRUE);
            this.sendSbbMessage(sbbUID, sequenceID, 52, token);
            results.put("result-sbb1", Boolean.TRUE);
        }
        catch (Exception e) {
            this.tracer.severe("An exception occured during SBB event handler.", (Throwable)e);
            results.put("result-sbb1", e);
        }
        this.sendSbbMessage(sbbUID, sequenceID, 52, results);
        this.detach(aci);
    }
}

