/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.resource.config;

import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.testsuite.resource.BaseResourceTest;
import com.opencloud.sleetck.lib.testsuite.resource.RAMethods;
import com.opencloud.sleetck.lib.testsuite.resource.TCKMessage;
import com.opencloud.sleetck.lib.testsuite.resource.config.ResourceConfigConstants;
import com.opencloud.sleetck.lib.testutils.jmx.ResourceManagementMBeanProxy;
import java.util.HashMap;
import java.util.Random;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.InvalidConfigurationException;
import javax.slee.resource.ResourceAdaptorID;

public class Test1115540Test
extends BaseResourceTest {
    private static final String RA_NAME = "TCK_Config_Test_RA";
    private static final String RA_ENTITY_NAME = "TCK_Config_Test_RA_Entity";
    private static final String RA_VENDOR = "jain.slee.tck";
    private static final String RA_VERSION = "1.1";
    private final Random generator = new Random();

    public TCKTestResult run() throws Exception {
        RMIObjectChannel in = this.utils().getRMIObjectChannel();
        ConfigProperties testProperties = new ConfigProperties();
        this.addProperty(testProperties, this.randomString() + "Test property !@#$%^&*(){}-=_+;\":',./<>?`~", this.randomString() + " test property");
        this.addProperty(testProperties, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890" + this.randomString(), "property test" + this.randomString());
        this.addProperty(testProperties, "Character A", new Character('A'));
        this.addProperty(testProperties, "Character Z", new Character('Z'));
        this.addProperty(testProperties, "Integer 1", new Integer(Integer.MAX_VALUE));
        this.addProperty(testProperties, "Integer 2", new Integer(Integer.MIN_VALUE));
        this.addProperty(testProperties, "Integer 3", new Integer(0));
        this.addProperty(testProperties, "Integer 4", new Integer(this.generator.nextInt()));
        this.addProperty(testProperties, "Boolean (True)", Boolean.TRUE);
        this.addProperty(testProperties, "Boolean (False)", Boolean.FALSE);
        this.addProperty(testProperties, "Double 1", new Double(Double.MAX_VALUE));
        this.addProperty(testProperties, "Double 2", new Double(Double.MIN_VALUE));
        this.addProperty(testProperties, "Double 3", new Double(0.0));
        this.addProperty(testProperties, "Double 4", new Double(this.generator.nextDouble()));
        this.addProperty(testProperties, "Byte 1", new Byte(127));
        this.addProperty(testProperties, "Byte 2", new Byte(-128));
        this.addProperty(testProperties, "Byte 3", new Byte(0));
        byte[] bytes = new byte[1];
        this.generator.nextBytes(bytes);
        this.addProperty(testProperties, "Byte 4", new Byte(bytes[0]));
        this.addProperty(testProperties, "Short 1", new Short(Short.MAX_VALUE));
        this.addProperty(testProperties, "Short 2", new Short(Short.MIN_VALUE));
        this.addProperty(testProperties, "Short 3", new Short(0));
        this.addProperty(testProperties, "Short 4", new Short((short)this.generator.nextInt()));
        this.addProperty(testProperties, "Long 1", new Long(Long.MAX_VALUE));
        this.addProperty(testProperties, "Long 2", new Long(Long.MIN_VALUE));
        this.addProperty(testProperties, "Long 3", new Long(0L));
        this.addProperty(testProperties, "Long 4", new Long(this.generator.nextLong()));
        this.addProperty(testProperties, "Float 1", new Float(Float.MAX_VALUE));
        this.addProperty(testProperties, "Float 2", new Float(Float.MIN_VALUE));
        this.addProperty(testProperties, "Float 3", new Float(0.0f));
        this.addProperty(testProperties, "Float 4", new Float(this.generator.nextFloat()));
        ResourceManagementMBeanProxy resourceMBean = this.utils().getResourceManagementMBeanProxy();
        this.getLog().info("Creating RA Entity");
        ResourceAdaptorID raID = new ResourceAdaptorID(RA_NAME, RA_VENDOR, RA_VERSION);
        resourceMBean.createResourceAdaptorEntity(raID, RA_ENTITY_NAME, testProperties);
        TCKMessage[] messages = this.castMessages(in.readQueue(5000L));
        this.checkMessages(messages, testProperties, 5);
        this.getLog().info("Updating RA Entity with new properties");
        ConfigProperties testProperties2 = new ConfigProperties();
        this.addProperty(testProperties2, "key: " + this.randomString(), "value: " + this.randomString());
        resourceMBean.updateConfigurationProperties(RA_ENTITY_NAME, testProperties2);
        messages = this.castMessages(in.readQueue(5000L));
        this.checkMessages(messages, testProperties2, 4);
        ConfigProperties invalidProperties = new ConfigProperties();
        this.addProperty(invalidProperties, ResourceConfigConstants.INVALID_PROPERTY_KEY, "An invalid property");
        in.clearQueue();
        this.getLog().info("Updating RA Entity with invalid properties");
        boolean iceExceptionThrown = false;
        try {
            resourceMBean.updateConfigurationProperties(RA_ENTITY_NAME, invalidProperties);
        }
        catch (InvalidConfigurationException ice) {
            iceExceptionThrown = true;
        }
        messages = this.castMessages(in.readQueue(5000L));
        this.checkForOnlyVerifyMessages(messages);
        if (!iceExceptionThrown) {
            throw new TCKTestFailureException(1115118, "InvalidConfigurationException was not thrown by ResourceManagmentMBean.updateConfigurationProperties() when passed invalid configuration properties.");
        }
        this.getLog().info("Removing old RA Entity properties");
        resourceMBean.removeResourceAdaptorEntity(RA_ENTITY_NAME);
        this.getLog().info("Creating RA Entity with invalid properties");
        iceExceptionThrown = false;
        try {
            resourceMBean.createResourceAdaptorEntity(raID, RA_ENTITY_NAME, invalidProperties);
        }
        catch (InvalidConfigurationException ice) {
            iceExceptionThrown = true;
        }
        messages = this.castMessages(in.readQueue(5000L));
        this.checkForOnlyVerifyMessages(messages);
        if (!iceExceptionThrown) {
            throw new TCKTestFailureException(1115115, "InvalidConfigurationException was not thrown by ResourceManagmentMBean.createResourceAdaptorEntity() when passed invalid configuration properties.");
        }
        return TCKTestResult.passed();
    }

    private String randomString() {
        return new Integer(this.generator.nextInt()).toString();
    }

    private void addProperty(ConfigProperties properties, String propertyName, Object propertyValue) {
        String propertyType;
        if (propertyValue.getClass() == String.class) {
            propertyType = "java.lang.String";
        } else if (propertyValue.getClass() == Character.class) {
            propertyType = "java.lang.Character";
        } else if (propertyValue.getClass() == Integer.class) {
            propertyType = "java.lang.Integer";
        } else if (propertyValue.getClass() == Boolean.class) {
            propertyType = "java.lang.Boolean";
        } else if (propertyValue.getClass() == Double.class) {
            propertyType = "java.lang.Double";
        } else if (propertyValue.getClass() == Byte.class) {
            propertyType = "java.lang.Byte";
        } else if (propertyValue.getClass() == Short.class) {
            propertyType = "java.lang.Short";
        } else if (propertyValue.getClass() == Long.class) {
            propertyType = "java.lang.Long";
        } else if (propertyValue.getClass() == Float.class) {
            propertyType = "java.lang.Float";
        } else {
            throw new IllegalArgumentException("addProperty() called with unhandled propertyValue class: " + propertyValue.getClass());
        }
        properties.addProperty(new ConfigProperties.Property(propertyName, propertyType, propertyValue));
    }

    private boolean contains(ConfigProperties a, ConfigProperties b) {
        ConfigProperties.Property[] propertiesB = b.getProperties();
        for (int i = 0; i < propertiesB.length; ++i) {
            if (a.getProperty(propertiesB[i].getName()) != null) continue;
            return false;
        }
        return true;
    }

    private void checkMessages(TCKMessage[] messages, ConfigProperties originalProperties, int expectedMethod) throws TCKTestErrorException, TCKTestFailureException {
        boolean verifyCalled = false;
        boolean methodSeen = false;
        block9: for (int i = 0; i < messages.length; ++i) {
            TCKMessage message = messages[i];
            HashMap results = (HashMap)message.getArgument();
            if (results == null) {
                throw new TCKTestErrorException("Null result returned from test component.");
            }
            ConfigProperties properties = (ConfigProperties)results.get("properties");
            Boolean configuredBoolean = (Boolean)results.get("configured");
            if (configuredBoolean == null) {
                throw new TCKTestErrorException("Null 'configured' argument returned from test component.");
            }
            boolean configured = configuredBoolean;
            if (message.getMethod() == expectedMethod) {
                methodSeen = true;
            }
            switch (message.getMethod()) {
                case 10: {
                    verifyCalled = true;
                    continue block9;
                }
                case 5: {
                    if (!verifyCalled) {
                        throw new TCKTestFailureException(1115540, RAMethods.getMethodName(message.getMethod()) + "() invoked before raVerifyConfiguration()");
                    }
                    if (properties != null && this.contains(properties, originalProperties)) continue block9;
                    throw new TCKTestFailureException(0x110510, RAMethods.getMethodName(message.getMethod()) + "() invoked with wrong ConfigProperties: " + properties);
                }
                case 4: {
                    if (!verifyCalled) {
                        throw new TCKTestFailureException(1115540, RAMethods.getMethodName(message.getMethod()) + "() invoked before raVerifyConfiguration()");
                    }
                    if (!configured) {
                        throw new TCKTestFailureException(1115549, RAMethods.getMethodName(message.getMethod()) + "() invoked on a RA Object in an unconfigured state.");
                    }
                    if (properties != null && this.contains(properties, originalProperties)) continue block9;
                    throw new TCKTestFailureException(1115407, RAMethods.getMethodName(message.getMethod()) + "() invoked with wrong ConfigProperties: " + properties);
                }
                default: {
                    throw new TCKTestErrorException("Unexpected method type returned in a ConfigMessage: " + message.toString());
                }
            }
        }
        if (!methodSeen) {
            switch (expectedMethod) {
                case 5: {
                    throw new TCKTestFailureException(1115514, "Expected method call was not received by the Resource Adaptor: " + RAMethods.getMethodName(expectedMethod) + "()");
                }
                case 4: {
                    throw new TCKTestFailureException(1115546, "Expected method call was not received by the Resource Adaptor: " + RAMethods.getMethodName(expectedMethod) + "()");
                }
            }
            throw new TCKTestErrorException("Expected method call was not received by the Resource Adaptor: " + RAMethods.getMethodName(expectedMethod));
        }
    }

    private void checkForOnlyVerifyMessages(TCKMessage[] messages) throws TCKTestFailureException, TCKTestErrorException {
        for (int i = 0; i < messages.length; ++i) {
            TCKMessage message = messages[i];
            if (message.getMethod() == 10) continue;
            switch (message.getMethod()) {
                case 5: {
                    throw new TCKTestFailureException(1115115, "Unexpected call to " + RAMethods.getMethodName(message.getMethod()) + "() - only raVerifyConfiguration() is expected when invalid configuration properties are supplied.");
                }
                case 4: {
                    throw new TCKTestFailureException(1115118, "Unexpected call to " + RAMethods.getMethodName(message.getMethod()) + "() - only raVerifyConfiguration() is expected when invalid configuration properties are supplied.");
                }
            }
            throw new TCKTestErrorException("Unhandled method received while checking that only raVerifyConfiguration() has been called.");
        }
    }
}

