/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.readonly;

import com.opencloud.logging.StdErrLog;
import com.opencloud.sleetck.lib.profileutils.BaseMessageSender;
import com.opencloud.sleetck.lib.rautils.MessageHandler;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.rautils.TCKRAUtils;
import com.opencloud.sleetck.lib.testsuite.profiles.readonly.ReadOnlyTestsProfileCMP;
import com.opencloud.sleetck.lib.testsuite.profiles.readonly.Test1110069_2ResourceAdaptor;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import javax.slee.profile.ProfileTable;
import javax.slee.transaction.SleeTransaction;
import javax.slee.transaction.SleeTransactionManager;

public class Test1110069_2MessageListener
extends UnicastRemoteObject
implements MessageHandler {
    public static final String PROFILE_TABLE_NAME = "Test1110069_2ProfileTable";
    public static final String PROFILE_NAME = "Test1110069_2Profile";
    private Test1110069_2ResourceAdaptor ra;
    private BaseMessageSender msgSender;
    private RMIObjectChannel out;

    public Test1110069_2MessageListener(Test1110069_2ResourceAdaptor ra) throws RemoteException {
        try {
            this.out = TCKRAUtils.lookupRMIObjectChannel();
            this.msgSender = new BaseMessageSender(this.out, new StdErrLog());
        }
        catch (Exception e) {
            ra.getLog().warning("Exception occurred when trying to acquire RMIObjectChannel: ", e);
        }
        this.ra = ra;
    }

    public boolean handleMessage(Object message) throws RemoteException {
        if (this.test_CREATE() && this.test_UPDATE() && this.test_CHECK() && this.test_UPDATE_VIA_CMP() && this.test_CHECK_VIA_CMP() && this.test_REMOVE() && this.test_CHECK_REMOVE()) {
            this.msgSender.sendSuccess(1110069, "Test successful.");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean test_CHECK_REMOVE() {
        SleeTransactionManager txnManager = this.ra.getResourceAdaptorContext().getSleeTransactionManager();
        SleeTransaction txn = null;
        try {
            ProfileTable profileTable = this.ra.getResourceAdaptorContext().getProfileTable(PROFILE_TABLE_NAME);
            txn = txnManager.beginSleeTransaction();
            ReadOnlyTestsProfileCMP profileCMP = (ReadOnlyTestsProfileCMP)profileTable.find(PROFILE_NAME);
            if (profileCMP != null) {
                this.msgSender.sendFailure(1110069, "Profile Test1110069_2Profile was not removed correctly.");
                boolean bl = false;
                return bl;
            }
            this.msgSender.sendLogMsg("Check whether profile was really removed after TXN committed was successful.");
            txn.commit();
            txn = null;
        }
        catch (Exception e) {
            this.msgSender.sendException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (txn != null) {
                    txn.rollback();
                }
            }
            catch (Exception ex) {
                this.ra.getLog().warning("Error occured when trying to rollback RA started TXN.", ex);
                this.msgSender.sendLogMsg("Exception occurred when trying to safely rollback RA started TXN: " + ex.getMessage());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean test_REMOVE() {
        SleeTransactionManager txnManager = this.ra.getResourceAdaptorContext().getSleeTransactionManager();
        SleeTransaction txn = null;
        try {
            ProfileTable profileTable = this.ra.getResourceAdaptorContext().getProfileTable(PROFILE_TABLE_NAME);
            txn = txnManager.beginSleeTransaction();
            boolean res = profileTable.remove(PROFILE_NAME);
            if (!res) {
                this.msgSender.sendFailure(1110069, "Sbb failed to remove profile Test1110069_2Profile");
                boolean bl = false;
                return bl;
            }
            this.msgSender.sendLogMsg("ProfileTable object reports successful removal of profile table Test1110069_2Profile");
            txn.commit();
            txn = null;
        }
        catch (Exception e) {
            this.msgSender.sendException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (txn != null) {
                    txn.rollback();
                }
            }
            catch (Exception ex) {
                this.ra.getLog().warning("Error occured when trying to rollback RA started TXN.", ex);
                this.msgSender.sendLogMsg("Exception occurred when trying to safely rollback RA started TXN: " + ex.getMessage());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean test_CHECK_VIA_CMP() {
        SleeTransactionManager txnManager = this.ra.getResourceAdaptorContext().getSleeTransactionManager();
        SleeTransaction txn = null;
        try {
            ProfileTable profileTable = this.ra.getResourceAdaptorContext().getProfileTable(PROFILE_TABLE_NAME);
            txn = txnManager.beginSleeTransaction();
            ReadOnlyTestsProfileCMP profileCMP = (ReadOnlyTestsProfileCMP)profileTable.find(PROFILE_NAME);
            if (!profileCMP.getValue().equals("newValue2")) {
                this.msgSender.sendFailure(1110086, "Failed to use set/get accessor methods via ProfileCMP object properly.");
                boolean bl = false;
                return bl;
            }
            this.msgSender.sendLogMsg("Checked that new value has been successfully set and could be obtained by 'get' accessor via ProfileCMP interface.");
            txn.commit();
            txn = null;
        }
        catch (Exception e) {
            this.msgSender.sendException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (txn != null) {
                    txn.rollback();
                }
            }
            catch (Exception ex) {
                this.ra.getLog().warning("Error occured when trying to rollback RA started TXN.", ex);
                this.msgSender.sendLogMsg("Exception occurred when trying to safely rollback RA started TXN: " + ex.getMessage());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean test_UPDATE_VIA_CMP() {
        SleeTransactionManager txnManager = this.ra.getResourceAdaptorContext().getSleeTransactionManager();
        SleeTransaction txn = null;
        try {
            ProfileTable profileTable = this.ra.getResourceAdaptorContext().getProfileTable(PROFILE_TABLE_NAME);
            txn = txnManager.beginSleeTransaction();
            ReadOnlyTestsProfileCMP profileCMP = (ReadOnlyTestsProfileCMP)profileTable.find(PROFILE_NAME);
            profileCMP.setValue("newValue2");
            this.msgSender.sendLogMsg("Set new value for profile attribute via CMP interface.");
            txn.commit();
            txn = null;
        }
        catch (Exception e) {
            this.msgSender.sendException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (txn != null) {
                    txn.rollback();
                }
            }
            catch (Exception ex) {
                this.ra.getLog().warning("Error occured when trying to rollback RA started TXN.", ex);
                this.msgSender.sendLogMsg("Exception occurred when trying to safely rollback RA started TXN: " + ex.getMessage());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean test_CHECK() {
        SleeTransactionManager txnManager = this.ra.getResourceAdaptorContext().getSleeTransactionManager();
        SleeTransaction txn = null;
        try {
            ProfileTable profileTable = this.ra.getResourceAdaptorContext().getProfileTable(PROFILE_TABLE_NAME);
            txn = txnManager.beginSleeTransaction();
            ReadOnlyTestsProfileCMP profileCMP = (ReadOnlyTestsProfileCMP)profileTable.find(PROFILE_NAME);
            if (!profileCMP.getValue().equals("newValue")) {
                this.msgSender.sendFailure(1110069, "Failed to use set/get accessor methods properly.");
                boolean bl = false;
                return bl;
            }
            this.msgSender.sendLogMsg("Checked that new value has been successfully set and could be obtained by 'get' accessor.");
            txn.commit();
            txn = null;
        }
        catch (Exception e) {
            this.msgSender.sendException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (txn != null) {
                    txn.rollback();
                }
            }
            catch (Exception ex) {
                this.ra.getLog().warning("Error occured when trying to rollback RA started TXN.", ex);
                this.msgSender.sendLogMsg("Exception occurred when trying to safely rollback RA started TXN: " + ex.getMessage());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean test_UPDATE() {
        SleeTransactionManager txnManager = this.ra.getResourceAdaptorContext().getSleeTransactionManager();
        SleeTransaction txn = null;
        try {
            ProfileTable profileTable = this.ra.getResourceAdaptorContext().getProfileTable(PROFILE_TABLE_NAME);
            txn = txnManager.beginSleeTransaction();
            ReadOnlyTestsProfileCMP profileCMP = (ReadOnlyTestsProfileCMP)profileTable.find(PROFILE_NAME);
            profileCMP.setValue("newValue");
            this.msgSender.sendLogMsg("Set new value for profile attribute.");
            txn.commit();
            txn = null;
        }
        catch (Exception e) {
            this.msgSender.sendException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (txn != null) {
                    txn.rollback();
                }
            }
            catch (Exception ex) {
                this.ra.getLog().warning("Error occured when trying to rollback RA started TXN.", ex);
                this.msgSender.sendLogMsg("Exception occurred when trying to safely rollback RA started TXN: " + ex.getMessage());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean test_CREATE() {
        SleeTransactionManager txnManager = this.ra.getResourceAdaptorContext().getSleeTransactionManager();
        SleeTransaction txn = null;
        try {
            ProfileTable profileTable = this.ra.getResourceAdaptorContext().getProfileTable(PROFILE_TABLE_NAME);
            txn = txnManager.beginSleeTransaction();
            ReadOnlyTestsProfileCMP profileCMP = (ReadOnlyTestsProfileCMP)profileTable.create(PROFILE_NAME);
            profileCMP.getValue();
            this.msgSender.sendLogMsg("Created profile Test1110069_2Profile");
            txn.commit();
            txn = null;
        }
        catch (Exception e) {
            this.msgSender.sendException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (txn != null) {
                    txn.rollback();
                }
            }
            catch (Exception ex) {
                this.ra.getLog().warning("Error occured when trying to rollback RA started TXN.", ex);
                this.msgSender.sendLogMsg("Exception occurred when trying to safely rollback RA started TXN: " + ex.getMessage());
            }
        }
        return true;
    }
}

