/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.profilespec;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.OperationTimedOutException;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.QueuingResourceListener;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.management.ObjectName;
import javax.slee.profile.ProfileSpecificationID;

public abstract class Test1110225BaseTest
extends AbstractSleeTCKTest {
    private static final String SBB_EVENT_DU_PATH = "sbbEventDUPath";
    private static final String DU_PATH_PARAM = "DUPath";
    private static final String SPEC_VERSION = "1.0";
    private ProfileUtils profileUtils;
    private QueuingResourceListener resourceListener;
    private ProfileProvisioningMBeanProxy profileProvisioning;

    protected abstract String getProfileSpecName();

    public TCKTestResult run() throws Exception {
        String specName = this.getProfileSpecName();
        this.setupTable(specName, "Test1110225ProfileTable");
        this.sendResourceEvent();
        return TCKTestResult.passed();
    }

    private void setupProfile(String tableName, String profileName) throws Exception {
        ObjectName profile = this.profileProvisioning.createProfile(tableName, profileName);
        ProfileMBeanProxy profileProxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
        this.getLog().fine("Created profile " + profileName + " for profile table " + tableName);
        profileProxy.commitProfile();
        profileProxy.closeProfile();
        this.getLog().fine("Commit and close profile " + profileName);
    }

    private void setupTable(String specName, String tableName) throws Exception {
        ProfileSpecificationID specID = new ProfileSpecificationID(specName, "jain.slee.tck", SPEC_VERSION);
        this.profileProvisioning.createProfileTable(specID, tableName);
        this.getLog().fine("Added profile table " + tableName + " based on profile spec " + specName);
        this.setupProfile(tableName, "Test1110225Profile");
        this.setupProfile(tableName, "Test1110225Profile2");
    }

    private void sendResourceEvent() throws TCKTestErrorException, RemoteException, TCKTestFailureException {
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity(this.getClass().getName());
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", null, activityID, null);
        try {
            TCKSbbMessage reply = this.resourceListener.nextMessage();
            HashMap map = (HashMap)reply.getMessage();
            int type = (Integer)map.get("Type");
            switch (type) {
                case 0: {
                    String msg = (String)map.get("Message");
                    int id = (Integer)map.get("ID");
                    boolean result = (Boolean)map.get("Result");
                    if (result) {
                        this.getLog().fine(id + ": " + msg);
                        break;
                    }
                    this.getLog().fine("FAILURE: " + msg);
                    throw new TCKTestFailureException(id, msg);
                }
            }
        }
        catch (OperationTimedOutException ex) {
            throw new TCKTestErrorException("Timed out waiting for processing of initial resource event.", ex);
        }
    }

    public void setUp() throws Exception {
        this.setupService(SBB_EVENT_DU_PATH);
        this.setupService(DU_PATH_PARAM);
        this.profileUtils = new ProfileUtils(this.utils());
        this.profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
        this.resourceListener = new QueuingResourceListener(this.utils()){

            public Object onSbbCall(Object argument) throws Exception {
                HashMap map = (HashMap)argument;
                int type = (Integer)map.get("Type");
                switch (type) {
                    case 1: {
                        Test1110225BaseTest.this.getLog().fine((String)map.get("Msg"));
                    }
                }
                return null;
            }
        };
        this.setResourceListener(this.resourceListener);
    }

    public void tearDown() throws Exception {
        try {
            this.profileUtils.removeProfileTable("Test1110225ProfileTable");
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile table:");
            this.getLog().warning(e);
        }
        super.tearDown();
    }
}

