/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.profilemanagement;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.impl.EmptyArrays;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.slee.profile.ProfileSpecificationID;

public class ProfileCMPMethodHidingTest
extends AbstractSleeTCKTest {
    protected static final String PROFILE_TABLE_NAME = "tck.ProfileManagementTest.table";
    public static final String PROFILE_SPEC_NAME = "PMProfile";
    private ProfileUtils profileUtils;
    private boolean tableCreated = false;

    public TCKTestResult run() throws Exception {
        ProfileProvisioningMBeanProxy profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
        ProfileSpecificationID profileSpecID = new ComponentIDLookup(this.utils()).lookupProfileSpecificationID(PROFILE_SPEC_NAME, "jain.slee.tck", "1.0");
        this.getLog().info("Creating profile table: tck.ProfileManagementTest.table");
        profileProvisioning.createProfileTable(profileSpecID, PROFILE_TABLE_NAME);
        this.tableCreated = true;
        String name = "A";
        this.getLog().info("Creating profile A");
        ObjectName jmxObjectName = profileProvisioning.createProfile(PROFILE_TABLE_NAME, "A");
        this.utils().getMBeanFacade().invoke(jmxObjectName, "getValue", EmptyArrays.EMPTY_OBJECT_ARRAY, EmptyArrays.EMPTY_STRING_ARRAY);
        this.utils().getMBeanFacade().invoke(jmxObjectName, "editProfile", EmptyArrays.EMPTY_OBJECT_ARRAY, EmptyArrays.EMPTY_STRING_ARRAY);
        this.utils().getMBeanFacade().invoke(jmxObjectName, "setValue", new Object[]{"new value"}, new String[]{"java.lang.String"});
        try {
            this.utils().getMBeanFacade().invoke(jmxObjectName, "getValue2", EmptyArrays.EMPTY_OBJECT_ARRAY, EmptyArrays.EMPTY_STRING_ARRAY);
            Assert.fail(971, "Was able to invoke a CMP method that should be hidden from management clients");
        }
        catch (ReflectionException e) {
            this.getLog().info("Got expected exception: " + e);
        }
        catch (Exception e) {
            Assert.fail(971, "Got unexpected exception calling a CMP method that should be hidden from management clients: " + e);
        }
        try {
            this.utils().getMBeanFacade().invoke(jmxObjectName, "setValue2", new Object[]{"new value"}, new String[]{"java.lang.String"});
            Assert.fail(971, "Was able to invoke a CMP method that should be hidden from management clients");
        }
        catch (ReflectionException e) {
            this.getLog().info("Got expected exception: " + e);
        }
        catch (Exception e) {
            Assert.fail(971, "Got unexpected exception calling a CMP method that should be hidden from management clients: " + e);
        }
        this.utils().getMBeanFacade().invoke(jmxObjectName, "commitProfile", EmptyArrays.EMPTY_OBJECT_ARRAY, EmptyArrays.EMPTY_STRING_ARRAY);
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        String duPath = this.utils().getTestParams().getProperty("profileSpecDUPath");
        this.getLog().fine("Installing profile specification");
        this.utils().install(duPath);
        this.profileUtils = new ProfileUtils(this.utils());
    }

    public void tearDown() throws Exception {
        try {
            if (this.profileUtils != null && this.tableCreated) {
                this.getLog().fine("Removing profile table");
                this.profileUtils.removeProfileTable(PROFILE_TABLE_NAME);
            }
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile table:");
            this.getLog().warning(e);
        }
        super.tearDown();
    }
}

