/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.profileinitialstate;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import javax.slee.management.ManagementException;
import javax.slee.profile.ProfileSpecificationID;

public class Test4333Test
extends AbstractSleeTCKTest {
    private static final String TABLE_NAME = "tck.Test4333Test.table";
    private static final String PROFILE_SPEC_NAME = "Test4333Profile";
    private ProfileUtils profileUtils;
    private boolean isTableCreated;

    public TCKTestResult run() throws Exception {
        ProfileProvisioningMBeanProxy profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
        ProfileSpecificationID profileSpecID = new ComponentIDLookup(this.utils()).lookupProfileSpecificationID(PROFILE_SPEC_NAME, "jain.slee.tck", "1.0");
        this.getLog().info("Creating profile table: tck.Test4333Test.table spec=" + profileSpecID.toString());
        try {
            profileProvisioning.createProfileTable(profileSpecID, TABLE_NAME);
            this.isTableCreated = true;
            this.getLog().info("Created table ok");
        }
        catch (ManagementException e) {
            Assert.fail(4333, "When a profile table is created profileInitialize, profileStore, and profileVerify should be called in the same transaction");
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        String duPath = this.utils().getTestParams().getProperty("profileSpecDUPath");
        this.getLog().fine("Installing profile specification");
        this.utils().install(duPath);
        this.profileUtils = new ProfileUtils(this.utils());
    }

    public void tearDown() throws Exception {
        try {
            if (this.profileUtils != null && this.isTableCreated) {
                this.getLog().fine("Removing profile table");
                this.profileUtils.removeProfileTable(TABLE_NAME);
            }
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile table:");
            this.getLog().warning(e);
        }
        this.profileUtils = null;
        this.isTableCreated = false;
        super.tearDown();
    }
}

