/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.profileinitialstate;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import javax.slee.management.ManagementException;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.profile.UnrecognizedProfileTableNameException;

public class CheckProfileInitialStateTest
extends AbstractSleeTCKTest {
    private static final String TABLE_NAME = "tck.CheckProfileInitialStateTest.table";
    private static final String PROFILE_SPEC_NAME = "CheckProfileInitialState";
    private ProfileUtils profileUtils;
    private boolean isTableCreated;

    public TCKTestResult run() throws Exception {
        ProfileProvisioningMBeanProxy profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
        ProfileSpecificationID profileSpecID = new ComponentIDLookup(this.utils()).lookupProfileSpecificationID(PROFILE_SPEC_NAME, "jain.slee.tck", "1.0");
        this.getLog().info("Creating profile table: tck.CheckProfileInitialStateTest.table spec=" + profileSpecID.toString());
        try {
            profileProvisioning.createProfileTable(profileSpecID, TABLE_NAME);
            this.isTableCreated = true;
            Assert.fail(1020, "It should not be possible to create a profile table when the profile's initial state does not pass the checks in profileVerify");
        }
        catch (ManagementException e) {
            this.getLog().info("Expected exception received when trying to create a profile with initial values that do not pass the checks in profileVerify()");
        }
        try {
            this.profileUtils.getProfileProvisioningProxy().getDefaultProfile(TABLE_NAME);
            Assert.fail(1020, "It should not be possible to create a profile table when the profile's initial state does not pass the checks in profileVerify");
        }
        catch (UnrecognizedProfileTableNameException unrecognizedProfileTableNameException) {
            // empty catch block
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        String duPath = this.utils().getTestParams().getProperty("profileSpecDUPath");
        this.getLog().fine("Installing profile specification");
        this.utils().install(duPath);
        this.profileUtils = new ProfileUtils(this.utils());
    }

    public void tearDown() throws Exception {
        try {
            if (this.profileUtils != null && this.isTableCreated) {
                this.getLog().fine("Removing profile table");
                this.profileUtils.removeProfileTable(TABLE_NAME);
            }
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile table:");
            this.getLog().warning(e);
        }
        this.profileUtils = null;
        this.isTableCreated = false;
        super.tearDown();
    }
}

