/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.profileidvalidation;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import javax.slee.Address;
import javax.slee.AddressPlan;
import javax.slee.profile.ProfileID;

public class ProfileIDValidationTest
extends AbstractSleeTCKTest {
    protected static final String PROFILE_TABLE_NAME = "tck.ProfileIDValidationTest.table";
    private ProfileUtils profileUtils;
    private boolean tableCreated = false;

    public TCKTestResult run() throws Exception {
        try {
            new ProfileID("MyTable", "A");
            this.getLog().info("Created a ProfileID with valid profile table name");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(931, "Got Exception creating ProfileID with valid table name", e);
        }
        try {
            new ProfileID(new Address(AddressPlan.SLEE_PROFILE, "MyTable/A"));
            this.getLog().info("Created a ProfileID with valid AddressPlan");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(931, "Got IllegalArgumentException creating ProfileID with valid AddressPlan", e);
        }
        try {
            new ProfileID("/", "A");
            throw new TCKTestFailureException(931, "Creation of ProfileID with invalid name should produce IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            this.getLog().info("Got IllegalArgumentException creating ProfileID with '/' in table name");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(931, "Received incorrect exception creating a ProfileID with invalid table, expected IllegalArgumentException", e);
        }
        try {
            new ProfileID(new Address(AddressPlan.URI, "MyTable/A"));
            throw new TCKTestFailureException(931, "Creation of ProfileID with invalid address plan should produce IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            this.getLog().info("Got IllegalArgumentException creating ProfileID with invalid AddressPlan");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(931, "Received incorrect exception creating a ProfileID with invalid address plan, expected IllegalArgumentException", e);
        }
        this.getLog().info("Creating a valid ProfileID");
        ProfileID test = new ProfileID("MyProfile", "A");
        try {
            test.setProfileID("MyTable", "B");
            this.getLog().info("Updated a ProfileID with valid profile table name");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(931, "Got Exception updating a ProfileID with valid table name", e);
        }
        try {
            test.setProfileID("/", "A");
            throw new TCKTestFailureException(931, "Creation of ProfileID with invalid name should produce IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            this.getLog().info("Got IllegalArgumentException creating ProfileID with '/' in table name");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(931, "Received incorrect exception creating a ProfileID with invalid table name, expected IllegalArgumentException", e);
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        String duPath = this.utils().getTestParams().getProperty("profileSpecDUPath");
        this.getLog().fine("Installing profile specification");
        this.utils().install(duPath);
        this.profileUtils = new ProfileUtils(this.utils());
    }

    public void tearDown() throws Exception {
        try {
            if (this.profileUtils != null && this.tableCreated) {
                this.getLog().fine("Removing profile table");
                this.profileUtils.removeProfileTable(PROFILE_TABLE_NAME);
            }
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile table:");
            this.getLog().warning(e);
        }
        super.tearDown();
    }
}

