/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.profileabstractclass;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.util.Enumeration;
import java.util.Vector;
import javax.slee.management.ManagementException;
import javax.slee.profile.ProfileSpecificationID;
import javax.transaction.RollbackException;

public class Test1110246Test
extends AbstractSleeTCKTest {
    private static final String DU_PATH_PARAM = "DUPath";
    private static final String SPEC_NAME = "Test1110246Profile";
    private static final String SPEC_VERSION = "1.0";
    private static final String PROFILE_TABLE_NAME = "Test1110246ProfileTable";
    private ProfileUtils profileUtils;
    private Vector tablesCreated;
    private ProfileProvisioningMBeanProxy profileProvisioning;

    public TCKTestResult run() throws Exception {
        ProfileSpecificationID specID = new ProfileSpecificationID(SPEC_NAME, "jain.slee.tck", SPEC_VERSION);
        try {
            this.profileProvisioning.createProfileTable(specID, PROFILE_TABLE_NAME);
            this.tablesCreated.add(PROFILE_TABLE_NAME);
            return TCKTestResult.failed(1110246, "profileInitialize() method should be called in a transactional context. The implementation trys to mark this transaction for rollback thus causing a RollbackException to be thrown to the management client.");
        }
        catch (ManagementException e) {
            if (e.getCause() instanceof RollbackException) {
                this.getLog().fine("Caught expected exception: javax.slee.management.ManagementException with cause: javax.transaction.RollbackException");
            }
            return TCKTestResult.error("Received Management exception but cause is of wrong type: " + e.getCause().getClass().getName() + " javax.transaction.RollbackException expected");
        }
        catch (Exception e) {
            return TCKTestResult.error("Wrong type of exception received: " + e.getClass().getName() + " profileInitialize() trys to mark the transaction it is called in for rollback thus causing a " + "RollbackException to be thrown to the management client.");
        }
        try {
            this.profileProvisioning.getDefaultProfile(PROFILE_TABLE_NAME);
            return TCKTestResult.failed(11101121, "Default profile obtained successfully though it should not exist as profileInitialize() TXN context was rolled back.");
        }
        catch (Exception e) {
            this.getLog().fine("Caught expected exception: " + e);
            return TCKTestResult.passed();
        }
    }

    public void setUp() throws Exception {
        this.tablesCreated = new Vector();
        this.setupService(DU_PATH_PARAM);
        this.profileUtils = new ProfileUtils(this.utils());
        this.profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
    }

    public void tearDown() throws Exception {
        try {
            Enumeration en = this.tablesCreated.elements();
            while (en.hasMoreElements()) {
                this.profileUtils.removeProfileTable((String)en.nextElement());
            }
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile table:");
            this.getLog().warning(e);
        }
        super.tearDown();
    }
}

