/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.noevents;

import com.opencloud.logging.Logable;
import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.OperationTimedOutException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.QueuingResourceListener;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import javax.management.Attribute;
import javax.management.ObjectName;
import javax.slee.profile.ProfileAddedEvent;
import javax.slee.profile.ProfileRemovedEvent;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.profile.ProfileUpdatedEvent;

public class Test1110041_1Test
extends AbstractSleeTCKTest {
    private static final String PROFILE_TABLE_NAME = "Test1110041_1ProfileTable";
    private static final String PROFILE_NAME = "Test1110041_1Profile";
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final String PROFILE_SPEC_NAME = "Test1110041ProfileWithEvents";
    private static final String PROFILE_SPEC_VERSION = "1.0";
    private QueuingResourceListener resourceListener;
    private ProfileProvisioningMBeanProxy profileProvisioning;

    public TCKTestResult run() throws Exception {
        TCKSbbMessage reply;
        Logable log = this.utils().getLog();
        ProfileSpecificationID profSpecID = new ProfileSpecificationID(PROFILE_SPEC_NAME, "jain.slee.tck", PROFILE_SPEC_VERSION);
        this.profileProvisioning.createProfileTable(profSpecID, PROFILE_TABLE_NAME);
        log.fine("Created profile table Test1110041_1ProfileTable for profile specification " + profSpecID.getName() + " " + profSpecID.getVersion() + ", " + profSpecID.getVendor());
        ObjectName profile = this.profileProvisioning.createProfile(PROFILE_TABLE_NAME, PROFILE_NAME);
        ProfileMBeanProxy profProxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
        profProxy.commitProfile();
        this.getLog().fine("Adding profile Test1110041_1Profile to the profile table");
        try {
            reply = this.resourceListener.nextMessage();
            if (!ProfileAddedEvent.class.getName().equals(reply.getMessage())) {
                return TCKTestResult.error("Received unexpected reply from SBB after adding a profile. Message=" + reply.getMessage());
            }
        }
        catch (OperationTimedOutException ex) {
            return TCKTestResult.failed(new TCKTestFailureException(1110041, "Timed out waiting for acknowledgement of a ProfileAddedEvent following the addition of a profile.", ex));
        }
        this.getLog().fine("Received proper ACK msg from Sbb for profile added operation.");
        profile = this.profileProvisioning.getProfile(PROFILE_TABLE_NAME, PROFILE_NAME);
        profProxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
        profProxy.editProfile();
        this.utils().getMBeanFacade().setAttribute(profile, new Attribute("Value", new Integer(42)));
        log.fine("Set 'value' to '42'");
        profProxy.commitProfile();
        try {
            reply = this.resourceListener.nextMessage();
            if (!ProfileUpdatedEvent.class.getName().equals(reply.getMessage())) {
                return TCKTestResult.error("Received unexpected reply from SBB after updating a profile. Message=" + reply.getMessage());
            }
        }
        catch (OperationTimedOutException ex) {
            return TCKTestResult.failed(new TCKTestFailureException(1110041, "Timed out waiting for acknowledgement of a ProfileUpdatedEvent following the commit of changes to a profile.", ex));
        }
        this.getLog().fine("Received proper ACK msg from Sbb for profile updated operation.");
        this.getLog().fine("Removing profile Test1110041_1Profile from the profile table");
        this.profileProvisioning.removeProfile(PROFILE_TABLE_NAME, PROFILE_NAME);
        try {
            reply = this.resourceListener.nextMessage();
            if (!ProfileRemovedEvent.class.getName().equals(reply.getMessage())) {
                return TCKTestResult.error("Received unexpected reply from SBB after removing a profile. Message=" + reply.getMessage());
            }
        }
        catch (OperationTimedOutException ex) {
            return TCKTestResult.failed(new TCKTestFailureException(1110041, "Timed out waiting for acknowledgement of a ProfileRemovedEvent following the removal of a profile.", ex));
        }
        this.getLog().fine("Received proper ACK msg from Sbb for profile removed operation.");
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        this.setupService(SERVICE_DU_PATH_PARAM);
        this.resourceListener = new QueuingResourceListener(this.utils());
        this.setResourceListener(this.resourceListener);
        this.profileProvisioning = new ProfileUtils(this.utils()).getProfileProvisioningProxy();
    }

    public void tearDown() throws Exception {
        try {
            this.profileProvisioning.removeProfileTable(PROFILE_TABLE_NAME);
        }
        catch (Exception e) {
            this.getLog().warning("Exception occured when trying to remove profile table: ");
            this.getLog().warning(e);
        }
        super.tearDown();
    }
}

