/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.lifecycle;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.profileutils.BaseMessageAdapter;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import javax.management.Attribute;
import javax.management.ObjectName;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.profile.UnrecognizedProfileNameException;

public class Test1110305Test
extends AbstractSleeTCKTest {
    private static final String DU_PATH_PARAM = "DUPath";
    private static final String SPEC_NAME = "Test1110305Profile";
    private static final String SPEC_VERSION = "1.0";
    private ProfileUtils profileUtils;
    private ProfileProvisioningMBeanProxy profileProvisioning;
    private RMIObjectChannel in;
    private FutureResult futureResult;
    private TCKTestResult exResult;

    public TCKTestResult run() throws Exception {
        ObjectName profile;
        ProfileSpecificationID specID = new ProfileSpecificationID(SPEC_NAME, "jain.slee.tck", SPEC_VERSION);
        this.profileProvisioning.createProfileTable(specID, "Test1110305ProfileTable");
        this.getLog().fine("Added profile table Test1110305ProfileTable based on profile spec Test1110305Profile");
        this.addProfile("BusinessProfile", "ThrowException");
        this.addProfile("ManagementProfile", "ThrowException");
        this.addProfile("LifecycleProfile", "Init");
        this.getLog().fine("Cause Sbb to call a business method...");
        this.futureResult = new FutureResult(this.getLog());
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity(this.getClass().getName());
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", null, activityID, null);
        TCKTestResult res = this.futureResult.waitForResult(this.utils().getTestTimeout());
        if (!res.isPassed()) {
            return res;
        }
        this.getLog().fine("Check whether profile BusinessProfile still exists.");
        try {
            profile = this.profileProvisioning.getProfile("Test1110305ProfileTable", "BusinessProfile");
            this.utils().getMBeanFacade().getAttribute(profile, "Value");
            this.getLog().fine("BusinessProfile still exists.");
        }
        catch (UnrecognizedProfileNameException e) {
            return TCKTestResult.failed(1110307, "BusinessProfile should still exist after its previously associated profile object has been invalidated.");
        }
        catch (Exception e) {
            return TCKTestResult.error("Unexpected behaviour when looking for profile BusinessProfile", e);
        }
        this.getLog().fine("Call management method...");
        profile = this.profileProvisioning.getProfile("Test1110305ProfileTable", "ManagementProfile");
        try {
            this.utils().getMBeanFacade().invoke(profile, "manage", new Object[0], new String[0]);
            return TCKTestResult.error("Call to management method should have caused an exception as management method throws an unchecked exception.");
        }
        catch (Exception e) {
            this.getLog().fine("Call to management method failed as expected." + e);
            this.getLog().fine("Check whether profile ManagementProfile still exists.");
            try {
                profile = this.profileProvisioning.getProfile("Test1110305ProfileTable", "ManagementProfile");
                this.utils().getMBeanFacade().getAttribute(profile, "Value");
                this.getLog().fine("ManagementProfile still exists.");
            }
            catch (UnrecognizedProfileNameException e2) {
                return TCKTestResult.failed(1110307, "ManagementProfile should still exist after its previously associated profile object has been invalidated.");
            }
            catch (Exception e3) {
                return TCKTestResult.error("Unexpected behaviour when looking for profile ManagementProfile", e3);
            }
            this.getLog().fine("Start TXN to modify profile LifecycleProfile");
            profile = this.profileProvisioning.getProfile("Test1110305ProfileTable", "LifecycleProfile");
            ProfileMBeanProxy profileProxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
            profileProxy.editProfile();
            this.getLog().fine("Set CMP field to ThrowException");
            this.utils().getMBeanFacade().setAttribute(profile, new Attribute("Value", "ThrowException"));
            this.getLog().fine("Cause call to lifecycle method profileVerify...");
            try {
                profileProxy.commitProfile();
                return TCKTestResult.error("Committing profile should have caused an exception due to profileVerify throwing a RuntimeException.");
            }
            catch (Exception e4) {
                this.getLog().fine("Committing profile LifecycleProfile failed as expected: " + e4);
                if (profileProxy.isProfileWriteable()) {
                    this.getLog().fine("Restore profile.");
                    profileProxy.restoreProfile();
                }
                this.getLog().fine("Check whether profile LifecycleProfile still exists.");
                try {
                    profile = this.profileProvisioning.getProfile("Test1110305ProfileTable", "LifecycleProfile");
                    this.getLog().fine("Obtain CMP field value from profile.");
                    this.utils().getMBeanFacade().getAttribute(profile, "Value");
                }
                catch (UnrecognizedProfileNameException e5) {
                    return TCKTestResult.failed(1110307, "LifecycleProfile should still exist after its previously associated profile object has been invalidated.");
                }
                catch (Exception e6) {
                    return TCKTestResult.error("Unexpected behaviour when looking for profile LifecycleProfile", e6);
                }
                if (this.exResult != null) {
                    return this.exResult;
                }
                return TCKTestResult.passed();
            }
        }
    }

    private void addProfile(String profileName, String initValue) throws Exception {
        ObjectName profile = this.profileProvisioning.createProfile("Test1110305ProfileTable", profileName);
        ProfileMBeanProxy profileProxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
        this.getLog().fine("Created profile " + profileName + " for profile table " + "Test1110305ProfileTable");
        this.utils().getMBeanFacade().setAttribute(profile, new Attribute("Value", initValue));
        this.getLog().fine("Set CMP value for " + profileName + " to " + initValue);
        profileProxy.commitProfile();
        profileProxy.closeProfile();
    }

    public void setPassed(int assertionID, String msg) {
        this.getLog().fine(assertionID + ": " + msg);
        if (this.futureResult != null && !this.futureResult.isSet()) {
            this.futureResult.setPassed();
        }
    }

    public void setFailed(int assertionID, String msg, Exception e) {
        if (e == null) {
            this.getLog().fine("FAILURE: " + assertionID + ":" + msg);
            if (this.futureResult != null && !this.futureResult.isSet()) {
                this.futureResult.setFailed(assertionID, msg);
            }
            this.setIfEmpty(TCKTestResult.failed(assertionID, msg));
        } else {
            this.getLog().fine("FAILURE: " + assertionID + ":" + msg);
            this.getLog().fine(e);
            if (this.futureResult != null && !this.futureResult.isSet()) {
                this.futureResult.setFailed(new TCKTestFailureException(assertionID, msg, e));
            }
            this.setIfEmpty(TCKTestResult.failed(new TCKTestFailureException(assertionID, msg, e)));
        }
    }

    public void setError(String msg, Exception e) {
        if (e == null) {
            this.getLog().warning(msg);
            if (this.futureResult != null && !this.futureResult.isSet()) {
                this.futureResult.setError(msg);
            }
            this.setIfEmpty(TCKTestResult.error(msg));
        } else {
            this.getLog().warning(msg);
            this.getLog().warning(e);
            if (this.futureResult != null && !this.futureResult.isSet()) {
                this.futureResult.setError(msg, e);
            }
            this.setIfEmpty(TCKTestResult.error(msg, e));
        }
    }

    public void setUp() throws Exception {
        this.setupService(DU_PATH_PARAM);
        this.in = this.utils().getRMIObjectChannel();
        this.in.setMessageHandler(new BaseMessageAdapter(this.getLog()){

            public void onSetPassed(int assertionID, String msg) {
                Test1110305Test.this.setPassed(assertionID, msg);
            }

            public void onSetFailed(int assertionID, String msg, Exception e) {
                Test1110305Test.this.setFailed(assertionID, msg, e);
            }

            public void onLogCall(String msg) {
                Test1110305Test.this.getLog().fine(msg);
            }

            public void onSetError(String msg, Exception e) {
                Test1110305Test.this.setError(msg, e);
            }
        });
        this.profileUtils = new ProfileUtils(this.utils());
        this.profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
    }

    public void tearDown() throws Exception {
        try {
            this.profileUtils.removeProfileTable("Test1110305ProfileTable");
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile table:");
            this.getLog().warning(e);
        }
        super.tearDown();
    }

    private void setIfEmpty(TCKTestResult exResult) {
        if (this.exResult == null) {
            this.exResult = exResult;
        }
    }
}

