/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.lifecycle;

import com.opencloud.logging.StdErrLog;
import com.opencloud.sleetck.lib.profileutils.BaseMessageSender;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.rautils.TCKRAUtils;
import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import com.opencloud.sleetck.lib.testsuite.profiles.lifecycle.Test1110305ProfileLocal;
import javax.naming.Context;
import javax.slee.ActivityContextInterface;
import javax.slee.RolledBackContext;
import javax.slee.SbbContext;
import javax.slee.profile.ProfileFacility;
import javax.slee.profile.ProfileTable;

public abstract class Test1110305Sbb
extends BaseTCKSbb {
    public static final String PROFILE_TABLE_NAME = "Test1110305ProfileTable";
    public static final String BUSINESS_PROFILE = "BusinessProfile";
    public static final String MANAGEMENT_PROFILE = "ManagementProfile";
    public static final String LIFECYCLE_PROFILE = "LifecycleProfile";
    private RMIObjectChannel out;
    private BaseMessageSender msgSender;

    public void setSbbContext(SbbContext context) {
        super.setSbbContext(context);
        try {
            this.out = TCKRAUtils.lookupRMIObjectChannel();
            this.msgSender = new BaseMessageSender(this.out, new StdErrLog());
        }
        catch (Exception e) {
            context.getTracer(this.getSbbID().getName()).fine("An error occured creating an RMIObjectChannel:", (Throwable)e);
        }
    }

    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci) {
        try {
            Context env = TCKSbbUtils.getSbbEnvironment();
            ProfileFacility profileFacility = (ProfileFacility)env.lookup("slee/facilities/profile");
            this.msgSender.sendLogMsg("Obtained profileFacility object.");
            ProfileTable profileTable = profileFacility.getProfileTable(PROFILE_TABLE_NAME);
            this.msgSender.sendLogMsg("Obtained profileTable object.");
            Test1110305ProfileLocal profileLocal = (Test1110305ProfileLocal)profileTable.find(BUSINESS_PROFILE);
            this.msgSender.sendLogMsg("Obtained profileLocal object.");
            try {
                profileLocal.business();
                this.msgSender.sendError("Exception should have occured as business method throws an unchecked exception.");
                return;
            }
            catch (Exception e) {
                this.msgSender.sendLogMsg("Exception occurred as expected: " + e);
            }
        }
        catch (Exception e) {
            this.msgSender.sendException(e);
        }
    }

    public void sbbRolledBack(RolledBackContext context) {
        this.msgSender.sendSuccess(1110305, "Test completed as expected");
    }
}

