/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.creation;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.util.Collection;
import javax.management.ObjectName;
import javax.slee.profile.ProfileAlreadyExistsException;
import javax.slee.profile.ProfileID;
import javax.slee.profile.ProfileSpecificationID;

public class CreateManyProfilesTest
extends AbstractSleeTCKTest {
    private static final String PROFILE_TABLE_NAME = "tck.CreateManyProfilesTest.table";
    private ProfileUtils profileUtils;
    private boolean tableCreated = false;

    public TCKTestResult run() throws Exception {
        ProfileProvisioningMBeanProxy profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
        ProfileSpecificationID profileSpecID = new ComponentIDLookup(this.utils()).lookupProfileSpecificationID("SimpleProfile", "jain.slee.tck", "1.0");
        this.getLog().info("Creating profile table: tck.CreateManyProfilesTest.table");
        profileProvisioning.createProfileTable(profileSpecID, PROFILE_TABLE_NAME);
        this.tableCreated = true;
        String[] profileNames = new String[]{"profile1", "profile2", "profile3"};
        int profilesCount = profileNames.length;
        for (int i = 0; i < profilesCount; ++i) {
            try {
                this.getLog().info("Creating profile number " + (i + 1) + ": " + profileNames[i]);
                ObjectName profile = profileProvisioning.createProfile(PROFILE_TABLE_NAME, profileNames[i]);
                ProfileMBeanProxy profProxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
                profProxy.commitProfile();
                continue;
            }
            catch (ProfileAlreadyExistsException ex) {
                return TCKTestResult.failed(913, "ProfileAlreadyExistsException caught during creation of profile number " + (i + 1) + " in table");
            }
        }
        Collection profiles = profileProvisioning.getProfiles(PROFILE_TABLE_NAME);
        this.getLog().info("Checking profiles in table");
        if (profiles.size() != profilesCount) {
            return TCKTestResult.failed(913, "Profile claims to have " + profiles.size() + " profiles, after creating " + profilesCount + " profiles");
        }
        for (int i = 0; i < profilesCount; ++i) {
            if (profiles.contains(new ProfileID(PROFILE_TABLE_NAME, profileNames[i]))) continue;
            return TCKTestResult.failed(913, "Profile " + profileNames[i] + " did not remain in the profile table after adding a total of " + profilesCount + " profiles");
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        String duPath = this.utils().getTestParams().getProperty("profileSpecDUPath");
        this.getLog().fine("Installing profile specification");
        this.utils().install(duPath);
        this.profileUtils = new ProfileUtils(this.utils());
    }

    public void tearDown() throws Exception {
        try {
            if (this.profileUtils != null && this.tableCreated) {
                this.getLog().fine("Removing profile table");
                this.profileUtils.removeProfileTable(PROFILE_TABLE_NAME);
            }
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile table:");
            this.getLog().warning(e);
        }
        super.tearDown();
    }
}

