/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.creation;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.slee.profile.ProfileSpecificationID;

public class CreateManyProfileTablesTest
extends AbstractSleeTCKTest {
    private static final String PROFILE_TABLE_NAME_A = "tck.CreateManyProfileTablesTest.tableA";
    private static final String PROFILE_TABLE_NAME_B = "tck.CreateManyProfileTablesTest.tableB";
    private static final String PROFILE_TABLE_NAME_C = "tck.CreateManyProfileTablesTest.tableC";
    private ProfileUtils profileUtils;
    private Vector tablesCreated;

    public TCKTestResult run() throws Exception {
        ProfileProvisioningMBeanProxy profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
        ProfileSpecificationID profileSpecID = new ComponentIDLookup(this.utils()).lookupProfileSpecificationID("SimpleProfile", "jain.slee.tck", "1.0");
        String[] tableNames = new String[]{PROFILE_TABLE_NAME_A, PROFILE_TABLE_NAME_B, PROFILE_TABLE_NAME_C};
        this.tablesCreated = new Vector();
        for (int i = 0; i < tableNames.length; ++i) {
            this.getLog().info("Creating profile table: " + tableNames[i]);
            profileProvisioning.createProfileTable(profileSpecID, tableNames[i]);
            this.tablesCreated.addElement(tableNames[i]);
        }
        Collection profileTables = profileProvisioning.getProfileTables();
        for (int i = 0; i < tableNames.length; ++i) {
            if (profileTables.contains(tableNames[i])) continue;
            return TCKTestResult.failed(912, "Profile table " + tableNames[i] + " did not remain in the SLEE after adding a total of " + tableNames.length + " profile tables");
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        String duPath = this.utils().getTestParams().getProperty("profileSpecDUPath");
        this.getLog().fine("Installing profile specification");
        this.utils().install(duPath);
        this.profileUtils = new ProfileUtils(this.utils());
    }

    public void tearDown() throws Exception {
        if (this.profileUtils != null && this.tablesCreated != null && !this.tablesCreated.isEmpty()) {
            this.getLog().fine("Removing profile tables");
            Iterator tablesCreatedIter = this.tablesCreated.iterator();
            while (tablesCreatedIter.hasNext()) {
                String tableName = (String)tablesCreatedIter.next();
                try {
                    this.profileUtils.removeProfileTable(tableName);
                }
                catch (Exception ex) {
                    this.getLog().warning("Caught Exception while trying to remove profile table " + tableName + ":");
                    this.getLog().warning(ex);
                }
            }
        }
        super.tearDown();
    }
}

