/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testsuite.profiles.profileverification.IndexedProfileManagementProxy;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.util.Iterator;
import java.util.Vector;
import javax.management.ObjectName;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.profile.UnrecognizedProfileNameException;
import javax.slee.profile.UnrecognizedProfileTableNameException;

public class Test1117Test
extends AbstractSleeTCKTest {
    private static final String PROFILE_TABLE_NAME = "tck.Test1117Test.table";
    private ProfileUtils profileUtils;
    private boolean tableCreated = false;
    private Vector activeProxies;

    public TCKTestResult run() throws Exception {
        ProfileProvisioningMBeanProxy profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
        ProfileSpecificationID profileSpecID = new ComponentIDLookup(this.utils()).lookupProfileSpecificationID("SimpleProfile", "jain.slee.tck", "1.0");
        this.getLog().info("Creating profile table: tck.Test1117Test.table");
        profileProvisioning.createProfileTable(profileSpecID, PROFILE_TABLE_NAME);
        this.tableCreated = true;
        ObjectName jmx = this.profileUtils.getProfileProvisioningProxy().getDefaultProfile(PROFILE_TABLE_NAME);
        Assert.assertTrue(1117, "getDefaultProfile returned null, expected the ObjectName for the default profile of the specified table", jmx != null);
        Assert.assertTrue(1117, "getDefaultProfile returned the ObjectName of a profile MBean that is not registered with the MBean server", this.utils().getMBeanFacade().isRegistered(jmx));
        jmx = this.profileUtils.getProfileProvisioningProxy().createProfile(PROFILE_TABLE_NAME, "A");
        this.getProfileProxy(jmx).commitProfile();
        ObjectName jmx2 = this.profileUtils.getProfileProvisioningProxy().getProfile(PROFILE_TABLE_NAME, "A");
        Assert.assertTrue(1117, "getProfile returned null, expecting the ObjectName of the specified profile", jmx2 != null);
        Assert.assertTrue(1117, "createProfile returned the ObjectName of a profile MBean that is not registered with the MBean server", this.utils().getMBeanFacade().isRegistered(jmx));
        Assert.assertTrue(1117, "getProfile returned the ObjectName of a profile MBean that is not registered with the MBean server", this.utils().getMBeanFacade().isRegistered(jmx2));
        jmx = this.profileUtils.getProfileProvisioningProxy().createProfile(PROFILE_TABLE_NAME, "B");
        this.getProfileProxy(jmx).commitProfile();
        ObjectName jmx3 = this.profileUtils.getProfileProvisioningProxy().getProfile(PROFILE_TABLE_NAME, "B");
        Assert.assertTrue(1117, "getProfile returned identical ObjectName's for different profiles", !jmx2.equals(jmx3));
        try {
            this.profileUtils.getProfileProvisioningProxy().getDefaultProfile("non-existant_table");
            Assert.fail(1117, "getDefaultProfile should throw UnrecognizedProfileTableNameException if invoked with a non-existant profile table");
        }
        catch (UnrecognizedProfileTableNameException e) {
            // empty catch block
        }
        try {
            this.profileUtils.getProfileProvisioningProxy().getProfile("non-existant_table", "A");
            Assert.fail(1117, "getProfile should throw UnrecognizedProfileTableNameException if invoked with a non-existant profile table");
        }
        catch (UnrecognizedProfileTableNameException e) {
            // empty catch block
        }
        try {
            this.profileUtils.getProfileProvisioningProxy().getProfile(PROFILE_TABLE_NAME, "X");
            Assert.fail(1117, "getProfile should throw UnrecognizedProfileNameException if invoked with a non-existant profile table");
        }
        catch (UnrecognizedProfileNameException e) {
            // empty catch block
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        String duPath = this.utils().getTestParams().getProperty("profileSpecDUPath");
        this.getLog().fine("Installing profile specification");
        this.utils().install(duPath);
        this.profileUtils = new ProfileUtils(this.utils());
        this.activeProxies = new Vector();
    }

    public void tearDown() throws Exception {
        if (this.activeProxies != null) {
            this.getLog().fine("Closing profiles");
            Iterator activeProxiesIter = this.activeProxies.iterator();
            while (activeProxiesIter.hasNext()) {
                IndexedProfileManagementProxy aProxy = (IndexedProfileManagementProxy)activeProxiesIter.next();
                try {
                    if (aProxy == null) continue;
                    if (aProxy.isProfileWriteable()) {
                        aProxy.restoreProfile();
                    }
                    aProxy.closeProfile();
                }
                catch (Exception ex) {
                    this.getLog().warning("Exception caught while trying to close profiles:");
                    this.getLog().warning(ex);
                }
            }
        }
        try {
            if (this.profileUtils != null && this.tableCreated) {
                this.getLog().fine("Removing profile table");
                this.profileUtils.removeProfileTable(PROFILE_TABLE_NAME);
            }
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile table:");
            this.getLog().warning(e);
        }
        super.tearDown();
    }

    private IndexedProfileManagementProxy getProfileProxy(ObjectName mbeanName) {
        IndexedProfileManagementProxy rProxy = new IndexedProfileManagementProxy(mbeanName, this.utils().getMBeanFacade());
        this.activeProxies.addElement(rProxy);
        return rProxy;
    }
}

