/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.sleestate;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.OperationTimedOutException;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.SleeStarter;
import com.opencloud.sleetck.lib.testutils.jmx.SleeManagementMBeanProxy;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Set;
import javax.slee.management.ManagementException;
import javax.slee.management.SleeState;

public class EventsDeliveredWhileStoppingTest
extends AbstractSleeTCKTest {
    private ResourceListenerImpl resourceListener;
    private TCKResourceTestInterface resource;
    private TCKActivityID activityID;
    private long x1EventObjectID;
    private String secondEventTypeName;
    private int secondEventCallCode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCKTestResult run() throws Exception {
        try {
            this.resourceListener.resetState();
            this.getLog().info("Firing an initial event on an activity to attach an Sbb to the activity");
            this.activityID = this.resource.createActivity("tck.CreateActivityWhileStoppingTest.Activity");
            ResourceListenerImpl resourceListenerImpl = this.resourceListener;
            synchronized (resourceListenerImpl) {
                this.x1EventObjectID = this.resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", null, this.activityID, null);
            }
            try {
                this.resourceListener.waitForACKOrFailure(1);
                this.getLog().info("The Sbb is attached to the activity");
            }
            catch (OperationTimedOutException ex) {
                throw new TCKTestErrorException("Timed out while waiting for the Sbb to receive the first event");
            }
            SleeManagementMBeanProxy management = this.utils().getSleeManagementMBeanProxy();
            this.getLog().info("Calling SleeManagementMBean.stop()");
            management.stop();
            this.getLog().info("Current state: " + management.getState());
            this.testEventDelivery("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2", 2, 1982, "Fire an event on an existing activity to an Sbb entity created in the SLEE_RUNNING state");
        }
        finally {
            this.getLog().info("Ending the activity used to stall the transition to the STOPPING state");
            this.endActivitySilent(this.activityID);
            this.getLog().info("Restarting the SLEE");
            SleeStarter.startSlee(this.utils().getSleeManagementMBeanProxy(), this.utils().getTestTimeout());
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        this.resource = this.utils().getResourceInterface();
        this.resourceListener = new ResourceListenerImpl();
        this.setResourceListener(this.resourceListener);
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.resourceListener = null;
        this.resource = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testEventDelivery(String eventTypeName, int expectedACKCode, int assertionID, String testCase) throws Exception {
        if (this.checkStoppingState()) {
            this.getLog().info("Executing test case: " + testCase);
            this.getLog().info("Firing a " + eventTypeName + " event");
            ResourceListenerImpl resourceListenerImpl = this.resourceListener;
            synchronized (resourceListenerImpl) {
                this.secondEventTypeName = eventTypeName;
                this.secondEventCallCode = expectedACKCode;
            }
            this.resource.fireEvent(eventTypeName, null, this.activityID, null);
            try {
                this.resourceListener.waitForACKOrFailure(expectedACKCode);
                this.getLog().info("Received ACK for event");
                return true;
            }
            catch (OperationTimedOutException ex) {
                if (this.resourceListener.hasActivityEnded()) {
                    this.getLog().warning("The event was not delivered, because the activity on which the event was fired was ended by the SLEE");
                    return false;
                }
                throw new TCKTestFailureException(assertionID, "Timed out while waiting for an event to be delivered in the STOPPING state. The activity on which it was fired has not yet been ended. Test case: " + testCase, ex);
            }
        }
        return false;
    }

    private boolean checkStoppingState() throws TCKTestErrorException, TCKTestFailureException, ManagementException {
        SleeState currentState = this.utils().getSleeManagementMBeanProxy().getState();
        if (currentState.isStopping()) {
            return true;
        }
        if (currentState.isStopped()) {
            if (!this.resourceListener.hasActivityEnded()) {
                throw new TCKTestFailureException(1886, "The SLEE moved to the STOPPED state before all activities were ended (no callback was received to indicate that the activity context had been moved to the invalid state)");
            }
            this.getLog().warning("The SLEE ended the activity context, then transitioned to the STOPPED state. This prevents the continuation of this test, but it is valid behaviour for the SLEE.");
            return false;
        }
        throw new TCKTestErrorException("The SLEE is not in the STOPPING or STOPPED state. Current state=" + currentState + ". This indicates either a call to start the SLEE " + "by a third party, or an illegal stontaneous state transition by the SLEE.");
    }

    private void endActivitySilent(TCKActivityID activityToEnd) {
        if (activityToEnd != null) {
            try {
                if (this.resource.isLive(activityToEnd)) {
                    this.resource.endActivity(activityToEnd);
                }
            }
            catch (Exception ex) {
                this.getLog().warning("Received Exception while trying to end TCKActivity " + activityToEnd + ". Exception:");
                this.getLog().warning(ex);
            }
        }
    }

    private String formatCode(int sbbCallCode) {
        switch (sbbCallCode) {
            case 1: {
                return "SBB1_RECEIVED_X1";
            }
            case 2: {
                return "SBB1_RECEIVED_X2";
            }
        }
        return "(Unrecognized Sbb call code: " + sbbCallCode + ")";
    }

    private class ResourceListenerImpl
    extends BaseTCKResourceListener {
        private boolean hasActivityEnded;
        private Set receivedACKs = new HashSet();
        private Exception failureOrError;

        private ResourceListenerImpl() {
        }

        public synchronized Object onSbbCall(Object argument) throws Exception {
            try {
                Integer callCode = (Integer)argument;
                EventsDeliveredWhileStoppingTest.this.getLog().info("Received event ACK from Sbb. ACK type:" + EventsDeliveredWhileStoppingTest.this.formatCode(callCode));
                this.receivedACKs.add(callCode);
                this.notifyAll();
            }
            catch (Exception ex) {
                this.onException(ex);
            }
            return null;
        }

        public synchronized void onEventProcessingSuccessful(long eventObjectID) throws RemoteException {
            EventsDeliveredWhileStoppingTest.this.getLog().info("onEventProcessingSuccessful(eventObjectID=" + eventObjectID + ")");
            if (eventObjectID != EventsDeliveredWhileStoppingTest.this.x1EventObjectID && !this.isSecondEventACKReceived()) {
                this.onSecondEventNotDelivered();
            }
        }

        public synchronized void onEventProcessingFailed(long eventObjectID, String message, Exception exception) {
            EventsDeliveredWhileStoppingTest.this.getLog().info("onEventProcessingFailed(eventObjectID=" + eventObjectID + ", message=" + message);
            if (eventObjectID == EventsDeliveredWhileStoppingTest.this.x1EventObjectID) {
                StringBuffer buf = new StringBuffer("Received onEventProcessingFailed() callback for X1 event");
                if (message != null) {
                    buf.append(message);
                }
                this.onException(new TCKTestErrorException(buf.toString(), exception));
            } else if (!this.isSecondEventACKReceived()) {
                this.onSecondEventNotDelivered();
            }
        }

        public synchronized void onActivityContextInvalid(TCKActivityID activityID) {
            if (((Object)activityID).equals(activityID)) {
                this.hasActivityEnded = true;
                EventsDeliveredWhileStoppingTest.this.getLog().info("ResourceListenerImpl: received notification of activity end for the activity");
            } else {
                this.onException(new TCKTestErrorException("Received unexpected onActivityContextInvalid() callback for activity: " + activityID));
            }
        }

        public synchronized void onException(Exception e) {
            EventsDeliveredWhileStoppingTest.this.utils().getLog().warning("Received Exception from resource:");
            EventsDeliveredWhileStoppingTest.this.utils().getLog().warning(e);
            if (this.failureOrError != null) {
                this.failureOrError = e;
            }
            this.notifyAll();
        }

        public synchronized void waitForACKOrFailure(int code) throws Exception {
            Integer wrappedCode = new Integer(code);
            long now = System.currentTimeMillis();
            long timeoutAt = now + (long)EventsDeliveredWhileStoppingTest.this.utils().getTestTimeout();
            while (now < timeoutAt && !this.receivedACKs.contains(wrappedCode) && this.failureOrError == null) {
                try {
                    this.wait(timeoutAt - now);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                now = System.currentTimeMillis();
            }
            if (this.failureOrError != null) {
                throw this.failureOrError;
            }
            if (!this.receivedACKs.contains(wrappedCode)) {
                throw new OperationTimedOutException("Timed out while waiting for ACK from Sbb. Expected ACK code: " + EventsDeliveredWhileStoppingTest.this.formatCode(code));
            }
        }

        public synchronized boolean hasActivityEnded() {
            return this.hasActivityEnded;
        }

        public synchronized boolean isSecondEventACKReceived() {
            return this.receivedACKs.contains(new Integer(EventsDeliveredWhileStoppingTest.this.secondEventCallCode));
        }

        public synchronized void resetState() {
            this.hasActivityEnded = false;
            this.receivedACKs.clear();
        }

        private synchronized void onSecondEventNotDelivered() {
            if (this.hasActivityEnded()) {
                EventsDeliveredWhileStoppingTest.this.getLog().info("Event delivery failed for " + EventsDeliveredWhileStoppingTest.this.secondEventTypeName + " event, after the stalling " + "activity ended. Allow this: as the SLEE may have stopped after the activity ended. " + "Will allow the test to timeout...");
            } else {
                this.failureOrError = new TCKTestErrorException("Event delivery failed for " + EventsDeliveredWhileStoppingTest.this.secondEventTypeName + " event, " + "before the stalling activity ended");
            }
        }
    }
}

