/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.sleestate;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.OperationTimedOutException;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.SleeStarter;
import com.opencloud.sleetck.lib.testutils.jmx.SleeManagementMBeanProxy;
import com.opencloud.util.Future;
import java.rmi.RemoteException;
import javax.slee.management.SleeState;
import javax.slee.profile.ProfileSpecificationID;

public class CreateActivityWhileStoppingTest
extends AbstractSleeTCKTest {
    private static final int PROFILE_TABLE_ACTIVITY = 1;
    private static final int NULL_ACTIVITY = 3;
    private static final int TCK_ACTIVITY = 4;
    private ProfileSpecificationID profileSpecID;
    private ProfileUtils profileUtils;
    private ResourceListenerImpl resourceListener;
    private TCKActivityID stallingActivityID;
    private FutureResult testCaseResult;
    private long x1EventObjectID;
    private long x2EventObjectID;
    private long y1EventObjectID;
    private boolean isSecondEventACKReceived;
    private boolean isTestingCreateTCKActivity;

    public TCKTestResult run() throws Exception {
        int[] activityTypes = new int[]{3, 1, 4};
        TCKTestResult rResult = null;
        for (int i = 0; i < activityTypes.length && (rResult = this.testCreateActivity(activityTypes[i])).isPassed(); ++i) {
        }
        return rResult;
    }

    public void setUp() throws Exception {
        this.resourceListener = new ResourceListenerImpl();
        this.setResourceListener(this.resourceListener);
        this.profileUtils = new ProfileUtils(this.utils());
        this.utils().install(this.utils().getTestParams().getProperty("profileSpecDUPath"));
        this.profileSpecID = new ComponentIDLookup(this.utils()).lookupProfileSpecificationID("SimpleProfile", "jain.slee.tck", "1.0");
        super.setUp();
    }

    public void tearDown() throws Exception {
        this.resourceListener = null;
        this.profileUtils = null;
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TCKTestResult testCreateActivity(int activityType) throws Exception {
        try {
            this.isSecondEventACKReceived = false;
            this.isTestingCreateTCKActivity = false;
            this.resourceListener.resetFlags();
            this.getLog().info("Firing an event on an activity to attach an Sbb to the activity");
            this.stallingActivityID = this.utils().getResourceInterface().createActivity("tck.CreateActivityWhileStoppingTest.StallingActivity." + activityType);
            ResourceListenerImpl resourceListenerImpl = this.resourceListener;
            synchronized (resourceListenerImpl) {
                this.x1EventObjectID = this.utils().getResourceInterface().fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", null, this.stallingActivityID, null);
            }
            this.waitForSbbAttach();
            this.getLog().info("The Sbb is attached to the activity");
            SleeManagementMBeanProxy management = this.utils().getSleeManagementMBeanProxy();
            this.getLog().info("Calling SleeManagementMBean.stop()");
            management.stop();
            SleeState currentState = management.getState();
            if (!currentState.isStopping()) {
                throw new TCKTestErrorException("Couldn't test STOPPING state semantics, because the SLEE was not in the STOPPING state following stop(). Current state: " + currentState);
            }
            this.getLog().info("Current state: " + currentState);
            this.testCaseResult = new FutureResult(this.getLog());
            switch (activityType) {
                case 1: {
                    TCKTestResult tCKTestResult = this.testCreateProfileTableActivity();
                    return tCKTestResult;
                }
                case 3: {
                    TCKTestResult tCKTestResult = this.testCreateNullActivity();
                    return tCKTestResult;
                }
                case 4: {
                    TCKTestResult tCKTestResult = this.testCreateTCKActivity();
                    return tCKTestResult;
                }
            }
            throw new IllegalArgumentException("Unrecognized activity type code: " + activityType);
        }
        finally {
            this.getLog().info("Ending the activity used to stall the transition to the STOPPING state");
            this.endActivitySilent(this.stallingActivityID);
            this.getLog().info("Restarting the SLEE");
            SleeStarter.startSlee(this.utils().getSleeManagementMBeanProxy(), this.utils().getTestTimeout());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TCKTestResult testCreateProfileTableActivity() throws Exception {
        String profileTableName = "tck.CreateActivityWhileStoppingTest.tableA";
        boolean createdTable = false;
        try {
            this.profileUtils.getProfileProvisioningProxy().createProfileTable(this.profileSpecID, profileTableName);
            createdTable = true;
            this.getLog().info("Firing a Y1 event to the Sbb to prompt an attempt to lookup a ProfileTableActivity");
            Object object = this.resourceListener;
            synchronized (object) {
                this.y1EventObjectID = this.utils().getResourceInterface().fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y1", profileTableName, this.stallingActivityID, null);
            }
            try {
                object = this.testCaseResult.waitForResult(this.utils().getTestTimeout());
                return object;
            }
            catch (Future.TimeoutException toe) {
                block11: {
                    TCKTestResult tCKTestResult;
                    block12: {
                        if (!this.resourceListener.hasActivityEnded()) break block11;
                        this.getLog().warning("Wasn't able to test ProfileTableActivity creation because the SLEE timed out the activity which was holding it in the STOPPING state (this is valid behaviour)");
                        tCKTestResult = TCKTestResult.passed();
                        if (!createdTable) break block12;
                        this.profileUtils.removeProfileTable(profileTableName);
                    }
                    return tCKTestResult;
                }
                throw new TCKTestErrorException("testCreateProfileTableActivity(): Timed out while waiting for the Sbb to receive the Y1 event");
            }
        }
        finally {
            if (createdTable) {
                this.profileUtils.removeProfileTable(profileTableName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TCKTestResult testCreateNullActivity() throws Exception {
        this.getLog().info("Firing an X2 event to the Sbb to prompt an attempt to create a NullActivity");
        ResourceListenerImpl resourceListenerImpl = this.resourceListener;
        synchronized (resourceListenerImpl) {
            this.x2EventObjectID = this.utils().getResourceInterface().fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2", null, this.stallingActivityID, null);
        }
        try {
            return this.testCaseResult.waitForResult(this.utils().getTestTimeout());
        }
        catch (Future.TimeoutException toe) {
            if (this.resourceListener.hasActivityEnded()) {
                this.getLog().warning("Wasn't able to test NullActivity creation because the SLEE timed out the activity which was holding it in the STOPPING state (this is valid behaviour)");
                return TCKTestResult.passed();
            }
            throw new TCKTestErrorException("testCreateNullActivity(): Timed out while waiting to the Sbb to receive the Y1 event");
        }
    }

    private TCKTestResult testCreateTCKActivity() throws Exception {
        this.isTestingCreateTCKActivity = true;
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID createdActivity = null;
        try {
            createdActivity = resource.createActivity("tck.CreateActivityWhileStoppingTest.IllegalActivity");
            if (createdActivity == null) {
                this.getLog().info("testCreateTCKActivity(): Attempt to create an Activity failed during/after the STOPPING state (returned ID was null). Will interpret this as a pass.");
                TCKTestResult tCKTestResult = TCKTestResult.passed();
                return tCKTestResult;
            }
            this.getLog().warning("testCreateTCKActivity(): Successfully created a TCKActivity via the resource adaptor. activity ID:" + createdActivity + ". Current SLEE state:" + this.utils().getSleeManagementMBeanProxy().getState());
            this.getLog().info("Firing an event on the new activity to test whether it was accepted by the SLEE container itself");
            try {
                this.utils().getResourceInterface().fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y2", null, createdActivity, null);
                this.getLog().warning("testCreateTCKActivity(): Fired an event on a TCKActivity that wascreated during/after the STOPPING state, and received no Exception. Current SLEE state:" + this.utils().getSleeManagementMBeanProxy().getState());
            }
            catch (Exception ex) {
                this.getLog().info("testCreateTCKActivity(): Attempt to fire an event on a TCKActivity that wascreated during/after the STOPPING state threw an Exception. Will interpret this as a pass. Exception:");
                this.getLog().warning(ex);
                TCKTestResult tCKTestResult = TCKTestResult.passed();
                this.endActivitySilent(createdActivity);
                return tCKTestResult;
            }
            TCKTestResult ex = this.testCaseResult.waitForResult(this.utils().getTestTimeout());
            return ex;
        }
        finally {
            this.endActivitySilent(createdActivity);
        }
    }

    private void endActivitySilent(TCKActivityID activityToEnd) {
        if (activityToEnd != null) {
            try {
                if (this.utils().getResourceInterface().isLive(activityToEnd)) {
                    this.utils().getResourceInterface().endActivity(activityToEnd);
                }
            }
            catch (Exception ex) {
                this.getLog().warning("Received Exception while trying to end TCKActivity " + activityToEnd + ". Exception:");
                this.getLog().warning(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForSbbAttach() throws OperationTimedOutException {
        ResourceListenerImpl resourceListenerImpl = this.resourceListener;
        synchronized (resourceListenerImpl) {
            long now = System.currentTimeMillis();
            long timeoutAt = now + (long)this.utils().getTestTimeout();
            while (timeoutAt > now && !this.resourceListener.hasSbbAttached()) {
                try {
                    this.resourceListener.wait(timeoutAt - now);
                    now = System.currentTimeMillis();
                }
                catch (InterruptedException ie) {}
            }
            if (!this.resourceListener.hasSbbAttached()) {
                throw new OperationTimedOutException("Timed out while waiting for the Sbb to receive an event");
            }
        }
    }

    private String formatCode(int sbbCallCode) {
        switch (sbbCallCode) {
            case 2: {
                return "NULL_ACTIVITY_CREATED_FAILED";
            }
            case 3: {
                return "NULL_ACTIVITY_CREATE_SUCCEEDED";
            }
            case 4: {
                return "PROFILE_TABLE_ACTIVITY_FOUND";
            }
            case 5: {
                return "PROFILE_TABLE_ACTIVITY_NOT_FOUND";
            }
            case 1: {
                return "RECEIVED_X1";
            }
            case 8: {
                return "RECEIVED_Y2";
            }
        }
        return "(Unrecognized Sbb call code: " + sbbCallCode + ")";
    }

    private class ResourceListenerImpl
    extends BaseTCKResourceListener {
        private boolean hasSbbAttached;
        private boolean hasActivityEnded;

        private ResourceListenerImpl() {
        }

        public synchronized Object onSbbCall(Object argument) throws Exception {
            try {
                int callCode = (Integer)argument;
                CreateActivityWhileStoppingTest.this.getLog().info("Received call from Sbb:" + CreateActivityWhileStoppingTest.this.formatCode(callCode));
                SleeState currentState = CreateActivityWhileStoppingTest.this.utils().getSleeManagementMBeanProxy().getState();
                switch (callCode) {
                    case 1: {
                        this.hasSbbAttached = true;
                        this.notifyAll();
                        break;
                    }
                    case 2: {
                        CreateActivityWhileStoppingTest.this.testCaseResult.setPassed();
                        break;
                    }
                    case 3: {
                        CreateActivityWhileStoppingTest.this.testCaseResult.setFailed(1473, "The Sbb created a NullActivity object during the STOPPING or STOPPED state. Current SLEE state:" + currentState);
                        break;
                    }
                    case 4: {
                        CreateActivityWhileStoppingTest.this.testCaseResult.setFailed(1473, "The Sbb found a ProfileTableActivity for an profile table created during the STOPPING or STOPPED state. Current SLEE state:" + currentState);
                        break;
                    }
                    case 5: {
                        CreateActivityWhileStoppingTest.this.testCaseResult.setPassed();
                        break;
                    }
                    case 8: {
                        CreateActivityWhileStoppingTest.this.testCaseResult.setFailed(1473, "The Sbb received an event on an activity which was created during the STOPPING or STOPPED state. Current SLEE state: " + currentState);
                        break;
                    }
                    default: {
                        throw new TCKTestErrorException("Unrecognized call code from Sbb: " + callCode);
                    }
                }
                if (callCode != 1) {
                    CreateActivityWhileStoppingTest.this.isSecondEventACKReceived = true;
                }
            }
            catch (Exception ex) {
                this.onException(ex);
            }
            return null;
        }

        public synchronized void onEventProcessingSuccessful(long eventObjectID) throws RemoteException {
            CreateActivityWhileStoppingTest.this.getLog().info("onEventProcessingSuccessful(eventObjectID=" + eventObjectID + ")");
            if (eventObjectID != CreateActivityWhileStoppingTest.this.x1EventObjectID && !CreateActivityWhileStoppingTest.this.isSecondEventACKReceived) {
                this.onSecondEventNotDelivered(eventObjectID);
            }
        }

        public synchronized void onEventProcessingFailed(long eventObjectID, String message, Exception exception) {
            CreateActivityWhileStoppingTest.this.getLog().info("onEventProcessingFailed(eventObjectID=" + eventObjectID + ", message=" + message);
            if (eventObjectID == CreateActivityWhileStoppingTest.this.x1EventObjectID) {
                StringBuffer buf = new StringBuffer("Received onEventProcessingFailed() callback for X1 event");
                if (message != null) {
                    buf.append(message);
                }
                this.onException(new TCKTestErrorException(buf.toString(), exception));
            } else if (!CreateActivityWhileStoppingTest.this.isSecondEventACKReceived) {
                this.onSecondEventNotDelivered(eventObjectID);
            }
        }

        public synchronized void onActivityContextInvalid(TCKActivityID activityID) {
            if (((Object)activityID).equals(CreateActivityWhileStoppingTest.this.stallingActivityID)) {
                this.hasActivityEnded = true;
                CreateActivityWhileStoppingTest.this.getLog().info("ResourceListenerImpl: received notification of activity end for stalling activity");
            } else {
                this.onException(new TCKTestErrorException("Received unexpected onActivityContextInvalid() callback for activity: " + activityID));
            }
        }

        public synchronized void onException(Exception e) {
            CreateActivityWhileStoppingTest.this.utils().getLog().warning("Received Exception from resource:");
            CreateActivityWhileStoppingTest.this.utils().getLog().warning(e);
            if (CreateActivityWhileStoppingTest.this.isTestingCreateTCKActivity) {
                CreateActivityWhileStoppingTest.this.utils().getLog().warning("Not aborting the test, because the current test is testCreateTCKActivity. The resource or resource adaptor may be throwing an Exception because of the attempt to create a new activity while the SLEE is in the STOPPING state.");
            } else {
                CreateActivityWhileStoppingTest.this.testCaseResult.setError(e);
            }
        }

        public synchronized boolean hasSbbAttached() {
            return this.hasSbbAttached;
        }

        public synchronized boolean hasActivityEnded() {
            return this.hasActivityEnded;
        }

        public void resetFlags() {
            this.hasActivityEnded = false;
            this.hasSbbAttached = false;
        }

        private synchronized void onSecondEventNotDelivered(long eventObjectID) {
            if (eventObjectID == CreateActivityWhileStoppingTest.this.x2EventObjectID || eventObjectID == CreateActivityWhileStoppingTest.this.y1EventObjectID) {
                String eventName;
                String string = eventName = eventObjectID == CreateActivityWhileStoppingTest.this.x2EventObjectID ? "X2" : "Y1";
                if (this.hasActivityEnded()) {
                    CreateActivityWhileStoppingTest.this.getLog().info("Event delivery failed for " + eventName + " event after the stalling " + "activity ended. Allow this: as the SLEE may have stopped after the activity ended. " + "Will allow the test case to timeout...");
                } else {
                    CreateActivityWhileStoppingTest.this.testCaseResult.setError("Event delivery failed for " + eventName + " event before the stalling " + "activity ended");
                }
            } else {
                CreateActivityWhileStoppingTest.this.getLog().info("The Y2 event was not delivered. Will interpret this as a pass (assuming the delivery failed because the activity was not created inside the SLEE)");
                CreateActivityWhileStoppingTest.this.testCaseResult.setPassed();
            }
        }
    }
}

