/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.jmx.impl.EmptyArrays;
import java.rmi.RemoteException;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.ManagementException;
import javax.slee.management.SleeState;

public class Test1429Test
implements SleeTCKTest {
    private static final int TEST_ID = 1429;
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        DeployableUnitID[] invokeDuIDs;
        ObjectName sleeObject = this.utils.getSleeManagementMBeanName();
        Object result = this.getViaGetAttribute(sleeObject, "State");
        this.utils.getLog().fine("State attribute is of type: " + result.getClass().toString());
        SleeState attributeState = (SleeState)this.getViaGetAttribute(sleeObject, "State");
        SleeState invokeState = (SleeState)this.getViaInvoke(sleeObject, "State");
        if (!attributeState.equals((Object)invokeState)) {
            return TCKTestResult.failed(1429, "Value returned by invoke was not the same as that returned by getAttribute.");
        }
        ObjectName deploymentObject = (ObjectName)this.getViaInvoke(sleeObject, "DeploymentMBean");
        DeployableUnitID[] attributeDuIDs = (DeployableUnitID[])this.getViaGetAttribute(deploymentObject, "DeployableUnits");
        if (attributeDuIDs.length != (invokeDuIDs = (DeployableUnitID[])this.getViaInvoke(deploymentObject, "DeployableUnits")).length) {
            return TCKTestResult.failed(1429, "DU set received via getAttribute is not the same as the set received via invoke.");
        }
        block0: for (int i = 0; i < attributeDuIDs.length; ++i) {
            for (int j = 0; j < invokeDuIDs.length; ++j) {
                if (attributeDuIDs[i].equals((Object)invokeDuIDs[j])) continue block0;
            }
            return TCKTestResult.failed(1429, "DU retrieved via getAttribute was not found in set retrieved via invoke.");
        }
        ObjectName profileObject = (ObjectName)this.getViaInvoke(sleeObject, "ProfileProvisioningMBean");
        this.getViaGetAttribute(profileObject, "ProfileTables");
        this.getViaInvoke(profileObject, "ProfileTables");
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
    }

    public void tearDown() throws Exception {
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Uninstalling the profile spec");
        this.utils.uninstallAll();
    }

    private Object getViaGetAttribute(ObjectName objName, String attribute) throws ManagementException, TCKTestErrorException, TCKTestFailureException {
        try {
            return this.utils.getMBeanFacade().getAttribute(objName, attribute);
        }
        catch (InstanceNotFoundException ie) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.getAttribute()", ie);
        }
        catch (ReflectionException re) {
            throw new TCKTestFailureException(1429, "Caught ReflectionException while calling MBeanServer.getAttribute(\"AttributeA\")", re);
        }
        catch (AttributeNotFoundException e) {
            throw new TCKTestFailureException(1429, "Caught AttributeNotFoundException while calling MBeanServer.getAttribute(\"AttributeA\")", e);
        }
        catch (MBeanException e) {
            Exception enclosed = e.getTargetException();
            if (enclosed instanceof ManagementException) {
                throw (ManagementException)((Object)enclosed);
            }
            if (enclosed instanceof RuntimeException) {
                throw (RuntimeException)enclosed;
            }
            throw new TCKTestErrorException("Caught unexpected exception", enclosed);
        }
    }

    private Object getViaInvoke(ObjectName objName, String attribute) throws TCKTestErrorException, TCKTestFailureException {
        try {
            return this.utils.getMBeanFacade().invoke(objName, "get" + attribute, EmptyArrays.EMPTY_OBJECT_ARRAY, EmptyArrays.EMPTY_STRING_ARRAY);
        }
        catch (InstanceNotFoundException ie) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke(...,\"get" + attribute + "\",...)", ie);
        }
        catch (ReflectionException re) {
            throw new TCKTestFailureException(1429, "Caught ReflectionException while calling MBeanServer.invoke(...,\"get" + attribute + "\",...)", re);
        }
        catch (MBeanException e) {
            Exception enclosed = e.getTargetException();
            if (enclosed instanceof RuntimeException) {
                throw (RuntimeException)enclosed;
            }
            throw new TCKTestErrorException("Caught unexpected exception", enclosed);
        }
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public void onException(Exception e) throws RemoteException {
            Test1429Test.this.utils.getLog().warning("Received exception from the TCK resource");
            Test1429Test.this.utils.getLog().warning(e);
        }
    }
}

