/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.SleeManagementMBean;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testutils.jmx.SleeManagementMBeanProxy;
import javax.management.JMException;
import javax.management.ObjectName;
import javax.slee.management.AlarmMBean;
import javax.slee.management.DeploymentMBean;
import javax.slee.management.ProfileProvisioningMBean;
import javax.slee.management.ServiceManagementMBean;
import javax.slee.management.TraceMBean;

public class TestMBeanAccessors
implements SleeTCKTest {
    private SleeTCKTestUtils utils;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public TCKTestResult run() throws Exception {
        SleeManagementMBeanProxy management = this.utils.getSleeManagementMBeanProxy();
        this.checkMBean(management.getDeploymentMBean(), "getDeploymentMBean", DeploymentMBean.class.getName(), 4037);
        this.checkMBean(management.getServiceManagementMBean(), "getServiceManagementMBean", ServiceManagementMBean.class.getName(), 4039);
        this.checkMBean(management.getProfileProvisioningMBean(), "getProfileProvisioningMBean", ProfileProvisioningMBean.class.getName(), 4041);
        this.checkMBean(management.getTraceMBean(), "getTraceMBean", TraceMBean.class.getName(), 4043);
        this.checkMBean(management.getAlarmMBean(), "getAlarmMBean", AlarmMBean.class.getName(), 4045);
        return TCKTestResult.passed();
    }

    private void checkMBean(ObjectName objName, String methodName, String expectedMBeanClassName, int assertionID) throws TCKTestFailureException, TCKTestErrorException, JMException {
        this.utils.getLog().info("Checking that MBean " + objName + " returned by " + methodName + " is a " + expectedMBeanClassName);
        if (!this.utils.getMBeanFacade().isInstanceOf(objName, expectedMBeanClassName)) {
            throw new TCKTestFailureException(assertionID, "MBean " + objName + " returned by " + methodName + " is not an instance of " + expectedMBeanClassName);
        }
    }
}

