/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.ResourceManagementMBean;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.rautils.MessageHandler;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.rautils.UOID;
import com.opencloud.sleetck.lib.testsuite.resource.TCKMessage;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ResourceManagementMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ServiceManagementMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.SleeManagementMBeanProxy;
import java.util.HashSet;
import javax.management.ObjectName;
import javax.slee.ComponentID;
import javax.slee.InvalidStateException;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.LinkNameAlreadyBoundException;
import javax.slee.management.ResourceAdaptorEntityAlreadyExistsException;
import javax.slee.management.ResourceAdaptorEntityState;
import javax.slee.management.ServiceState;
import javax.slee.management.UnrecognizedResourceAdaptorEntityException;
import javax.slee.management.UnrecognizedResourceAdaptorException;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.ResourceAdaptorID;

public class Test1114096Test
extends AbstractSleeTCKTest {
    private static final String RA_NAME = "TCK_Context_Test_RA";
    private static final String RA_ENTITY_NAME1 = "TCK_Context_Test_RA_Entity1";
    private static final String RA_ENTITY_NAME2 = "TCK_Context_Test_RA_Entity2";
    private static final String RA_ENTITY_BAD = "TCK_Context_Test_RA_Entity666";
    private static final String RA_VENDOR = "jain.slee.tck";
    private static final String RA_VERSION = "1.1";
    protected static final String RESOURCE_LINK_NAME_PARAM = "resourceLinkName";
    private static final String RESOURCE_DU_PATH_PARAM = "resourceDUPath";
    private static final String SERVICE_DU_PATH_PARAM = "serviceDUPath";
    private ResourceAdaptorID raID;
    private String theEntity = "TCK_Context_Test_RA_Entity2";
    private ResourceAdaptorID raID2 = null;
    private String[] linkNames;
    private String[] resourceEntities;
    private ResourceManagementMBeanProxy resourceMBean;
    private String bindLinkName = "slee/resources/tck/simple";
    private String raLinkName;
    private String raEntityName;
    private DeployableUnitID raDUID;
    private DeployableUnitID sbbDUID;
    private SbbID sbbID;
    private ServiceID serviceID;

    public TCKTestResult run() throws Exception {
        FutureResult future = new FutureResult(this.getLog());
        RMIObjectChannel in = this.utils().getRMIObjectChannel();
        in.setMessageHandler(new CallbackListener(future, 1));
        TCKTestResult result1 = this.doResourceManagementMBeanCheck(this.resourceMBean);
        this.getLog().info("Waiting for RA Entity to enter INACTIVE state");
        ResourceAdaptorEntityState raState = null;
        long timeout = System.currentTimeMillis() + (long)this.utils().getTestTimeout();
        while (System.currentTimeMillis() < timeout && !(raState = this.resourceMBean.getState(this.theEntity)).isInactive()) {
            Thread.sleep(500L);
        }
        this.getLog().info("Current RA state = " + raState);
        if (!ResourceAdaptorEntityState.INACTIVE.equals((Object)raState)) {
            this.utils().getLog().error("RA did not transition into the INACTIVE state within test timeout");
        }
        TCKTestResult result2 = this.checkResourceAdaptorsFinished(this.resourceMBean);
        if (!result1.equals(TCKTestResult.passed())) {
            return result1;
        }
        return result2;
    }

    public void tearDown() throws Exception {
        try {
            this.utils().getLog().fine("Disconnecting from resource");
            this.utils().removeRAEntities();
            this.utils().getResourceInterface().clearActivities();
            super.tearDown();
        }
        catch (Exception e) {
            this.getLog().warning(e);
            this.getLog().warning("ERROR: problems in test tear down");
        }
    }

    public void setUp() throws Exception {
        DeploymentMBeanProxy deploymentMBean = this.utils().getDeploymentMBeanProxy();
        ServiceManagementMBeanProxy serviceMBean = this.utils().getServiceManagementMBeanProxy();
        String raDUPath = this.utils().getTestParams().getProperty(RESOURCE_DU_PATH_PARAM);
        this.getLog().fine("Installing DU: " + raDUPath);
        this.raDUID = this.utils().install(raDUPath);
        this.raEntityName = RA_ENTITY_NAME1;
        this.resourceMBean = this.utils().getResourceManagementMBeanProxy();
        this.raID = new ResourceAdaptorID(RA_NAME, RA_VENDOR, RA_VERSION);
        this.resourceMBean.createResourceAdaptorEntity(this.raID, RA_ENTITY_NAME1, new ConfigProperties());
        this.raLinkName = "slee/resources/tck/simple";
        this.getLog().info("Binding RA Entity '" + this.raEntityName + "' to link name '" + this.raLinkName + "'");
        this.resourceMBean.bindLinkName(this.raEntityName, this.raLinkName);
        String serviceDUPath = this.utils().getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        if (serviceDUPath != null) {
            DeployableUnitDescriptor descriptor = null;
            String absolutePath = this.utils().getDeploymentUnitURL(serviceDUPath);
            this.getLog().info("Installing service: " + absolutePath);
            this.sbbDUID = deploymentMBean.install(absolutePath);
            try {
                descriptor = this.utils().getDeploymentMBeanProxy().getDescriptor(this.sbbDUID);
            }
            catch (Exception e) {
                throw new TCKTestErrorException("An error occured while attempting to find a ServiceID contained in DU: " + this.sbbDUID, e);
            }
            ComponentID[] components = descriptor.getComponents();
            for (int i = 0; i < components.length; ++i) {
                if (components[i] instanceof ServiceID) {
                    this.getLog().fine("Setting serviceID value.");
                    this.serviceID = (ServiceID)components[i];
                    continue;
                }
                if (!(components[i] instanceof SbbID)) continue;
                this.getLog().fine("Setting sbbID value.");
                this.sbbID = (SbbID)components[i];
            }
            serviceMBean.activate(this.serviceID);
        }
        this.resourceMBean.activateResourceAdaptorEntity(this.raEntityName);
        this.getLog().fine("SBB & RA are active");
    }

    private TCKTestResult doResourceManagementMBeanCheck(ResourceManagementMBeanProxy theResourceManagementMBean) throws InterruptedException {
        ConfigProperties.Property newConfigProperty;
        Boolean propertyValue;
        ConfigProperties configProperties;
        String newConfigStr;
        long timeout;
        ResourceAdaptorEntityState currentState;
        block89: {
            block88: {
                block87: {
                    block86: {
                        currentState = null;
                        timeout = 0L;
                        newConfigStr = null;
                        ResourceAdaptorID badRAid = new ResourceAdaptorID("TCK_Non_Existant_RA", RA_VENDOR, RA_VERSION);
                        try {
                            SleeManagementMBeanProxy proxy = this.utils().getSleeManagementMBeanProxy();
                            ObjectName objectName = proxy.getResourceManagementMBean();
                            String strObjectName = objectName.toString();
                            this.getLog().fine("1114096: getResourceManagementMBean = " + strObjectName);
                            if (!strObjectName.equals("javax.slee.management:name=ResourceManagement")) {
                                return TCKTestResult.failed(0x10FFF0, "getResourceManagementMBean() returned: " + objectName);
                            }
                            this.logSuccessfulCheck(0x10FFF0);
                        }
                        catch (Exception e) {
                            this.getLog().warning(e);
                            return TCKTestResult.failed(0x10FFF0, "getResourceManagementMBean() failed");
                        }
                        try {
                            boolean found = false;
                            this.resourceEntities = theResourceManagementMBean.getResourceAdaptorEntities();
                            this.getLog().fine("1114108: getResourceAdaptorEntities = " + this.resourceEntities[0].toString());
                            if (this.resourceEntities.length > 0) {
                                for (int i = 0; i < this.resourceEntities.length; ++i) {
                                    if (!this.resourceEntities[i].equals(RA_ENTITY_NAME1)) continue;
                                    found = true;
                                }
                                if (!found) {
                                    return TCKTestResult.failed(1114108, "getResourceAdaptorEntities() failed ro return correct resourceEntities");
                                }
                            } else {
                                return TCKTestResult.failed(1114108, "getResourceAdaptorEntities() failed ro return resourceEntities");
                            }
                            this.logSuccessfulCheck(1114108);
                        }
                        catch (Exception e) {
                            this.getLog().warning(e);
                            return TCKTestResult.failed(1114108, "getResourceAdaptorEntities() failed");
                        }
                        try {
                            this.linkNames = theResourceManagementMBean.getLinkNames();
                            this.logSuccessfulCheck(1114069);
                        }
                        catch (Exception e) {
                            this.getLog().warning(e);
                            return TCKTestResult.failed(1114069, "getLinkNames() failed");
                        }
                        try {
                            configProperties = theResourceManagementMBean.getConfigurationProperties(this.raID);
                            this.getLog().fine("1114116: getConfigurationProperties = " + configProperties.toString());
                            this.logSuccessfulCheck(0x110004);
                        }
                        catch (Exception e) {
                            this.getLog().warning(e);
                            return TCKTestResult.failed(0x110004, "getConfigurationProperties() failed");
                        }
                        try {
                            ObjectName usageObject = theResourceManagementMBean.getResourceUsageMBean(RA_ENTITY_NAME1);
                            String strObjectName = usageObject.toString();
                            this.getLog().fine("1114053: getResourceUsageMBean = " + usageObject);
                            if (!strObjectName.equals("javax.slee.management.usage:type=ResourceUsage,raEntityName=\"TCK_Context_Test_RA_Entity1\"")) {
                                return TCKTestResult.failed(1114053, "Incorrect ResourceManagementMBean Object Name: " + strObjectName);
                            }
                            this.logSuccessfulCheck(1114053);
                        }
                        catch (Exception e) {
                            this.getLog().warning(e);
                            return TCKTestResult.failed(1114053, "getResourceUsageMBean() failed");
                        }
                        try {
                            configProperties = new ConfigProperties();
                            this.logSuccessfulCheck(1114055);
                            theResourceManagementMBean.createResourceAdaptorEntity(badRAid, RA_ENTITY_NAME2, configProperties);
                            return TCKTestResult.failed(1114092, "createResourceAdaptorEntity() failed to throw UnrecognizedResourceAdaptorException");
                        }
                        catch (UnrecognizedResourceAdaptorException e) {
                            this.logSuccessfulCheck(1114092);
                        }
                        catch (Exception e) {
                            this.getLog().warning(e);
                            return TCKTestResult.failed(1114092, "createResourceAdaptorEntity() failed");
                        }
                        this.raID2 = new ResourceAdaptorID(RA_NAME, RA_VENDOR, RA_VERSION);
                        try {
                            theResourceManagementMBean.createResourceAdaptorEntity(this.raID2, this.theEntity, configProperties);
                            this.getLog().fine("1114141: createResourceAdaptorEntity = " + this.theEntity);
                            currentState = theResourceManagementMBean.getState(this.theEntity);
                            if (!currentState.isInactive()) {
                                return TCKTestResult.failed(0x11001D, "current State of raID2 is not INACTIVE but: " + currentState.toString());
                            }
                            this.logSuccessfulCheck(0x11001D);
                        }
                        catch (Exception e) {
                            this.getLog().warning(e);
                            return TCKTestResult.failed(0x11001D, "createResourceAdaptorEntity() failed");
                        }
                        try {
                            configProperties = new ConfigProperties();
                            theResourceManagementMBean.createResourceAdaptorEntity(this.raID2, this.theEntity, configProperties);
                            return TCKTestResult.failed(1114068, "createResourceAdaptorEntity() failed to throw ResourceAdaptorEntityAlreadyExistsException");
                        }
                        catch (ResourceAdaptorEntityAlreadyExistsException e) {
                            this.logSuccessfulCheck(1114068);
                        }
                        catch (Exception e) {
                            this.getLog().warning(e);
                            return TCKTestResult.failed(1114068, "createResourceAdaptorEntity() failed");
                        }
                        try {
                            configProperties = theResourceManagementMBean.getConfigurationProperties(this.raID2);
                            this.getLog().fine("1114116: getConfigurationProperties = " + configProperties.toString());
                            this.logSuccessfulCheck(0x110004);
                        }
                        catch (Exception e) {
                            this.getLog().warning(e);
                            return TCKTestResult.failed(0x110004, "getConfigurationProperties() failed");
                        }
                        try {
                            configProperties = theResourceManagementMBean.getConfigurationProperties(this.theEntity);
                            this.getLog().fine("1114091: getConfigurationProperties = " + configProperties.toString());
                            this.logSuccessfulCheck(1114091);
                        }
                        catch (Exception e) {
                            this.getLog().warning(e);
                            return TCKTestResult.failed(1114091, "getConfigurationProperties() failed");
                        }
                        try {
                            boolean found = false;
                            this.resourceEntities = theResourceManagementMBean.getResourceAdaptorEntities(this.raID2);
                            if (this.resourceEntities.length > 0) {
                                for (int i = 0; i < this.resourceEntities.length; ++i) {
                                    this.getLog().fine("1114122: getResourceAdaptorEntities = " + this.resourceEntities[i].toString());
                                    if (!this.resourceEntities[i].equals(this.theEntity)) continue;
                                    this.logSuccessfulCheck(0x11000A);
                                    found = true;
                                }
                                if (!found) {
                                    return TCKTestResult.failed(0x11000A, "getResourceAdaptorEntities for raID2 did not contain RA Entity Name: " + this.theEntity.toString());
                                }
                                break block86;
                            }
                            return TCKTestResult.failed(0x11000A, "getResourceAdaptorEntities for raID2 did not contain RA Entity Name");
                        }
                        catch (Exception e) {
                            this.getLog().warning(e);
                            return TCKTestResult.failed(0x11000A, "getResourceAdaptorEntities() failed");
                        }
                    }
                    propertyValue = new Boolean(true);
                    newConfigProperty = new ConfigProperties.Property("$TCK_Test_1114096_Property$", "java.lang.Boolean", (Object)propertyValue);
                    try {
                        this.logSuccessfulCheck(0x110014);
                        newConfigStr = newConfigProperty.toString();
                        this.logSuccessfulCheck(1114082);
                        newConfigStr = newConfigStr.substring(newConfigStr.indexOf(91) + 1, newConfigStr.indexOf(93));
                        this.getLog().fine("1114134: updateConfigurationProperties with: " + newConfigStr);
                        configProperties.addProperty(newConfigProperty);
                        theResourceManagementMBean.updateConfigurationProperties(RA_ENTITY_NAME2, configProperties);
                    }
                    catch (Exception e) {
                        this.getLog().warning(e);
                        return TCKTestResult.failed(0x110014, "updateConfigurationProperties() failed");
                    }
                    try {
                        configProperties = theResourceManagementMBean.getConfigurationProperties(this.theEntity);
                        String configPropertiesStr = configProperties.toString();
                        this.getLog().fine("Updated Config Properties = " + configPropertiesStr);
                        this.logSuccessfulCheck(1114043);
                        ConfigProperties.Property updatedProperty = configProperties.getProperty("$TCK_Test_1114096_Property$");
                        if (updatedProperty == null) break block87;
                        if (updatedProperty.equals((Object)newConfigProperty)) {
                            this.logSuccessfulCheck(0x110016);
                            this.logSuccessfulCheck(0x110017);
                            break block87;
                        }
                        return TCKTestResult.failed(0x110017, "updateConfigurationProperties for raID2 did not contain new Property");
                    }
                    catch (Exception e) {
                        this.getLog().warning(e);
                        return TCKTestResult.failed(0x110017, "getConfigurationProperties() failed");
                    }
                }
                try {
                    this.linkNames = theResourceManagementMBean.getLinkNames(this.theEntity);
                    if (this.linkNames.length == 0) {
                        this.logSuccessfulCheck(1114090);
                    } else {
                        this.getLog().warning("1114090: Found getLinkNames for raID2 = " + this.linkNames[0]);
                    }
                }
                catch (Exception e) {
                    this.getLog().warning(e);
                    return TCKTestResult.failed(1114090, "getLinkNames() failed");
                }
                try {
                    this.linkNames = theResourceManagementMBean.getLinkNames(this.raEntityName);
                    if (this.linkNames.length > 0) {
                        boolean found = false;
                        for (int i = 0; i < this.linkNames.length; ++i) {
                            this.getLog().fine("1114090: New getLinkNames for raID = " + this.linkNames[i]);
                            if (!this.linkNames[i].toString().equals(this.bindLinkName)) continue;
                            this.logSuccessfulCheck(0x110005);
                            found = true;
                        }
                        if (!found) {
                            return TCKTestResult.failed(1114090, "Incorrect LinkNames for raID: Expected: " + this.bindLinkName);
                        }
                        break block88;
                    }
                    return TCKTestResult.failed(1114090, "Did not find LinkNames for raID");
                }
                catch (Exception e) {
                    this.getLog().warning(e);
                    return TCKTestResult.failed(1114090, "getLinkNames() failed");
                }
            }
            try {
                SbbID boundSbb = new SbbID("Test1114096Sbb", RA_VENDOR, RA_VERSION);
                SbbID[] sbbIDs = theResourceManagementMBean.getBoundSbbs(this.bindLinkName);
                if (sbbIDs.length > 0) {
                    boolean found = false;
                    for (int i = 0; i < sbbIDs.length; ++i) {
                        this.getLog().fine("1114109: getBoundSbbs = " + sbbIDs[i].toString());
                        if (!sbbIDs[i].equals((Object)boundSbb)) continue;
                        this.logSuccessfulCheck(1114109);
                        found = true;
                    }
                    if (!found) {
                        return TCKTestResult.failed(1114109, "Incorrect SBB id for raID");
                    }
                    break block89;
                }
                return TCKTestResult.failed(1114109, "Did not find an SBB bound to LinkName for raID");
            }
            catch (Exception e) {
                this.getLog().warning(e);
                return TCKTestResult.failed(1114109, "getResourceAdaptorEntities() failed");
            }
        }
        try {
            theResourceManagementMBean.bindLinkName(this.raEntityName, this.bindLinkName);
            return TCKTestResult.failed(0x110007, "bindLinkName() failed to throw LinkNameAlreadyBoundException");
        }
        catch (LinkNameAlreadyBoundException e) {
            this.getLog().fine("1114119: RA entity already bound: " + this.raEntityName + " to " + this.bindLinkName);
            this.logSuccessfulCheck(0x110007);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.failed(0x110007, "bindLinkName() failed");
        }
        try {
            theResourceManagementMBean.activateResourceAdaptorEntity(RA_ENTITY_BAD);
            return TCKTestResult.failed(0x11001B, "activateResourceAdaptorEntity() failed to throw UnrecognizedResourceAdaptorEntityException");
        }
        catch (UnrecognizedResourceAdaptorEntityException e) {
            this.logSuccessfulCheck(0x11001B);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.failed(0x11001B, "activateResourceAdaptorEntity() failed");
        }
        try {
            currentState = theResourceManagementMBean.getState(this.theEntity);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.failed(0x11001C, "getState() failed");
        }
        this.getLog().fine("1114140: Initial State for raID2 = " + currentState.toString());
        if (!currentState.isInactive()) {
            return TCKTestResult.failed(0x110012, "currentState is not INACTIVE but: " + currentState.toString());
        }
        try {
            theResourceManagementMBean.activateResourceAdaptorEntity(this.theEntity);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.failed(0x110012, "activateResourceAdaptorEntity() failed");
        }
        timeout = System.currentTimeMillis() + (long)this.utils().getTestTimeout();
        while (System.currentTimeMillis() < timeout) {
            try {
                currentState = theResourceManagementMBean.getState(this.theEntity);
            }
            catch (Exception e) {
                this.getLog().warning(e);
                return TCKTestResult.failed(0x11001C, "getState() failed");
            }
            if (currentState.isActive()) break;
            Thread.sleep(500L);
        }
        this.getLog().fine("1114140: Final State for raID2 = " + currentState.toString());
        if (!currentState.isActive()) {
            return TCKTestResult.failed(0x110012, "currentState is not ACTIVE but: " + currentState.toString());
        }
        this.logSuccessfulCheck(0x110012);
        try {
            propertyValue = new Boolean(true);
            newConfigProperty = new ConfigProperties.Property("$TCK_Test_1114096_Active_Property$", "java.lang.Boolean", (Object)propertyValue);
            newConfigStr = newConfigProperty.toString();
            newConfigStr = newConfigStr.substring(newConfigStr.indexOf(91) + 1, newConfigStr.indexOf(93));
            this.getLog().fine("1114121: updateConfigurationProperties with: " + newConfigStr);
            configProperties.addProperty(newConfigProperty);
            theResourceManagementMBean.updateConfigurationProperties(RA_ENTITY_NAME2, configProperties);
            return TCKTestResult.failed(0x110009, "updateConfigurationProperties() failed to throw InvalidStateException");
        }
        catch (InvalidStateException e) {
            this.logSuccessfulCheck(0x110009);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.failed(0x110009, "updateConfigurationProperties() failed");
        }
        try {
            theResourceManagementMBean.activateResourceAdaptorEntity(this.theEntity);
            return TCKTestResult.failed(0x11000E, "Activate RA should have failed as RA is already active");
        }
        catch (InvalidStateException e) {
            this.logSuccessfulCheck(0x11000E);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.failed(0x11000E, "activateResourceAdaptorEntity() failed");
        }
        this.getLog().fine("1114127: deactivateResourceAdaptorEntity then wait to check raID2 is no longer active");
        try {
            currentState = theResourceManagementMBean.getState(this.theEntity);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.failed(0x11001C, "getState() failed");
        }
        if (!currentState.isActive()) {
            return TCKTestResult.failed(0x11000F, "currentState is not ACTIVE but: " + currentState.toString());
        }
        try {
            theResourceManagementMBean.deactivateResourceAdaptorEntity(this.theEntity);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.failed(0x11000F, "activateResourceAdaptorEntity() failed");
        }
        this.getLog().info("Waiting for RA Entity to enter Stopping state");
        timeout = System.currentTimeMillis() + (long)this.utils().getTestTimeout();
        while (System.currentTimeMillis() < timeout) {
            try {
                currentState = theResourceManagementMBean.getState(this.theEntity);
            }
            catch (Exception e) {
                this.getLog().warning(e);
                return TCKTestResult.failed(0x11001C, "getState() failed");
            }
            if (currentState.isStopping() || currentState.isInactive()) break;
            Thread.sleep(500L);
        }
        this.getLog().fine("1114140: currentState for raID2 = " + currentState.toString());
        if (currentState.isStopping()) {
            this.logSuccessfulCheck(0x11000F);
        } else if (currentState.isInactive()) {
            this.getLog().info("Was waiting for RA Entity to enter Stopping state, but it was already Inactive by the time we checked.  Nothing we can do about this, so continue.");
        } else {
            return TCKTestResult.failed(0x11000F, "currentState is not STOPPING but: " + currentState.toString());
        }
        return TCKTestResult.passed();
    }

    private TCKTestResult checkResourceAdaptorsFinished(ResourceManagementMBeanProxy theResourceManagementMBean) {
        this.getLog().fine("checkResourceAdaptorsFinished: Checking raID2 is no longer active");
        try {
            ResourceAdaptorEntityState currentState = theResourceManagementMBean.getState(this.theEntity);
            this.getLog().fine("1114140: currentState for raID2 = " + currentState.toString());
            if (!currentState.isInactive()) {
                return TCKTestResult.failed(0x11001C, "currentState is not INACTIVE but: " + currentState.toString());
            }
            this.logSuccessfulCheck(0x11001C);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.failed(0x11001C, "getState() failed");
        }
        try {
            this.getLog().info("Deactivating Resource Adaptor Entity: " + this.raEntityName);
            this.utils().deactivateResourceAdaptorEntity(this.raEntityName);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.failed(0x11000F, "deactivateResourceAdaptorEntity () failed for " + this.raEntityName);
        }
        try {
            ServiceState serviceState;
            DeploymentMBeanProxy deploymentMBean = this.utils().getDeploymentMBeanProxy();
            ServiceManagementMBeanProxy serviceMBean = this.utils().getServiceManagementMBeanProxy();
            this.getLog().info("Deactivating Service: " + this.serviceID);
            serviceMBean.deactivate(this.serviceID);
            long timeout = System.currentTimeMillis() + (long)this.utils().getTestTimeout();
            while (System.currentTimeMillis() < timeout && !(serviceState = serviceMBean.getState(this.serviceID)).isInactive()) {
                Thread.sleep(500L);
            }
            this.getLog().info("Uninstall SBB: " + this.sbbDUID);
            deploymentMBean.uninstall(this.sbbDUID);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.error("Uninstall service failed for " + this.raEntityName);
        }
        try {
            theResourceManagementMBean.unbindLinkName(this.bindLinkName);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.failed(0x110002, "unbindLinkName() failed");
        }
        try {
            this.linkNames = theResourceManagementMBean.getLinkNames(this.raEntityName);
            if (this.linkNames.length > 0) {
                return TCKTestResult.failed(0x110002, "unbindLinkName still has LinkNames for raID");
            }
            this.logSuccessfulCheck(0x110002);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.failed(1114090, "getLinkNames() failed");
        }
        try {
            this.getLog().fine("1114050: Call to removeResourceAdaptorEntity for " + this.theEntity);
            theResourceManagementMBean.removeResourceAdaptorEntity(this.theEntity);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.failed(1114050, "removeResourceAdaptorEntity() failed");
        }
        try {
            boolean found = false;
            this.resourceEntities = theResourceManagementMBean.getResourceAdaptorEntities();
            for (int i = 0; i < this.resourceEntities.length; ++i) {
                this.getLog().fine("1114108: getResourceAdaptorEntities = " + this.resourceEntities[i]);
                if (!this.resourceEntities[i].contains(this.theEntity)) continue;
                this.logSuccessfulCheck(1114050);
                found = true;
            }
            if (found) {
                return TCKTestResult.failed(1114050, "removeResourceAdaptorEntity() failed to remove RA Entity ");
            }
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.failed(1114108, "getResourceAdaptorEntities() failed");
        }
        return TCKTestResult.passed();
    }

    private void logSuccessfulCheck(int assertionID) {
        this.utils().getLog().info("Check for assertion " + assertionID + " OK");
    }

    private class CallbackListener
    implements MessageHandler {
        private FutureResult result;
        private int expectedCount;
        private HashSet raEntities = new HashSet();

        public CallbackListener(FutureResult result, int expectedCount) {
            this.result = result;
            this.expectedCount = expectedCount;
            Test1114096Test.this.getLog().fine("CallbackListener received message ");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean handleMessage(Object objectMessage) {
            if (objectMessage instanceof TCKMessage) {
                TCKMessage message = (TCKMessage)objectMessage;
                UOID uoid = message.getUID();
                int method = message.getMethod();
                if (method == 5) {
                    HashSet hashSet = this.raEntities;
                    synchronized (hashSet) {
                        this.raEntities.add(uoid);
                        if (this.raEntities.size() == this.expectedCount) {
                            this.result.setPassed();
                        }
                    }
                }
                if (method == 6) {
                    HashSet hashSet = this.raEntities;
                    synchronized (hashSet) {
                        this.raEntities.remove(uoid);
                    }
                }
                return true;
            }
            return false;
        }
    }
}

