/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.ProfileProvisioningMBean;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.slee.InvalidArgumentException;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.profile.UnrecognizedProfileSpecificationException;

public class Test1114403Test
implements SleeTCKTest {
    private static final String PROFILE_DU_PATH_PARAM = "profileDUPath";
    private static final int ASSERTION_ID = 1114403;
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private ProfileUtils profileUtils;
    private Vector tablesAdded;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        ProfileProvisioningMBeanProxy profileProvisioningProxy = this.profileUtils.getProfileProvisioningProxy();
        ProfileSpecificationID profileSpecID = new ComponentIDLookup(this.utils).lookupProfileSpecificationID("SimpleProfile11", "jain.slee.tck", "1.1");
        if (profileSpecID == null) {
            throw new TCKTestErrorException("No ProfileSpecification found.");
        }
        String validName = "Test1114403Profile";
        try {
            this.utils.getLog().info("Attempting to create a profile table with the following valid name: " + validName);
            profileProvisioningProxy.createProfileTable(profileSpecID, validName);
            this.tablesAdded.addElement(validName);
            this.utils.getLog().info("The createProfileTable() method threw no Exception. Calling getProfileTables() to check whether the profile table was created");
            Collection profileTableNames = profileProvisioningProxy.getProfileTables(profileSpecID);
            if (profileTableNames.size() < 1 || profileTableNames == null || !profileTableNames.contains(validName)) {
                throw new TCKTestFailureException(1114403, "Failed to create a profile table with the following valid name: " + validName + ". createProfileTable() threw no Exception, " + "but the profile table name did not exist in the set of names returned by getProfileTables().");
            }
            this.utils.getLog().info("The profile table was created successfully");
            this.utils.getLog().info("profileSpecID is: " + profileSpecID);
            this.logSuccessfulCheck(1114403);
        }
        catch (InvalidArgumentException e) {
            throw new TCKTestFailureException(1114403, "Caught unexpected InvalidArgumentException when trying to create a profile table with the following valid name: " + validName, (Exception)((Object)e));
        }
        catch (Exception e) {
            this.utils.getLog().warning(e);
        }
        ProfileSpecificationID nullProfileSpecID = null;
        try {
            Collection profileTableNames = profileProvisioningProxy.getProfileTables(nullProfileSpecID);
            return TCKTestResult.failed(1114556, "ProfileProvisioningMBean.getProfileTables has not thrown Exception: NullPointerException");
        }
        catch (NullPointerException e) {
            this.logSuccessfulCheck(1114556);
        }
        catch (Exception e) {
            this.utils.getLog().warning(e);
            return TCKTestResult.failed(1114556, "ProfileProvisioningMBean.getProfileTables has thrown Exception: " + e.getClass().toString());
        }
        ProfileSpecificationID badProfileSpecID = new ProfileSpecificationID("badProfile", "jain.slee.tck", "1.1");
        try {
            Collection profileTableNames = profileProvisioningProxy.getProfileTables(badProfileSpecID);
            return TCKTestResult.failed(1114557, "ProfileProvisioningMBean.getProfileTables has thrown Exception: UnrecognizedProfileSpecificationException");
        }
        catch (UnrecognizedProfileSpecificationException e) {
            this.logSuccessfulCheck(1114557);
        }
        catch (Exception e) {
            this.utils.getLog().warning(e);
            return TCKTestResult.failed(1114557, "ProfileProvisioningMBean.getProfileTables has thrown Exception: " + e.getClass().toString());
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        this.tablesAdded = new Vector();
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        String duPath = this.utils.getTestParams().getProperty(PROFILE_DU_PATH_PARAM);
        this.utils.getLog().fine("Installing the profile spec: " + duPath);
        this.utils.install(duPath);
        this.profileUtils = new ProfileUtils(this.utils);
    }

    public void tearDown() throws Exception {
        if (this.profileUtils != null && this.tablesAdded != null && !this.tablesAdded.isEmpty()) {
            Iterator tablesAddedIter = this.tablesAdded.iterator();
            while (tablesAddedIter.hasNext()) {
                try {
                    this.profileUtils.removeProfileTable((String)tablesAddedIter.next());
                }
                catch (Exception e) {
                    this.utils.getLog().warning(e);
                }
            }
        }
        this.utils.getLog().fine("Uninstalling the profile spec");
        this.utils.uninstallAll();
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().removeResourceListener();
    }

    private void logSuccessfulCheck(int assertionID) {
        this.utils.getLog().info("Check for assertion " + assertionID + " OK");
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public void onException(Exception e) throws RemoteException {
            Test1114403Test.this.utils.getLog().warning("Received exception from the TCK resource");
            Test1114403Test.this.utils.getLog().warning(e);
        }
    }
}

