/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.ProfileProvisioningMBean;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Vector;
import javax.management.ObjectName;
import javax.slee.InvalidArgumentException;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.profile.UnrecognizedProfileNameException;

public class ProfileNamesTest
implements SleeTCKTest {
    private static final String PROFILE_DU_PATH_PARAM = "profileDUPath";
    private static final String PROFILE_TABLE_NAME = "ProfileNamesTest_ProfileTable";
    private static final int ASSERTION_ID = 2429;
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private ProfileUtils profileUtils;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        ProfileProvisioningMBeanProxy profileProvisioningProxy = this.profileUtils.getProfileProvisioningProxy();
        ProfileSpecificationID profileSpecID = new ComponentIDLookup(this.utils).lookupProfileSpecificationID("SimpleProfile", "jain.slee.tck", "1.0");
        if (profileSpecID == null) {
            throw new TCKTestErrorException("No ProfileSpecification found.");
        }
        profileProvisioningProxy.createProfileTable(profileSpecID, PROFILE_TABLE_NAME);
        try {
            profileProvisioningProxy.createProfile(PROFILE_TABLE_NAME, null);
            throw new TCKTestFailureException(3897, "createProfile() failed to throw the excpected NullPointerException with a null profile name argument");
        }
        catch (NullPointerException e) {
            this.utils.getLog().info("Caught the expected NullPointerException from createProfile() with a null profile name");
            try {
                profileProvisioningProxy.createProfile(null, "validProfileName");
                throw new TCKTestFailureException(3897, "createProfile() failed to throw the excpected NullPointerException with a null profile table name argument");
            }
            catch (NullPointerException e2) {
                this.utils.getLog().info("Caught the expected NullPointerException from createProfile() with a null profile table name");
                try {
                    profileProvisioningProxy.createProfile(PROFILE_TABLE_NAME, "");
                    throw new TCKTestFailureException(3899, "createProfile() failed to throw the excpected InvalidArgumentException with a zero length profile name argument");
                }
                catch (InvalidArgumentException e3) {
                    this.utils.getLog().info("Caught the expected InvalidArgumentException from createProfile() with a zero length profile table name");
                    StringBuffer validNameBuf = new StringBuffer();
                    for (char validChar = ' '; validChar < '~'; validChar = (char)(validChar + '\u0001')) {
                        validNameBuf.append(validChar);
                    }
                    String validName = validNameBuf.toString();
                    try {
                        ObjectName profileMBeanName;
                        this.utils.getLog().info("Attempting to create a profile with the following valid name: " + validName);
                        ObjectName created = profileProvisioningProxy.createProfile(PROFILE_TABLE_NAME, validName);
                        this.utils.getMBeanProxyFactory().createProfileMBeanProxy(created).commitProfile();
                        this.utils.getLog().info("The createProfile() method threw no Exception. Calling getProfile() to check whether the profile was created");
                        try {
                            profileMBeanName = profileProvisioningProxy.getProfile(PROFILE_TABLE_NAME, validName);
                        }
                        catch (UnrecognizedProfileNameException e4) {
                            throw new TCKTestFailureException(2429, "Failed to create a profile with the following valid name: " + validName + ". createProfile() threw no Exception, " + "but getProfile() threw an UnrecognizedProfileNameException when trying to access the profile");
                        }
                        if (profileMBeanName == null) {
                            throw new TCKTestFailureException(2429, "Failed to create a profile with the following valid name: " + validName + ". createProfile() threw no Exception, " + "but getProfile() returned a null ObjectName for the named profile.");
                        }
                        this.utils.getLog().info("getProfile() returned a non-null ObjectName: " + profileMBeanName);
                    }
                    catch (InvalidArgumentException e5) {
                        throw new TCKTestFailureException(2429, "Caught unexpected InvalidArgumentException when trying to create a profile with the following valid name: " + validName, (Exception)((Object)e5));
                    }
                    Vector<Character> invalidCharacters = new Vector<Character>();
                    for (char invalidChar = '\u0000'; invalidChar < '\u001f'; invalidChar = (char)(invalidChar + '\u0001')) {
                        invalidCharacters.addElement(new Character(invalidChar));
                    }
                    invalidCharacters.addElement(new Character('\u007f'));
                    Iterator invalidCharactersIter = invalidCharacters.iterator();
                    while (invalidCharactersIter.hasNext()) {
                        Character invalidCharacter = (Character)invalidCharactersIter.next();
                        char unicodeValue = invalidCharacter.charValue();
                        try {
                            profileProvisioningProxy.createProfile(PROFILE_TABLE_NAME, invalidCharacter.toString());
                            return TCKTestResult.failed(2429, "The SLEE did not throw the expected InvalidArgumentException when trying to create a profile with an invalid name. The invalid name was a single character of unicode value " + unicodeValue);
                        }
                        catch (InvalidArgumentException e6) {
                            this.utils.getLog().info("Caught expected InvalidArgumentException for an invalid profile name with a character of unicode value " + unicodeValue + ". Error message: " + e6.getMessage());
                        }
                    }
                    return TCKTestResult.passed();
                }
            }
        }
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        this.utils.getLog().fine("Installing the profile spec");
        String duPath = this.utils.getTestParams().getProperty(PROFILE_DU_PATH_PARAM);
        this.utils.install(duPath);
        this.profileUtils = new ProfileUtils(this.utils);
    }

    public void tearDown() throws Exception {
        if (this.profileUtils != null) {
            try {
                this.profileUtils.getProfileProvisioningProxy().removeProfileTable(PROFILE_TABLE_NAME);
            }
            catch (Exception e) {
                this.utils.getLog().warning(e);
            }
        }
        this.utils.getLog().fine("Uninstalling the profile spec");
        this.utils.uninstallAll();
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().removeResourceListener();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public void onException(Exception e) throws RemoteException {
            ProfileNamesTest.this.utils.getLog().warning("Received exception from the TCK resource");
            ProfileNamesTest.this.utils.getLog().warning(e);
        }
    }
}

