/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.NotificationSource;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.SleeManagementMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.TraceMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.impl.TraceMBeanProxyImpl;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.slee.facilities.TraceLevel;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.NotificationSource;
import javax.slee.management.ProfileTableNotification;
import javax.slee.management.TraceNotification;
import javax.slee.profile.ProfileSpecificationID;

public class Test1114235Test
extends AbstractSleeTCKTest {
    public static final String SPEC_NAME = "Test1114235Profile";
    public static final String SPEC_VERSION = "1.1";
    public static final String PROFILE_TABLE_NAME = "Test1114235ProfileTable";
    public static final String PROFILE_NAME = "Test1114235Profile";
    private boolean AssertionChecked = false;
    private ProfileUtils profileUtils;
    private ProfileProvisioningMBeanProxy profileProvisioning;
    private NotificationListener listener;
    private FutureResult result;
    private DeployableUnitID duID;
    private String testName = "Test1114235";
    private int assertionID;
    private ObjectName traceMBeanName;
    private TraceMBeanProxy tracembean;
    private int receivedTraceNotifications = 0;
    private int expectedTraceNotifications;
    private boolean passed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(FutureResult result) throws Exception {
        this.result = result;
        this.expectedTraceNotifications = 1;
        this.getLog().fine("Running Test 1114235...");
        this.doTest1114235Test(TraceLevel.INFO);
        Test1114235Test test1114235Test = this;
        synchronized (test1114235Test) {
            this.wait(this.utils().getTestTimeout());
        }
        if (this.passed && this.expectedTraceNotifications == this.receivedTraceNotifications) {
            result.setPassed();
        } else {
            result.setFailed(this.assertionID, "Expected number of trace messages not received, traces were not delivered by the TraceFacility (expected " + this.expectedTraceNotifications + ", received " + this.receivedTraceNotifications + ")");
        }
    }

    public void doTest1114235Test(TraceLevel traceLevel) throws Exception {
        try {
            this.getLog().fine("Creating profile table Test1114235ProfileTable");
            ProfileSpecificationID specID = new ProfileSpecificationID("Test1114235Profile", "jain.slee.tck", SPEC_VERSION);
            this.profileProvisioning.createProfileTable(specID, PROFILE_TABLE_NAME);
            this.getLog().fine("Added profile table Test1114235ProfileTable");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getLog().warning(e);
            TCKTestResult.error("ERROR creating Profile Table", e);
        }
        String activityName = "Test1114235Test";
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity(activityName);
        this.getLog().info("Firing event: " + this.testName);
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", this.testName, activityID, null);
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to resource");
        this.getLog().fine("Installing and activating service");
        String duPath = this.utils().getTestParams().getProperty("serviceDUPath");
        this.duID = this.utils().install(duPath);
        this.utils().activateServices(this.duID, true);
        SleeManagementMBeanProxy proxy = this.utils().getSleeManagementMBeanProxy();
        this.traceMBeanName = proxy.getTraceMBean();
        this.listener = new TraceNotificationListenerImpl();
        this.tracembean = new TraceMBeanProxyImpl(this.traceMBeanName, this.utils().getMBeanFacade());
        this.tracembean.addNotificationListener(this.listener, null, null);
        DeploymentMBeanProxy duProxy = this.utils().getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        this.getLog().fine("Creating Profile Utils...");
        this.profileUtils = new ProfileUtils(this.utils());
        this.profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
    }

    public void tearDown() throws Exception {
        this.profileProvisioning.removeProfileTable(PROFILE_TABLE_NAME);
        if (null != this.tracembean) {
            this.tracembean.removeNotificationListener(this.listener);
        }
        this.utils().getLog().fine("Disconnecting from resource");
        this.utils().getResourceInterface().clearActivities();
        this.utils().getLog().fine("Deactivating and uninstalling service");
        this.utils().deactivateAllServices();
        this.utils().uninstallAll();
    }

    private boolean doNotficationSourcesCheck(ProfileTableNotification theNotification) {
        String alarmNotify;
        boolean passed = true;
        try {
            String notificationStrVal = theNotification.toString();
            this.utils().getLog().fine("1114234: ProfileTableNotification = " + notificationStrVal);
            this.logSuccessfulCheck(1114234);
        }
        catch (Exception e) {
            this.utils().getLog().warning(e);
            this.result.setFailed(1114234, "toString() failed");
            return false;
        }
        ProfileTableNotification expectedProfileNotification = new ProfileTableNotification(PROFILE_TABLE_NAME);
        ProfileTableNotification notExpectedProfileNotification = new ProfileTableNotification("NonExistantProfileTable");
        try {
            this.getLog().fine("1114232: theNotification.equals : " + theNotification + ", " + expectedProfileNotification);
            if (theNotification.equals((Object)expectedProfileNotification)) {
                this.logSuccessfulCheck(1114232);
            } else {
                this.result.setFailed(1114232, ".equals() failed");
                passed = false;
            }
        }
        catch (Exception e) {
            this.getLog().warning(e);
            this.result.setFailed(1114232, ".equals() failed");
            return false;
        }
        try {
            int areCompared = theNotification.compareTo((Object)expectedProfileNotification);
            if (areCompared == 0) {
                areCompared = theNotification.compareTo((Object)notExpectedProfileNotification);
                this.getLog().fine("11142238: notExpectedProfileNotification = : " + notExpectedProfileNotification);
                if (areCompared != 0) {
                    this.logSuccessfulCheck(1114238);
                } else {
                    this.result.setFailed(1114238, ".compareTo() failed non-equal test");
                }
            } else {
                this.result.setFailed(1114238, ".compareTo() failed");
                passed = false;
            }
        }
        catch (Exception e) {
            this.getLog().warning(e);
            this.result.setFailed(1114238, ".compareTo() failed");
            return false;
        }
        try {
            theNotification.hashCode();
            this.logSuccessfulCheck(1114237);
        }
        catch (Exception e) {
            this.result.setFailed(1114237, ".hashCode() failed");
            return false;
        }
        try {
            alarmNotify = theNotification.getAlarmNotificationType();
            this.utils().getLog().fine("1114233: getAlarmNotificationType = " + alarmNotify);
            if (alarmNotify.equals("javax.slee.management.alarm.profiletable")) {
                this.logSuccessfulCheck(1114233);
            } else {
                this.result.setFailed(1114233, "getAlarmNotificationType() failed");
                passed = false;
            }
        }
        catch (Exception e) {
            this.utils().getLog().warning(e);
            this.result.setFailed(1114233, "getAlarmNotificationType() failed");
            return false;
        }
        try {
            alarmNotify = theNotification.getTraceNotificationType();
            this.utils().getLog().fine("1114236: getTraceNotificationType = " + alarmNotify);
            if (alarmNotify.equals("javax.slee.management.trace.profiletable")) {
                this.logSuccessfulCheck(1114236);
            } else {
                this.result.setFailed(1114236, "getTraceNotificationType() failed");
                passed = false;
            }
        }
        catch (Exception e) {
            this.utils().getLog().warning(e);
            this.result.setFailed(1114236, "getTraceNotificationType() failed");
            return false;
        }
        try {
            alarmNotify = theNotification.getUsageNotificationType();
            this.utils().getLog().fine("1114231: getUsageNotificationType = " + alarmNotify);
            if (alarmNotify.equals("javax.slee.management.usage.profiletable")) {
                this.logSuccessfulCheck(0x110077);
            } else {
                this.result.setFailed(0x110077, "getUsageNotificationType() failed");
                passed = false;
            }
        }
        catch (Exception e) {
            this.utils().getLog().warning(e);
            this.result.setFailed(0x110077, "getUsageNotificationType() failed");
            return false;
        }
        return passed;
    }

    private void logSuccessfulCheck(int assertionID) {
        this.utils().getLog().info("Check for assertion " + assertionID + " OK");
    }

    public class TraceNotificationListenerImpl
    implements NotificationListener {
        public final void handleNotification(Notification notification, Object handback) {
            try {
                if (notification instanceof TraceNotification) {
                    TraceNotification traceNotification = (TraceNotification)notification;
                    Test1114235Test.this.getLog().fine("Received Trace Notification from: " + traceNotification);
                    if (traceNotification.getNotificationSource() instanceof ProfileTableNotification && !Test1114235Test.this.AssertionChecked && traceNotification.getType().equals("javax.slee.management.trace.profiletable")) {
                        Test1114235Test.this.logSuccessfulCheck(1114235);
                        NotificationSource notificationSource = traceNotification.getNotificationSource();
                        ProfileTableNotification profileTableNotification = (ProfileTableNotification)notificationSource;
                        Test1114235Test.this.passed = Test1114235Test.this.doNotficationSourcesCheck(profileTableNotification);
                        if (Test1114235Test.this.passed) {
                            Test1114235Test.this.receivedTraceNotifications++;
                            Test1114235Test.this.AssertionChecked = true;
                        } else {
                            Test1114235Test.this.result.setFailed(1114235, "NotficationSources Check failed");
                        }
                    }
                }
            }
            catch (Exception e) {
                Test1114235Test.this.utils().getLog().warning(e);
                Test1114235Test.this.getLog().warning("1114235: FAILED. Received erroneous Trace Message: " + notification.getMessage());
            }
        }
    }
}

