/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.ManagementMBean;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import javax.slee.ComponentID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;

public class Test1609Test
extends AbstractSleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 1609;
    private DeployableUnitID duID;

    public TCKTestResult run() throws Exception {
        DeploymentMBeanProxy duProxy = this.utils().getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        if (components.length == 0) {
            return TCKTestResult.error("Installed deployable unit had no components");
        }
        this.getLog().info("Calling DeploymentMBean.isInstalled(ComponentID)");
        if (!duProxy.isInstalled(components[0])) {
            return TCKTestResult.failed(1609, "isInstalled() returned false for installed Component");
        }
        this.getLog().info("Uninstalling the Component");
        duProxy.uninstall(this.duID);
        this.getLog().info("Calling DeploymentMBean.isInstalled(ComponentID)");
        if (duProxy.isInstalled(components[0])) {
            return TCKTestResult.failed(1609, "isInstalled() returned true for uninstalled Component");
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        this.getLog().fine("Installing and activating service");
        String duPath = this.utils().getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils().install(duPath);
    }
}

