/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.javax.slee.usage.UsageUpdatedFilter;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.OperationTimedOutException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageSbbInstructions;
import com.opencloud.sleetck.lib.testsuite.usage.common.UsageMBeanLookup;
import com.opencloud.sleetck.lib.testutils.QueuingNotificationListener;
import com.opencloud.sleetck.lib.testutils.QueuingResourceListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.usage.UsageNotification;
import javax.slee.usage.UsageUpdatedFilter;

public class UsageUpdatedFilterTest
extends AbstractSleeTCKTest {
    private static final String CHOSEN_PARAMETER_NAME = "timeBetweenNewConnections";
    private QueuingResourceListener resourceListener;
    private UsageMBeanLookup usageMBeanLookupParentA;
    private UsageMBeanLookup usageMBeanLookupChildA;
    private UsageMBeanLookup usageMBeanLookupParentB;
    private UsageMBeanLookup usageMBeanLookupChildB;
    private QueuingNotificationListener notificationListener;
    private UsageUpdatedFilter usageUpdatedFilter;
    private int notificationsReceived;
    private SbbID chosenSbbID;
    private ServiceID chosenServiceID;
    private LinkedList expectedValues;

    public TCKTestResult run() throws Exception {
        this.checkNullPointerExceptions();
        this.notificationListener = new QueuingNotificationListener(this.utils());
        this.usageUpdatedFilter = new UsageUpdatedFilter(this.chosenServiceID, this.chosenSbbID, CHOSEN_PARAMETER_NAME);
        UsageMBeanLookup[] usageMBeanLookups = new UsageMBeanLookup[]{this.usageMBeanLookupChildA, this.usageMBeanLookupChildB, this.usageMBeanLookupParentA, this.usageMBeanLookupParentB};
        for (int i = 0; i < usageMBeanLookups.length; ++i) {
            UsageMBeanLookup usageMBeanLookup = usageMBeanLookups[i];
            usageMBeanLookup.getUnnamedSbbUsageMBeanProxy().addNotificationListener(this.notificationListener, (NotificationFilter)this.usageUpdatedFilter, null);
        }
        this.utils().getTraceMBeanProxy().addNotificationListener(this.notificationListener, (NotificationFilter)this.usageUpdatedFilter, null);
        GenericUsageSbbInstructions instructions = new GenericUsageSbbInstructions(null);
        instructions.addFirstCountIncrement(1L);
        instructions.addSecondCountIncrement(2L);
        instructions.addTimeBetweenErrorsSample(3L);
        instructions.addTimeBetweenNewConnectionsSamples(4L);
        this.expectedValues.add(new Long(4L));
        TCKActivityID activityID = this.utils().getResourceInterface().createActivity("UsageUpdatedFilterTest-Activity");
        this.utils().getResourceInterface().fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", instructions.toExported(), activityID, null);
        this.utils().getResourceInterface().fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2", instructions.toExported(), activityID, null);
        this.utils().getResourceInterface().fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y1", instructions.toExported(), activityID, null);
        this.getLog().info("Waiting for replies from the SBBs");
        this.resourceListener.nextMessage();
        this.resourceListener.nextMessage();
        this.getLog().info("Waiting for usage notifications");
        this.auditNotification(this.getNextNotificationOrFail());
        this.getLog().info("Sending second request to SBB A");
        instructions = new GenericUsageSbbInstructions(null);
        instructions.addTimeBetweenNewConnectionsSamples(6L);
        this.expectedValues.add(new Long(6L));
        this.utils().getResourceInterface().fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2", instructions.toExported(), activityID, null);
        this.getLog().info("Waiting for reply from the SBB");
        this.resourceListener.nextMessage();
        this.getLog().info("Waiting for usage notification");
        this.auditNotification(this.getNextNotificationOrFail());
        return TCKTestResult.passed();
    }

    private void checkNullPointerExceptions() throws TCKTestFailureException {
        try {
            new UsageUpdatedFilter(this.chosenServiceID, this.chosenSbbID, null);
            throw new TCKTestFailureException(4237, "Failed to fire a NullPointerException while trying to create a UsageUpdatedFilter witha null parameter name");
        }
        catch (NullPointerException e) {
            this.getLog().info("Caught excpected NullPointerException while trying to create a UsageUpdatedFilter with a null parameter name");
            try {
                new UsageUpdatedFilter(this.chosenServiceID, null, CHOSEN_PARAMETER_NAME);
                throw new TCKTestFailureException(4237, "Failed to fire a NullPointerException while trying to create a UsageUpdatedFilter witha null sbb id");
            }
            catch (NullPointerException e2) {
                this.getLog().info("Caught excpected NullPointerException which trying to create a UsageUpdatedFilter with a null sbb id");
                try {
                    new UsageUpdatedFilter(null, this.chosenSbbID, CHOSEN_PARAMETER_NAME);
                    throw new TCKTestFailureException(4237, "Failed to fire a NullPointerException while trying to create a UsageUpdatedFilter witha null service id");
                }
                catch (NullPointerException e3) {
                    this.getLog().info("Caught excpected NullPointerException which trying to create a UsageUpdatedFilter with a null service id");
                    return;
                }
            }
        }
    }

    private void auditNotification(Notification notification) throws Exception {
        this.getLog().info("Auditing notification: " + notification);
        if (!(notification instanceof UsageNotification)) {
            throw new TCKTestFailureException(4235, "UsageUpadtedFilter allowed a notification to pass which was not a UsageNotification: " + notification);
        }
        UsageNotification usageNotification = (UsageNotification)notification;
        if (!usageNotification.getService().equals((Object)this.chosenServiceID)) {
            throw new TCKTestFailureException(4234, "UsageUpadtedFilter allowed a notification to pass with a non-matching ServiceID. Chosen ServiceID:" + this.chosenServiceID + ", found ServiceID:" + usageNotification.getService());
        }
        if (!usageNotification.getSbb().equals((Object)this.chosenSbbID)) {
            throw new TCKTestFailureException(4234, "UsageUpadtedFilter allowed a notification to pass with a non-matching SbbID. Chosen SbbID:" + this.chosenSbbID + ", found SbbID:" + usageNotification.getSbb());
        }
        if (!usageNotification.getUsageParameterName().equals(CHOSEN_PARAMETER_NAME)) {
            throw new TCKTestFailureException(4234, "UsageUpadtedFilter allowed a notification to pass with a non-matching parameter name. Chosen parameter name:timeBetweenNewConnections, found parameter name:" + usageNotification.getUsageParameterName());
        }
        long nextExpectedValue = (Long)this.expectedValues.get(this.notificationsReceived - 1);
        if (nextExpectedValue != usageNotification.getValue()) {
            throw new TCKTestFailureException(4234, "Missed expected usage notification with value " + nextExpectedValue + ", which appears to have been illegally filtered by the UsageUpdatedFilter. " + "Expected values:" + this.formatLongs(this.expectedValues) + "; number of received expected values:" + (this.notificationsReceived - 1) + "; value of this notification:" + usageNotification.getValue());
        }
    }

    private Notification getNextNotificationOrFail() throws TCKTestFailureException {
        try {
            Notification rNotification = this.notificationListener.nextNotification();
            this.getLog().info("Received notification: " + rNotification);
            ++this.notificationsReceived;
            return rNotification;
        }
        catch (OperationTimedOutException e) {
            throw new TCKTestFailureException(4234, "Timed out while waiting for expected UsageNotification, indicating that the notification was filtered illegally by the UsageUpdatedFilter. Notifications received so far: " + this.notificationsReceived);
        }
    }

    private String formatLongs(List listOfLongs) {
        if (listOfLongs.isEmpty()) {
            return "(empty set)";
        }
        Iterator iter = listOfLongs.iterator();
        StringBuffer buf = new StringBuffer("(" + iter.next());
        while (iter.hasNext()) {
            buf.append("," + iter.next());
        }
        return buf.append(")").toString();
    }

    public void setUp() throws Exception {
        super.setUp();
        this.notificationsReceived = 0;
        this.expectedValues = new LinkedList();
        this.usageMBeanLookupParentA = new UsageMBeanLookup("UsageFilterTestsServiceA", "UsageFilterTestsParentSbbA", this.utils());
        this.usageMBeanLookupChildA = new UsageMBeanLookup("UsageFilterTestsServiceA", "UsageFilterTestsChildSbb", this.utils());
        this.usageMBeanLookupParentB = new UsageMBeanLookup("UsageFilterTestsServiceB", "UsageFilterTestsParentSbbB", this.utils());
        this.usageMBeanLookupChildB = new UsageMBeanLookup("UsageFilterTestsServiceB", "UsageFilterTestsChildSbb", this.utils());
        this.chosenSbbID = this.usageMBeanLookupChildA.getSbbID();
        this.chosenServiceID = this.usageMBeanLookupChildA.getServiceID();
        this.resourceListener = new QueuingResourceListener(this.utils());
        this.setResourceListener(this.resourceListener);
    }

    public void tearDown() throws Exception {
        UsageMBeanLookup usageMBeanLookup;
        UsageMBeanLookup[] usageMBeanLookups = new UsageMBeanLookup[]{this.usageMBeanLookupChildA, this.usageMBeanLookupChildB, this.usageMBeanLookupParentA, this.usageMBeanLookupParentB};
        if (this.notificationListener != null) {
            for (int i = 0; i < usageMBeanLookups.length; ++i) {
                usageMBeanLookup = usageMBeanLookups[i];
                try {
                    usageMBeanLookup.getUnnamedSbbUsageMBeanProxy().removeNotificationListener(this.notificationListener);
                    continue;
                }
                catch (Exception e) {
                    this.getLog().warning(e);
                }
            }
            try {
                this.utils().getTraceMBeanProxy().removeNotificationListener(this.notificationListener);
            }
            catch (Exception e) {
                this.getLog().warning(e);
            }
        }
        for (int i = 0; i < usageMBeanLookups.length; ++i) {
            usageMBeanLookup = usageMBeanLookups[i];
            if (usageMBeanLookup == null) continue;
            usageMBeanLookup.closeAllMBeans();
        }
        super.tearDown();
    }
}

