/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.javax.slee.profile.AddressProfileCMP;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.impl.AddressProfileProxyImpl;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.management.ObjectName;
import javax.slee.Address;
import javax.slee.AddressPlan;
import javax.slee.ComponentID;
import javax.slee.ServiceID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.ServiceDescriptor;
import javax.slee.profile.ProfileSpecificationDescriptor;
import javax.slee.profile.ProfileSpecificationID;

public class Test4266Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 4266;
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private DeployableUnitID duID;
    private TCKActivityID activityID;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        ProfileProvisioningMBeanProxy profileProvisioningProxy = new ProfileUtils(this.utils).getProfileProvisioningProxy();
        DeploymentMBeanProxy duProxy = this.utils.getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        String addressProfileTable = null;
        ProfileSpecificationID profileSpecID = null;
        ComponentID[] components = duDesc.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof ServiceID)) continue;
            ServiceDescriptor serviceDesc = (ServiceDescriptor)duProxy.getDescriptor(components[i]);
            addressProfileTable = serviceDesc.getAddressProfileTable();
        }
        ProfileSpecificationID[] profiles = duProxy.getProfileSpecifications();
        for (int i = 0; i < profiles.length; ++i) {
            ProfileSpecificationDescriptor desc = (ProfileSpecificationDescriptor)duProxy.getDescriptor((ComponentID)profiles[i]);
            this.utils.getLog().fine("Current profile spec cmp interface name is " + desc.getCMPInterfaceName());
            if (!desc.getCMPInterfaceName().equals("javax.slee.profile.AddressProfileCMP")) continue;
            profileSpecID = profiles[i];
        }
        if (addressProfileTable == null) {
            this.utils.getLog().fine("No AddressProfileTable found in Service.");
            throw new Exception("No AddressProfileTable found in Service.");
        }
        if (profileSpecID == null) {
            this.utils.getLog().fine("Unable to find ProfileSpecificationID for Address Profile.");
            throw new Exception("Unable to find ProfileSpecificationID for Address Profile.");
        }
        profileProvisioningProxy.createProfileTable(profileSpecID, addressProfileTable);
        ObjectName profileMBeanName = profileProvisioningProxy.createProfile(addressProfileTable, "Test4266Profile");
        AddressProfileProxyImpl profileProxy = new AddressProfileProxyImpl(profileMBeanName, this.utils.getMBeanFacade());
        Address[] addresses = new Address[]{new Address(AddressPlan.IP, "127.0.0.1")};
        profileProxy.setAddresses(addresses);
        profileProxy.commitProfile();
        profileProxy.closeProfile();
        this.result = new FutureResult(this.utils.getLog());
        TCKResourceTestInterface resource = this.utils.getResourceInterface();
        this.activityID = resource.createActivity("Test4266InitialActivity");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", this.activityID, null);
        return this.result.waitForResultOrFail(this.utils.getTestTimeout(), "Timeout waiting for test result.", 4266);
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        this.utils.getLog().fine("Installing and activating service");
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils.install(duPath);
        this.utils.activateServices(this.duID, true);
    }

    public void tearDown() throws Exception {
        ProfileProvisioningMBeanProxy profileProxy = new ProfileUtils(this.utils).getProfileProvisioningProxy();
        try {
            DeploymentMBeanProxy duProxy = this.utils.getDeploymentMBeanProxy();
            DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
            ComponentID[] components = duDesc.getComponents();
            for (int i = 0; i < components.length; ++i) {
                if (!(components[i] instanceof ServiceID)) continue;
                ServiceDescriptor serviceDesc = (ServiceDescriptor)duProxy.getDescriptor(components[i]);
                String addressProfileTable = serviceDesc.getAddressProfileTable();
                profileProxy.removeProfile(addressProfileTable, "Test4266Profile");
                profileProxy.removeProfileTable(addressProfileTable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            HashMap map = (HashMap)message.getMessage();
            String type = (String)map.get("Type");
            if (type.equals("Result")) {
                Boolean passed = (Boolean)map.get("Result");
                String msgString = (String)map.get("Message");
                Test4266Test.this.utils.getLog().info("Received message from SBB.");
                if (passed.booleanValue()) {
                    Test4266Test.this.result.setPassed();
                } else {
                    Test4266Test.this.result.setFailed((Integer)map.get("ID"), msgString);
                }
            } else {
                Test4266Test.this.utils.getLog().info("Unexpected test message.");
                Test4266Test.this.result.setError("Received unexpected message from SBB.");
            }
        }

        public void onException(Exception e) throws RemoteException {
            Test4266Test.this.utils.getLog().warning("Received exception from SBB");
            Test4266Test.this.utils.getLog().warning(e);
            Test4266Test.this.result.setError(e);
        }
    }
}

