/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.javax.slee.management.SleeManagementMBean;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.SleeManagementMBeanProxy;
import javax.management.ObjectName;
import javax.slee.InvalidArgumentException;
import javax.slee.SbbID;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.ManagementException;
import javax.slee.management.UnrecognizedSubsystemException;

public class Test1114500Test
extends AbstractSleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "serviceDUPath";
    private static final int TEST_ID = 1114500;
    private DeployableUnitID duID;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCKTestResult run() throws Exception {
        SleeManagementMBeanProxy sleeProxy;
        boolean subsystemWithUsageExists = false;
        boolean subsystemWithoutUsageExists = false;
        String usageSubsystem = null;
        String noUsageSubsystem = null;
        TCKTestResult testResult = null;
        try {
            sleeProxy = this.utils().getSleeManagementMBeanProxy();
            String strObjectName = this.utils().getSleeManagementMBeanName().toString();
            this.getLog().fine("1114301: SleeManagementMBean = " + strObjectName);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.error("Failed to create SleeManagementMBean");
        }
        try {
            String[] installedSubsystems = sleeProxy.getSubsystems();
            this.logSuccessfulCheck(0x110188);
            for (int i = 0; i < installedSubsystems.length; ++i) {
                this.utils().getLog().fine("Installed Subsystem is: " + installedSubsystems[i]);
                try {
                    boolean usage = sleeProxy.hasUsage(installedSubsystems[i]);
                    this.utils().getLog().fine("Installed Subsystem hasUsage = " + usage);
                    if (usage) {
                        usageSubsystem = installedSubsystems[i];
                        subsystemWithUsageExists = true;
                    } else {
                        noUsageSubsystem = installedSubsystems[i];
                        subsystemWithoutUsageExists = true;
                    }
                }
                catch (Exception e) {
                    TCKTestResult tCKTestResult = TCKTestResult.failed(1114507, "SleeManagementMBeanProxy.hasUsage() has thrown Exception: " + e.getClass().toString());
                    this.utils().getLog().fine("Test Complete");
                    return tCKTestResult;
                }
                try {
                    continue;
                }
                catch (ManagementException e) {
                    TCKTestResult tCKTestResult = TCKTestResult.failed(0x110188, "The Installed Subsystems name(s) could not obtained due to a system-level failure");
                    return tCKTestResult;
                }
                catch (Exception e) {
                    TCKTestResult tCKTestResult = TCKTestResult.failed(0x110188, "SleeManagementMBeanProxy.getSubsystems() has thrown Exception: " + e.getClass().toString());
                    return tCKTestResult;
                }
            }
            if (subsystemWithoutUsageExists) {
                this.utils().getLog().fine("Checking SleeManagementMBean for subsystem without Usage...");
                testResult = this.checkSleeSubsystems(sleeProxy, noUsageSubsystem, false);
            }
            if (subsystemWithUsageExists && (testResult == null || testResult == TCKTestResult.passed())) {
                this.utils().getLog().fine("Now checking SleeManagementMBean for subsystem with Usage...");
                testResult = this.checkSleeSubsystems(sleeProxy, usageSubsystem, true);
            }
        }
        finally {
            this.utils().getLog().fine("Test Complete");
        }
        return testResult;
    }

    public TCKTestResult checkSleeSubsystems(SleeManagementMBeanProxy sleeProxy, String installedSubsystem, boolean subsystemUsage) throws Exception {
        ObjectName objectName;
        ObjectName objectName2;
        ObjectName objectName3;
        String[] usageParams;
        boolean usage;
        String usageParam = "NoUsageParams";
        String[] notrecognizedusageParams = null;
        String notrecognizedSubsystem = "notrecognizedSubsystem";
        String nullSubsystem = null;
        try {
            usage = sleeProxy.hasUsage(installedSubsystem);
            if (usage != subsystemUsage) {
                return TCKTestResult.failed(1114507, "SleeManagementMBeanProxy.hasUsage() has returned incorrect value: " + usage);
            }
            this.logSuccessfulCheck(1114507);
        }
        catch (UnrecognizedSubsystemException e) {
            return TCKTestResult.failed(1114507, "The Installed Subsystems name(s) was not recognised");
        }
        catch (ManagementException e) {
            return TCKTestResult.failed(1114507, "The Installed Subsystems name(s) could not obtained due to a system-level failure");
        }
        catch (Exception e) {
            return TCKTestResult.failed(1114507, "SleeManagementMBeanProxy.hasUsage() has thrown Exception: " + e.getClass().toString());
        }
        try {
            usage = sleeProxy.hasUsage(notrecognizedSubsystem);
            return TCKTestResult.failed(1114508, "SleeManagementMBeanProxy.hasUsage() has not thrown Exception: UnrecognizedSubsystemException");
        }
        catch (UnrecognizedSubsystemException e) {
            this.logSuccessfulCheck(1114508);
        }
        catch (Exception e) {
            return TCKTestResult.failed(1114508, "SleeManagementMBeanProxy.hasUsage() has thrown Exception: " + e.getClass().toString());
        }
        try {
            usageParams = sleeProxy.getUsageParameterSets(installedSubsystem);
            this.logSuccessfulCheck(1114511);
            usageParam = usageParams[0];
        }
        catch (NullPointerException e) {
            return TCKTestResult.failed(1114511, "The Installed Subsystems name(s) was null");
        }
        catch (UnrecognizedSubsystemException e) {
            return TCKTestResult.failed(1114511, "The Installed Subsystems name(s) was not recognised");
        }
        catch (InvalidArgumentException e) {
            if (!subsystemUsage) {
                this.logSuccessfulCheck(1114511);
            }
            return TCKTestResult.failed(1114511, "The Installed Subsystems name(s) was not valid");
        }
        catch (ManagementException e) {
            return TCKTestResult.failed(1114511, "The Installed Subsystems name(s) could not obtained due to a system-level failure");
        }
        catch (Exception e) {
            return TCKTestResult.failed(1114511, "SleeManagementMBeanProxy.getUsageParameterSets() has thrown Exception: " + e.getClass().toString());
        }
        try {
            usageParams = sleeProxy.getUsageParameterSets(nullSubsystem);
            return TCKTestResult.failed(0x110190, "SleeManagementMBeanProxy.getUsageParameterSets() has not thrown Exception NullPointerException");
        }
        catch (NullPointerException e) {
            this.logSuccessfulCheck(0x110190);
        }
        catch (Exception e) {
            return TCKTestResult.failed(0x110190, "SleeManagementMBeanProxy.getUsageParameterSets() has thrown Exception: " + e.getClass().toString());
        }
        try {
            String[] usageParams2 = sleeProxy.getUsageParameterSets(notrecognizedSubsystem);
            return TCKTestResult.failed(0x110191, "SleeManagementMBeanProxy.getUsageParameterSets() has not thrown Exception UnrecognizedSubsystemException");
        }
        catch (UnrecognizedSubsystemException e) {
            this.logSuccessfulCheck(0x110191);
        }
        catch (Exception e) {
            return TCKTestResult.failed(0x110191, "SleeManagementMBeanProxy.getUsageParameterSets() has thrown Exception: " + e.getClass().toString());
        }
        if (!subsystemUsage) {
            try {
                String[] usageParams3 = sleeProxy.getUsageParameterSets(installedSubsystem);
                return TCKTestResult.failed(1114514, "SleeManagementMBeanProxy.getUsageParameterSets() has not thrown Exception UnsupportedOperationException");
            }
            catch (InvalidArgumentException e) {
                this.logSuccessfulCheck(1114514);
            }
            catch (Exception e) {
                return TCKTestResult.failed(1114514, "SleeManagementMBeanProxy.getUsageParameterSets() has thrown Exception: " + e.getClass().toString());
            }
        }
        try {
            objectName3 = sleeProxy.getUsageMBean(installedSubsystem);
            this.logSuccessfulCheck(1114517);
        }
        catch (NullPointerException e) {
            return TCKTestResult.failed(1114517, "The Installed Subsystems name(s) was null");
        }
        catch (UnrecognizedSubsystemException e) {
            return TCKTestResult.failed(1114517, "The Installed Subsystems name(s) was not recognised");
        }
        catch (InvalidArgumentException e) {
            if (!subsystemUsage) {
                this.logSuccessfulCheck(1114517);
            }
            return TCKTestResult.failed(1114517, "The Installed Subsystems name(s) was not valid");
        }
        catch (ManagementException e) {
            return TCKTestResult.failed(1114517, "The Installed Subsystems name(s) could not obtained due to a system-level failure");
        }
        catch (Exception e) {
            return TCKTestResult.failed(1114517, "SleeManagementMBeanProxy.getSubsystems() has thrown Exception: " + e.getClass().toString());
        }
        try {
            objectName3 = sleeProxy.getUsageMBean(nullSubsystem);
            return TCKTestResult.failed(1114518, "SleeManagementMBeanProxy.getUsageMBean() has not thrown Exception NullPointerException");
        }
        catch (NullPointerException e) {
            this.logSuccessfulCheck(1114518);
        }
        catch (Exception e) {
            return TCKTestResult.failed(1114518, "SleeManagementMBeanProxy.getUsageMBean() has thrown Exception: " + e.getClass().toString());
        }
        try {
            ObjectName objectName4 = sleeProxy.getUsageMBean(notrecognizedSubsystem);
            return TCKTestResult.failed(1114519, "SleeManagementMBeanProxy.getUsageMBean() has not thrown Exception: UnrecognizedSubsystemException");
        }
        catch (UnrecognizedSubsystemException e) {
            this.logSuccessfulCheck(1114519);
        }
        catch (Exception e) {
            return TCKTestResult.failed(1114519, "SleeManagementMBeanProxy.getUsageMBean() has thrown Exception: " + e.getClass().toString());
        }
        if (!subsystemUsage) {
            try {
                ObjectName objectName5 = sleeProxy.getUsageMBean(installedSubsystem);
                return TCKTestResult.failed(1114520, "SleeManagementMBeanProxy.getUsageMBean() has not thrown Exception: InvalidArgumentException");
            }
            catch (InvalidArgumentException e) {
                this.logSuccessfulCheck(1114520);
            }
            catch (Exception e) {
                return TCKTestResult.failed(1114520, "SleeManagementMBeanProxy.getUsageMBean() has thrown Exception: " + e.getClass().toString());
            }
        }
        usageParam = "firstCount";
        try {
            objectName2 = sleeProxy.getUsageMBean(installedSubsystem, usageParam);
            this.logSuccessfulCheck(1114523);
        }
        catch (NullPointerException e) {
            return TCKTestResult.failed(1114523, "The Installed Subsystems name(s) was null");
        }
        catch (UnrecognizedSubsystemException e) {
            return TCKTestResult.failed(1114523, "The Installed Subsystems name(s) was not recognised");
        }
        catch (InvalidArgumentException e) {
            if (!subsystemUsage) {
                this.logSuccessfulCheck(1114523);
            }
            return TCKTestResult.failed(1114523, "The Installed Subsystems name(s) was not valid");
        }
        catch (ManagementException e) {
            return TCKTestResult.failed(1114523, "The Installed Subsystems name(s) could not obtained due to a system-level failure");
        }
        catch (Exception e) {
            return TCKTestResult.failed(1114523, "SleeManagementMBeanProxy.getSubsystems() has thrown Exception: " + e.getClass().toString());
        }
        try {
            objectName2 = sleeProxy.getUsageMBean(nullSubsystem, usageParam);
            return TCKTestResult.failed(1114524, "SleeManagementMBeanProxy.getUsageMBean() has not thrown Exception: NullPointerException");
        }
        catch (NullPointerException e) {
            this.logSuccessfulCheck(1114524);
        }
        catch (Exception e) {
            return TCKTestResult.failed(1114524, "SleeManagementMBeanProxy.getUsageMBean() has thrown Exception: " + e.getClass().toString());
        }
        try {
            ObjectName objectName6 = sleeProxy.getUsageMBean(notrecognizedSubsystem, usageParam);
            return TCKTestResult.failed(1114525, "SleeManagementMBeanProxy.getUsageMBean() has not thrown Exception: UnrecognizedSubsystemException");
        }
        catch (UnrecognizedSubsystemException e) {
            this.logSuccessfulCheck(1114525);
        }
        catch (Exception e) {
            return TCKTestResult.failed(1114525, "SleeManagementMBeanProxy.getUsageMBean() has thrown Exception: " + e.getClass().toString());
        }
        try {
            notrecognizedusageParams = sleeProxy.getUsageParameterSets(installedSubsystem);
            notrecognizedusageParams[0] = "Test1114500Test";
            ObjectName objectName7 = sleeProxy.getUsageMBean(installedSubsystem, notrecognizedusageParams[0]);
            return TCKTestResult.failed(1114526, "SleeManagementMBeanProxy.getUsageMBean() has not thrown Exception: UnrecognizedSubsystemException");
        }
        catch (UnrecognizedSubsystemException e) {
            this.logSuccessfulCheck(1114526);
        }
        catch (InvalidArgumentException e) {
            if (!subsystemUsage) {
                this.logSuccessfulCheck(1114526);
            }
            return TCKTestResult.failed(1114526, "SleeManagementMBeanProxy.getUsageMBean() has thrown Exception: " + ((Object)((Object)e)).getClass().toString());
        }
        catch (Exception e) {
            return TCKTestResult.failed(1114526, "SleeManagementMBeanProxy.getUsageMBean() has thrown Exception: " + e.getClass().toString());
        }
        if (!subsystemUsage) {
            try {
                objectName = sleeProxy.getUsageMBean(installedSubsystem, usageParam);
                return TCKTestResult.failed(1114527, "SleeManagementMBeanProxy.getUsageMBean() has not thrown Exception: InvalidArgumentException");
            }
            catch (InvalidArgumentException e) {
                this.logSuccessfulCheck(1114527);
            }
            catch (Exception e) {
                return TCKTestResult.failed(1114527, "SleeManagementMBeanProxy.getUsageMBean() has thrown Exception: " + e.getClass().toString());
            }
        }
        try {
            objectName = sleeProxy.getUsageNotificationManagerMBean(installedSubsystem);
            this.logSuccessfulCheck(1114530);
        }
        catch (NullPointerException e) {
            return TCKTestResult.failed(1114530, "The Installed Subsystems name(s) was null");
        }
        catch (UnrecognizedSubsystemException e) {
            return TCKTestResult.failed(1114530, "The Installed Subsystems name(s) was not recognised");
        }
        catch (InvalidArgumentException e) {
            if (!subsystemUsage) {
                this.logSuccessfulCheck(1114530);
            }
            return TCKTestResult.failed(1114530, "The Installed Subsystems name(s) was not valid");
        }
        catch (ManagementException e) {
            return TCKTestResult.failed(1114530, "The Installed Subsystems name(s) could not obtained due to a system-level failure");
        }
        catch (Exception e) {
            return TCKTestResult.failed(1114530, "SleeManagementMBeanProxy.getUsageNotificationManagerMBean() has thrown Exception: " + e.getClass().toString());
        }
        try {
            objectName = sleeProxy.getUsageNotificationManagerMBean(nullSubsystem);
            return TCKTestResult.failed(1114531, "SleeManagementMBeanProxy.getUsageNotificationManagerMBean() has not thrown Exception: NullPointerException");
        }
        catch (NullPointerException e) {
            this.logSuccessfulCheck(1114531);
        }
        catch (Exception e) {
            return TCKTestResult.failed(1114531, "SleeManagementMBeanProxy.getUsageNotificationManagerMBean() has thrown Exception: " + e.getClass().toString());
        }
        try {
            ObjectName objectName8 = sleeProxy.getUsageNotificationManagerMBean(notrecognizedSubsystem);
            return TCKTestResult.failed(1114532, "SleeManagementMBeanProxy.getUsageNotificationManagerMBean() has not thrown Exception: UnrecognizedSubsystemException");
        }
        catch (UnrecognizedSubsystemException e) {
            this.logSuccessfulCheck(1114532);
        }
        catch (Exception e) {
            return TCKTestResult.failed(1114532, "SleeManagementMBeanProxy.getUsageNotificationManagerMBean() has thrown Exception: " + e.getClass().toString());
        }
        if (!subsystemUsage) {
            try {
                ObjectName objectName9 = sleeProxy.getUsageNotificationManagerMBean(installedSubsystem);
                return TCKTestResult.failed(1114533, "SleeManagementMBeanProxy.getUsageNotificationManagerMBean() has not thrown Exception: InvalidArgumentException");
            }
            catch (InvalidArgumentException e) {
                this.logSuccessfulCheck(1114533);
            }
            catch (Exception e) {
                return TCKTestResult.failed(1114533, "SleeManagementMBeanProxy.getUsageNotificationManagerMBean() has thrown Exception: " + e.getClass().toString());
            }
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        try {
            String duPath = this.utils().getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
            this.utils().getLog().fine("Installing " + duPath);
            this.duID = this.utils().install(duPath);
            this.utils().activateServices(this.duID, true);
            DeploymentMBeanProxy duProxy = this.utils().getDeploymentMBeanProxy();
            SbbID[] sbbs = duProxy.getSbbs();
            this.utils().getLog().fine("Installed SBB: " + sbbs[0]);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            this.getLog().warning("Failed to install deployable unit.");
        }
    }

    public void tearDown() throws Exception {
        this.utils().getLog().fine("Disconnecting from resource");
        this.utils().getResourceInterface().clearActivities();
        this.utils().getLog().fine("Deactivating and uninstalling service");
        this.utils().deactivateAllServices();
        this.utils().uninstallAll();
    }

    private void logSuccessfulCheck(int assertionID) {
        this.utils().getLog().info("Check for assertion " + assertionID + " OK");
    }
}

