/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.javax.slee.management.SbbDescriptor;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import javax.slee.ComponentID;
import javax.slee.SbbID;
import javax.slee.management.ComponentDescriptor;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.SbbDescriptor;

public class Test3932Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private SleeTCKTestUtils utils;
    private DeployableUnitID duID;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        DeploymentMBeanProxy duProxy = this.utils.getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        ComponentDescriptor[] descriptors = duProxy.getDescriptors(components);
        for (int i = 0; i < descriptors.length; ++i) {
            SbbDescriptor sbbDesc;
            if (!(descriptors[i] instanceof SbbDescriptor) || !(sbbDesc = (SbbDescriptor)descriptors[i]).getName().equals("Test3932Test")) continue;
            SbbID[] children = sbbDesc.getSbbs();
            if (children.length != 1) {
                return TCKTestResult.failed(4759, "SbbDescriptor.getSbbs() returned incorrect number of children.");
            }
            try {
                sbbDesc.getEventTypes();
            }
            catch (Exception e) {
                return TCKTestResult.failed(3934, "SbbDescriptor.getEventTypes() threw an exception.");
            }
            try {
                sbbDesc.getProfileSpecifications();
            }
            catch (Exception e) {
                return TCKTestResult.failed(3936, "SbbDescriptor.getProfileSpecifications() threw an exception.");
            }
            try {
                sbbDesc.getResourceAdaptorTypes();
            }
            catch (Exception e) {
                return TCKTestResult.failed(3938, "SbbDescriptor.getResourceAdaptorTypes() threw an exception.");
            }
            return TCKTestResult.passed();
        }
        return TCKTestResult.error("Failed to find the SbbDescriptor for the installed root SBB.");
    }

    public void setUp() throws Exception {
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils.install(duPath);
        this.utils.activateServices(this.duID, true);
    }

    public void tearDown() throws Exception {
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }
}

