/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.javax.slee.management.ProfileProvisioningMBean;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.management.ObjectName;
import javax.slee.ComponentID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.profile.UnrecognizedProfileNameException;
import javax.slee.profile.UnrecognizedProfileTableNameException;

public class Test4551Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 4551;
    private ProfileProvisioningMBeanProxy profileProxy;
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private DeployableUnitID duID;
    private ProfileUtils profileUtils;
    private ObjectName profileObjectName;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        this.result = new FutureResult(this.utils.getLog());
        this.profileProxy = this.profileUtils.getProfileProvisioningProxy();
        DeploymentMBeanProxy duProxy = this.utils.getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof ProfileSpecificationID)) continue;
            ProfileSpecificationID profileSpecID = (ProfileSpecificationID)components[i];
            try {
                this.profileProxy.createProfileTable(profileSpecID, "Test4551ProfileTable");
            }
            catch (Exception e) {
                return TCKTestResult.error("Failed to create profile table.");
            }
            this.profileObjectName = this.profileProxy.createProfile("Test4551ProfileTable", "Test4551Profile");
            this.utils.getLog().fine("Created profile 'Test4551ProfileTable/Test4551Profile'");
            break;
        }
        TCKResourceTestInterface resource = this.utils.getResourceInterface();
        TCKActivityID activityID = resource.createActivity("Test4551InitialActivity");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", activityID, null);
        return this.result.waitForResultOrFail(this.utils.getTestTimeout(), "Timeout waiting for test result.", 4551);
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        this.utils.getLog().fine("Installing and activating service");
        this.profileUtils = new ProfileUtils(this.utils);
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils.install(duPath);
        this.utils.activateServices(this.duID, true);
    }

    public void tearDown() throws Exception {
        if (this.profileProxy != null) {
            try {
                ProfileMBeanProxy profProxy = this.utils.getMBeanProxyFactory().createProfileMBeanProxy(this.profileObjectName);
                profProxy.commitProfile();
                profProxy.closeProfile();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.profileProxy.removeProfile("Test4551ProfileTable", "Test4551Profile");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.profileProxy.removeProfileTable("Test4551ProfileTable");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Test4551Test.this.utils.getLog().info("Received message from SBB");
            HashMap map = (HashMap)message.getMessage();
            Integer stage = (Integer)map.get("Stage");
            boolean passed = (Boolean)map.get("Result");
            String msgString = (String)map.get("Message");
            Test4551Test.this.utils.getLog().info("Stage: " + stage + ", Passed: " + passed + ", Message: " + msgString);
            if (stage == 1) {
                if (!passed) {
                    Test4551Test.this.result.setFailed(4551, msgString);
                    return;
                }
                try {
                    passed = false;
                    try {
                        Test4551Test.this.profileProxy.getProfile("Test4551ProfileTable", "Test4551Profile");
                    }
                    catch (UnrecognizedProfileTableNameException e) {
                        passed = true;
                    }
                    catch (UnrecognizedProfileNameException e) {
                        passed = true;
                    }
                    catch (Exception e) {
                        Test4551Test.this.utils.getLog().fine("Exception thrown in getProfile: " + e);
                    }
                    if (!passed) {
                        Test4551Test.this.utils.getLog().fine("Was incorrectly able to retrieve uncommitted profile via MGMT iface (2356)");
                        Test4551Test.this.result.setFailed(2356, "Profile created via ProfileProvisioningMBean.createProfile(...) was retrievable through ProfileProvisioningMBean.getProfile(...) before it had been committed.");
                        return;
                    }
                    ProfileMBeanProxy profProxy = Test4551Test.this.utils.getMBeanProxyFactory().createProfileMBeanProxy(Test4551Test.this.profileObjectName);
                    profProxy.commitProfile();
                    profProxy.closeProfile();
                    Test4551Test.this.utils.getLog().fine("Committed profile 'Test4551ProfileTable/Test4551Profile'");
                    TCKResourceTestInterface resource = Test4551Test.this.utils.getResourceInterface();
                    TCKActivityID activityID = resource.createActivity("Test4551InitialActivity2");
                    resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2", activityID, null);
                }
                catch (Exception e) {
                    this.onException(e);
                }
                return;
            }
            if (!passed) {
                Test4551Test.this.result.setFailed(4551, msgString);
                return;
            }
            Test4551Test.this.result.setPassed();
        }

        public void onException(Exception e) throws RemoteException {
            Test4551Test.this.utils.getLog().warning("Received exception from SBB");
            Test4551Test.this.utils.getLog().warning(e);
            Test4551Test.this.result.setError(e);
        }
    }
}

