/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.javax.slee.management.AlarmThresholdFilter;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.AlarmMBeanProxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.slee.management.AlarmNotification;
import javax.slee.management.AlarmThresholdFilter;
import javax.slee.management.DeployableUnitID;

public class Test4098Test
implements SleeTCKTest,
NotificationListener {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 4098;
    protected static final int NOTIF_TIMEOUT = 5000;
    private TCKActivityID activityID;
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private DeployableUnitID duID;
    private AlarmThresholdFilter alarmFilter;
    private int notifCount;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        this.result = new FutureResult(this.utils.getLog());
        TCKResourceTestInterface resource = this.utils.getResourceInterface();
        this.activityID = resource.createActivity("Test4098InitialActivity");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", this.activityID, null);
        return this.result.waitForResultOrFail(this.utils.getTestTimeout(), "Timeout waiting for test result.", 4098);
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        this.utils.getLog().fine("Installing and activating service");
        AlarmMBeanProxy alarmMBeanProxy = this.utils.getMBeanProxyFactory().createAlarmMBeanProxy(this.utils.getSleeManagementMBeanProxy().getAlarmMBean());
        this.alarmFilter = new AlarmThresholdFilter(2, 5000L);
        alarmMBeanProxy.addNotificationListener(this, (NotificationFilter)this.alarmFilter, null);
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils.install(duPath);
        this.utils.activateServices(this.duID, true);
    }

    public void tearDown() throws Exception {
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }

    public synchronized void handleNotification(Notification notification, Object handback) {
        if (notification instanceof AlarmNotification) {
            this.utils.getLog().fine("Received AlarmNotification: " + notification.getMessage());
            if (notification.getMessage().equals("2")) {
                if (this.notifCount == 2) {
                    this.result.setPassed();
                } else {
                    this.result.setFailed(4098, "Expected to receive two alarm notifications, but " + this.notifCount + " were received instead.");
                }
                return;
            }
            ++this.notifCount;
            return;
        }
        this.result.setError("Received unexpected notification type.");
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            HashMap map = (HashMap)message.getMessage();
            Boolean res = (Boolean)map.get("Result");
            String msgString = (String)map.get("Message");
            if (res.booleanValue()) {
                Test4098Test.this.result.setPassed();
            } else {
                Test4098Test.this.result.setFailed(4098, msgString);
            }
        }

        public void onException(Exception e) throws RemoteException {
            Test4098Test.this.utils.getLog().warning("Received exception from SBB");
            Test4098Test.this.utils.getLog().warning(e);
            Test4098Test.this.result.setError(e);
        }
    }
}

