/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.javax.slee.facilities.TimerEvent;

import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerID;
import javax.slee.facilities.TimerOptions;

public abstract class Test3507Sbb
extends BaseTCKSbb {
    private static final String JNDI_TIMERFACILITY_NAME = "java:comp/env/slee/facilities/timer";
    private static final long TIMEOUT = 10000L;

    public void onTCKResourceEventX1(TCKResourceEventX ev, ActivityContextInterface aci) {
        try {
            TimerOptions options = new TimerOptions();
            options.setTimeout(10000L);
            TimerFacility facility = (TimerFacility)new InitialContext().lookup(JNDI_TIMERFACILITY_NAME);
            this.setFireTime(System.currentTimeMillis());
            this.setFirstTimer(facility.setTimer(aci, null, this.getFireTime(), options));
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onTimerEvent(TimerEvent event, ActivityContextInterface aci) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (event.getScheduledTime() > this.getFireTime() + 10000L) {
                map.put("Result", new Boolean(false));
                map.put("Type", "Result");
                map.put("ID", new Integer(3509));
                map.put("Message", "TimerEvent.getScheduledTime() returned incorrect value.");
                TCKSbbUtils.getResourceInterface().sendSbbMessage(map);
                return;
            }
            map.put("Type", "TimeDifference");
            map.put("TimeDifference", new Long(System.currentTimeMillis() - event.getExpiryTime()));
            TCKSbbUtils.getResourceInterface().sendSbbMessage(map);
            map = new HashMap();
            map.put("Type", "Result");
            if (event.getPeriod() != Long.MAX_VALUE) {
                map.put("Result", new Boolean(false));
                map.put("Message", "TimerEvent.getPeriod() returned value other than Long.MAX_VALUE for a non-repeating timer.");
                map.put("ID", new Integer(3513));
                TCKSbbUtils.getResourceInterface().sendSbbMessage(map);
                return;
            }
            if (event.getNumRepetitions() != 1) {
                map.put("Result", new Boolean(false));
                map.put("Message", "TimerEvent.getNumRepetitions() returned " + event.getNumRepetitions() + " when 1 was expected.");
                map.put("ID", new Integer(3517));
                TCKSbbUtils.getResourceInterface().sendSbbMessage(map);
                return;
            }
            if (event.getRemainingRepetitions() != 0) {
                map.put("Result", new Boolean(false));
                map.put("Message", "TimerEvent.getRemainingRepetitions() returned " + event.getRemainingRepetitions() + " when 0 was expected.");
                map.put("ID", new Integer(3522));
                TCKSbbUtils.getResourceInterface().sendSbbMessage(map);
                return;
            }
            if (event.getMissedRepetitions() != 0) {
                map.put("Result", new Boolean(false));
                map.put("Message", "TimerEvent.getMissedRepetitions() returned " + event.getMissedRepetitions() + " when 0 was expected.");
                map.put("ID", new Integer(3524));
                TCKSbbUtils.getResourceInterface().sendSbbMessage(map);
                return;
            }
            if (event.getTimerID().equals(this.getFirstTimer())) {
                map.put("Result", new Boolean(true));
                map.put("Message", "Ok");
                TCKSbbUtils.getResourceInterface().sendSbbMessage(map);
                return;
            }
            map.put("Result", new Boolean(false));
            map.put("ID", new Integer(3507));
            map.put("Message", "TimerEvent.getTimerID() did not return a valid TimerID object.");
            TCKSbbUtils.getResourceInterface().sendSbbMessage(map);
            return;
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
            return;
        }
    }

    public abstract void setFirstTimer(TimerID var1);

    public abstract TimerID getFirstTimer();

    public abstract void setFireTime(long var1);

    public abstract long getFireTime();
}

