/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.facilities.tracefacility;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.jmx.SleeManagementMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.TraceMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.impl.TraceMBeanProxyImpl;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.slee.management.TraceNotification;

public final class Test4484Test
extends AbstractSleeTCKTest {
    private ObjectName traceMBeanName;
    private NotificationListener listener;
    private TraceMBeanProxy tracembean;
    private int expectedTraceNotifications;
    private int receivedTraceNotifications;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCKTestResult run() throws Exception {
        TCKActivityID activity = this.utils().getResourceInterface().createActivity("Test4484Activity");
        this.receivedTraceNotifications = 0;
        this.expectedTraceNotifications = 4;
        this.utils().getResourceInterface().fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", null, activity, null);
        this.utils().getResourceInterface().fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", null, activity, null);
        Test4484Test test4484Test = this;
        synchronized (test4484Test) {
            this.wait(this.utils().getTestTimeout());
        }
        Assert.assertTrue(4484, "Expected number of trace messages not received, traces were not delivered by the TraceFacility (expected " + this.expectedTraceNotifications + ", received " + this.receivedTraceNotifications + ")", this.expectedTraceNotifications == this.receivedTraceNotifications);
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        super.setUp();
        SleeManagementMBeanProxy proxy = this.utils().getSleeManagementMBeanProxy();
        this.traceMBeanName = proxy.getTraceMBean();
        this.listener = new TraceNotificationListenerImpl();
        this.tracembean = new TraceMBeanProxyImpl(this.traceMBeanName, this.utils().getMBeanFacade());
        this.tracembean.addNotificationListener(this.listener, null, null);
    }

    public void tearDown() throws Exception {
        if (null != this.tracembean) {
            this.tracembean.removeNotificationListener(this.listener);
        }
        super.tearDown();
    }

    public class TraceNotificationListenerImpl
    implements NotificationListener {
        public final void handleNotification(Notification notification, Object o) {
            if (notification instanceof TraceNotification) {
                TraceNotification n = (TraceNotification)notification;
                Test4484Test.this.getLog().info("Type= " + n.getType());
                if (!"javax.slee.management.trace.raentity".equals(n.getType())) {
                    Test4484Test.this.getLog().info("Got Trace: " + n);
                    Test4484Test.this.receivedTraceNotifications++;
                }
            }
        }
    }
}

