/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.facilities.timerfacility;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.rmi.RemoteException;
import java.util.Map;
import javax.management.ObjectName;
import javax.slee.management.DeployableUnitID;
import javax.slee.profile.ProfileSpecificationID;

public class TimerFacilityTest
extends AbstractSleeTCKTest {
    private static final String PROFILE2_TABLE_NAME = "SetTimerAddressSbb2ProfileTable";
    private static final String PROFILE2_SPEC_NAME = "SetTimerAddressSbb2Profile";
    private static final String PROFILE2_NAME = "sbb2AddressProfile";
    private static final String PROFILE3_TABLE_NAME = "SetTimerAddressSbb3ProfileTable";
    private static final String PROFILE3_SPEC_NAME = "SetTimerAddressSbb3Profile";
    private static final String PROFILE3_NAME = "sbb3AddressProfile";
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private String testName;
    private ProfileProvisioningMBeanProxy profileProvisioningMBean;

    public void run(FutureResult result) throws Exception {
        this.result = result;
        String activityName = "TimerFacilityTest";
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity(activityName);
        this.getLog().info("Firing event: " + this.testName);
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", this.testName, activityID, null);
        if (this.testName.equals("cancelTimer") || this.testName.startsWith("TimerPreserveMissed")) {
            Thread.sleep(10000L);
            resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y1", this.testName, activityID, null);
        }
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.setResourceListener(this.resourceListener);
        this.testName = this.utils().getTestParams().getProperty("testName");
        ProfileUtils profileUtils = new ProfileUtils(this.utils());
        if (this.testName.equals("setTimerRefCount1") || this.testName.equals("setTimerRefCount2")) {
            String eventDUPath = this.utils().getTestParams().getProperty("eventDUPath");
            this.utils().install(eventDUPath);
        } else if (this.testName.equals("setTimerAddress-single") || this.testName.equals("setTimerAddress-periodic")) {
            String service2DUPath = this.utils().getTestParams().getProperty("service2DUPath");
            DeployableUnitID du2ID = this.utils().install(service2DUPath);
            String service3DUPath = this.utils().getTestParams().getProperty("service3DUPath");
            DeployableUnitID du3ID = this.utils().install(service3DUPath);
            this.profileProvisioningMBean = profileUtils.getProfileProvisioningProxy();
            ProfileSpecificationID profileSpecID = new ComponentIDLookup(this.utils()).lookupProfileSpecificationID(PROFILE2_SPEC_NAME, "jain.slee.tck", "1.0");
            this.getLog().info("creating profile table SetTimerAddressSbb2ProfileTable");
            this.profileProvisioningMBean.createProfileTable(profileSpecID, PROFILE2_TABLE_NAME);
            this.getLog().info("creating profile SetTimerAddressSbb2ProfileTable/sbb2AddressProfile");
            ObjectName profile = this.profileProvisioningMBean.createProfile(PROFILE2_TABLE_NAME, PROFILE2_NAME);
            ProfileMBeanProxy profProxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
            profProxy.commitProfile();
            profileSpecID = new ComponentIDLookup(this.utils()).lookupProfileSpecificationID(PROFILE3_SPEC_NAME, "jain.slee.tck", "1.0");
            this.getLog().info("creating profile table SetTimerAddressSbb3ProfileTable");
            this.profileProvisioningMBean.createProfileTable(profileSpecID, PROFILE3_TABLE_NAME);
            this.getLog().info("creating profile SetTimerAddressSbb3ProfileTable/sbb3AddressProfile");
            profile = this.profileProvisioningMBean.createProfile(PROFILE3_TABLE_NAME, PROFILE3_NAME);
            profProxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
            profProxy.commitProfile();
            this.utils().activateServices(du2ID, true);
            this.utils().activateServices(du3ID, true);
        }
        this.setupService("serviceDUPath", true);
    }

    public void tearDown() throws Exception {
        try {
            if ((this.testName.equals("setTimerAddress-single") || this.testName.equals("setTimerAddress-periodic")) && this.profileProvisioningMBean != null) {
                this.getLog().info("removing profile SetTimerAddressSbb2ProfileTable/sbb2AddressProfile");
                this.profileProvisioningMBean.removeProfile(PROFILE2_TABLE_NAME, PROFILE2_NAME);
                this.getLog().info("removing profile table SetTimerAddressSbb2ProfileTable");
                this.profileProvisioningMBean.removeProfileTable(PROFILE2_TABLE_NAME);
                this.getLog().info("removing profile SetTimerAddressSbb3ProfileTable/sbb3AddressProfile");
                this.profileProvisioningMBean.removeProfile(PROFILE3_TABLE_NAME, PROFILE3_NAME);
                this.getLog().info("removing profile table SetTimerAddressSbb3ProfileTable");
                this.profileProvisioningMBean.removeProfileTable(PROFILE3_TABLE_NAME);
            }
        }
        catch (Exception e) {
            this.getLog().error("Exception occurred while trying to remove profile tables.");
            this.getLog().error(e);
        }
        super.tearDown();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Map sbbData = (Map)message.getMessage();
            String sbbTestName = (String)sbbData.get("testname");
            String sbbTestResult = (String)sbbData.get("result");
            String sbbTestMessage = (String)sbbData.get("message");
            int assertionID = (Integer)sbbData.get("id");
            TimerFacilityTest.this.getLog().info("Received message from SBB: testname=" + sbbTestName + ", result=" + sbbTestResult + ", message=" + sbbTestMessage + ", id=" + assertionID);
            try {
                if (sbbTestName.equals(TimerFacilityTest.this.testName)) {
                    Assert.assertEquals(assertionID, "Test " + TimerFacilityTest.this.testName + " failed.", "pass", sbbTestResult);
                    TimerFacilityTest.this.result.setPassed();
                } else {
                    TimerFacilityTest.this.result.setError("Invalid response sent by SBB: " + sbbTestName);
                }
            }
            catch (TCKTestFailureException ex) {
                TimerFacilityTest.this.result.setFailed(ex);
            }
        }

        public void onException(Exception exception) throws RemoteException {
            TimerFacilityTest.this.getLog().warning("Received Exception from SBB or resource:");
            TimerFacilityTest.this.getLog().warning(exception);
            TimerFacilityTest.this.result.setError(exception);
        }
    }
}

