/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.facilities.timerfacility;

import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.Tracer;

public abstract class Test1113003Sbb
extends BaseTCKSbb {
    private Tracer tracer;

    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci) {
        try {
            this.tracer = this.getSbbContext().getTracer("com.test");
            this.tracer.info("Sbb: Received a TCK event " + event);
            this.doJNDITest();
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    private void sendResultToTCK(String testName, boolean result, int failedAssertionID, String message) throws Exception {
        HashMap<String, Object> sbbData = new HashMap<String, Object>();
        sbbData.put("testname", testName);
        sbbData.put("result", result ? "pass" : "fail");
        sbbData.put("message", message);
        sbbData.put("id", new Integer(failedAssertionID));
        TCKSbbUtils.getResourceInterface().sendSbbMessage(sbbData);
    }

    private void doJNDITest() throws Exception {
        TimerFacility tf = this.getTimerFacility();
        if (tf == null) {
            this.sendResultToTCK("Test1113003Test", false, 1113003, "Could not find TimerFacility object in JNDI at java:comp/env/slee/facilities/timer");
            return;
        }
        this.tracer.info("got expected TimerFacility object in JNDI at java:comp/env/slee/facilities/timer", null);
        String JNDI_ACNF_NAME = "java:comp/env/slee/facilities/timer";
        if (JNDI_ACNF_NAME != "java:comp/env/slee/facilities/timer") {
            this.sendResultToTCK("Test1113003Test", false, 1113094, "The value of this JNDI_NAME is not equal to java:comp/env/slee/facilities/timer");
            return;
        }
        this.tracer.info("got expected value of this TimerFacility.JNDI_NAME", null);
        this.sendResultToTCK("Test1113003Test", true, 1113003, "TimerFacility.JNDI_NAME tests passed");
    }

    private TimerFacility getTimerFacility() throws Exception {
        TimerFacility tf = null;
        String JNDI_TIMERFACILITY_NAME = "java:comp/env/slee/facilities/timer";
        try {
            tf = (TimerFacility)new InitialContext().lookup(JNDI_TIMERFACILITY_NAME);
        }
        catch (Exception e) {
            this.tracer.warning("got unexpected Exception: " + e, null);
        }
        return tf;
    }
}

