/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.facilities.servicelookupfacility;

import com.opencloud.logging.StdErrLog;
import com.opencloud.sleetck.lib.profileutils.BaseMessageSender;
import com.opencloud.sleetck.lib.rautils.MessageHandler;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.rautils.TCKRAUtils;
import com.opencloud.sleetck.lib.testsuite.facilities.servicelookupfacility.Test1113671ResourceAdaptor;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import javax.naming.NamingException;
import javax.slee.EventTypeID;
import javax.slee.ServiceID;
import javax.slee.facilities.ServiceLookupFacility;
import javax.slee.resource.ReceivableService;

public class Test1113671MessageListener
extends UnicastRemoteObject
implements MessageHandler {
    public static final int CHECK_IGNORE_RA_TYPE_EVENT_TYPE_FALSE = 1;
    public static final int CHECK_IGNORE_RA_TYPE_EVENT_TYPE_TRUE = 2;
    private BaseMessageSender msgSender;
    private RMIObjectChannel out;
    private Test1113671ResourceAdaptor ra;

    public Test1113671MessageListener(Test1113671ResourceAdaptor ra) throws RemoteException {
        try {
            this.out = TCKRAUtils.lookupRMIObjectChannel();
            this.msgSender = new BaseMessageSender(this.out, new StdErrLog());
        }
        catch (Exception e) {
            ra.getLog().warning("Exception occurred when trying to acquire RMIObjectChannel: ", e);
        }
        this.ra = ra;
    }

    public boolean handleMessage(Object message) throws RemoteException {
        int type = (Integer)((HashMap)message).get("Type");
        switch (type) {
            case 1: {
                if (!this.test_GetService() || !this.test_GetReceivableEvents() || !this.test_Equals() || !this.test_GetEventType()) break;
                this.msgSender.sendSuccess(1113671, "Test successful.");
                break;
            }
            case 2: {
                if (!this.test_INGORE_RA_TYPE_EVENT_TYPE_CHECK()) break;
                this.msgSender.sendSuccess(1113676, "Test successful.");
            }
        }
        return true;
    }

    private boolean test_GetService() {
        try {
            ServiceID simpleServiceID = new ServiceID("Test1113671Service1", "jain.slee.tck", "1.1");
            ReceivableService rs = this.getReceivableService(simpleServiceID);
            try {
                ServiceID serviceID = rs.getService();
                if (serviceID == null || !serviceID.equals((Object)simpleServiceID)) {
                    this.msgSender.sendFailure(1113671, "Invalid ServiceID returned from ReceivableService.getService()");
                    return false;
                }
                this.msgSender.sendLogMsg("getService() returned expected ServiceID");
            }
            catch (Exception e) {
                this.msgSender.sendFailure(1113671, "Invalid ServiceID returned from ReceivableService.getService()", e);
                return false;
            }
        }
        catch (Exception e) {
            this.msgSender.sendException(e);
            return false;
        }
        return true;
    }

    private boolean test_GetReceivableEvents() {
        try {
            ReceivableService.ReceivableEvent[] rEvent;
            ServiceID simpleServiceID = new ServiceID("Test1113671Service1", "jain.slee.tck", "1.1");
            ReceivableService rs = this.getReceivableService(simpleServiceID);
            try {
                rEvent = rs.getReceivableEvents();
                if (rEvent == null || rEvent.length == 0) {
                    this.msgSender.sendFailure(1113672, "Invalid ReceivableService.ReceivableEvent[] returned from ReceivableService.getReceivableService()");
                    return false;
                }
                this.msgSender.sendLogMsg("getReceivableService() returned expected ReceivableService.ReceivableEvent[]");
            }
            catch (Exception e) {
                this.msgSender.sendFailure(1113672, "Invalid ReceivableService.ReceivableEvent[] returned from ReceivableService.getReceivableService()", e);
                return false;
            }
            try {
                rEvent = rs.getReceivableEvents();
                EventTypeID simpleEventType = new EventTypeID("com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent", "jain.slee.tck", "1.1");
                if (!rEvent[0].getEventType().equals((Object)simpleEventType) || rEvent.length < 1) {
                    this.msgSender.sendFailure(1113673, "Each ReceivableEvent object didn't identity an event type that one or more SBBs in the Service has an event handler method for.");
                    return false;
                }
                this.msgSender.sendLogMsg("Each ReceivableEvent object identities an event type that one or more SBBs in the Service has an event handler method for.");
            }
            catch (Exception e) {
                this.msgSender.sendFailure(1113673, "Each ReceivableEvent object didn't identity an event type that one or more SBBs in the Service has an event handler method for.", e);
                return false;
            }
        }
        catch (Exception e) {
            this.msgSender.sendException(e);
            return false;
        }
        return true;
    }

    private boolean test_Equals() {
        try {
            ServiceID simpleServiceID1 = new ServiceID("Test1113671Service1", "jain.slee.tck", "1.1");
            ServiceID simpleServiceID2 = new ServiceID("Test1113671Service1", "jain.slee.tck", "1.1");
            ReceivableService rs1 = this.getReceivableService(simpleServiceID1);
            ReceivableService rs2 = this.getReceivableService(simpleServiceID2);
            try {
                if (rs1 == null || rs2 == null || !rs1.equals(rs1) || !rs2.equals(rs2)) {
                    this.msgSender.sendFailure(1113678, "ServiceID didn't eqaul to itself");
                    return false;
                }
                this.msgSender.sendLogMsg("ServiceID is eqaul to itself");
            }
            catch (Exception e) {
                this.msgSender.sendFailure(1113678, "ServiceID didn't eqaul to itself", e);
                return false;
            }
            try {
                ServiceID serviceID1 = rs1.getService();
                ServiceID serviceID2 = rs2.getService();
                if (!serviceID1.equals((Object)serviceID2) || !rs1.equals(rs2)) {
                    this.msgSender.sendFailure(1113679, "Two ReceivableService objects didn't equal if the Service component identifiers returned by their respective getService methods are equal.");
                    return false;
                }
                this.msgSender.sendLogMsg("Two ReceivableService objects must be considered equals if the Service component identifiers returned by their respective getService methods are equal.");
            }
            catch (Exception e) {
                this.msgSender.sendFailure(1113679, "Two ReceivableService objects didn't equal if the Service component identifiers returned by their respective getService methods are equal.", e);
                return false;
            }
        }
        catch (Exception e) {
            this.msgSender.sendException(e);
            return false;
        }
        return true;
    }

    private boolean test_GetEventType() {
        try {
            ReceivableService.ReceivableEvent[] rEvent;
            ServiceID simpleServiceID = new ServiceID("Test1113671Service1", "jain.slee.tck", "1.1");
            ReceivableService rs = this.getReceivableService(simpleServiceID);
            try {
                rEvent = rs.getReceivableEvents();
                EventTypeID simpleEventType = new EventTypeID("com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent", "jain.slee.tck", "1.1");
                if (!rEvent[0].getEventType().equals((Object)simpleEventType) || rEvent.length < 1) {
                    this.msgSender.sendFailure(1113683, "Invalid EventTypeID returned from ReceivableService.ReceivableEvent.getEventType()");
                    return false;
                }
                this.msgSender.sendLogMsg("getEventType() returned expected EventTypeID");
            }
            catch (Exception e) {
                this.msgSender.sendFailure(1113683, "Invalid EventTypeID returned from ReceivableService.ReceivableEvent.getEventType()", e);
                return false;
            }
            try {
                rEvent = rs.getReceivableEvents();
                if (rEvent[0].getResourceOption() != null) {
                    this.msgSender.sendFailure(1113684, "No null returned from ReceivableService.ReceivableEvent.getResourceOption()");
                    return false;
                }
                this.msgSender.sendLogMsg("getResourceOption() returned expected null");
            }
            catch (Exception e) {
                this.msgSender.sendFailure(1113684, "No null returned from ReceivableService.ReceivableEvent.getResourceOption()", e);
                return false;
            }
            try {
                rEvent = rs.getReceivableEvents();
                if (!rEvent[0].isInitialEvent()) {
                    this.msgSender.sendFailure(1113685, "The false value returned from ReceivableService.ReceivableEvent.isInitialEvent()");
                    return false;
                }
                this.msgSender.sendLogMsg("isInitialEvent() returned expected true");
            }
            catch (Exception e) {
                this.msgSender.sendFailure(1113685, "The false value returned from ReceivableService.ReceivableEvent.isInitialEvent()", e);
                return false;
            }
        }
        catch (Exception e) {
            this.msgSender.sendException(e);
            return false;
        }
        return true;
    }

    private boolean test_INGORE_RA_TYPE_EVENT_TYPE_CHECK() {
        try {
            ServiceID simpleServiceID = new ServiceID("Test1113671Service2", "jain.slee.tck", "1.1");
            ReceivableService rs = this.getReceivableService(simpleServiceID);
            try {
                boolean passed;
                ReceivableService.ReceivableEvent[] rEvent = rs.getReceivableEvents();
                String serviceStartedEvent = "javax.slee.serviceactivity.ServiceStartedEvent";
                EventTypeID serviceStartedEventType = new EventTypeID(serviceStartedEvent, "javax.slee", "1.1");
                EventTypeID Test1113671EventType = new EventTypeID("com.opencloud.sleetck.lib.testsuite.facilities.servicelookupfacility.Test1113671Event", "jain.slee.tck", "1.1");
                ArrayList<EventTypeID> eventTypes = new ArrayList<EventTypeID>();
                for (int i = 0; i < rEvent.length; ++i) {
                    eventTypes.add(rEvent[i].getEventType());
                }
                boolean bl = passed = eventTypes.size() == 2 && eventTypes.contains(serviceStartedEventType) && eventTypes.contains(Test1113671EventType);
                if (!passed) {
                    this.msgSender.sendFailure(1113676, "There should be two copies of EventTypeID returned from ReceivableService.ReceivableEvent.getEventType()");
                    return false;
                }
                this.msgSender.sendLogMsg("getEventType() returned expected EventTypeID");
            }
            catch (Exception e) {
                this.msgSender.sendFailure(1113676, "There should be two copies of EventTypeID returned from ReceivableService.ReceivableEvent.getEventType()", e);
                return false;
            }
        }
        catch (Exception e) {
            this.msgSender.sendException(e);
            return false;
        }
        return true;
    }

    private ReceivableService getReceivableService(ServiceID serviceID) throws NamingException {
        ReceivableService rs;
        ServiceLookupFacility eventLookup = this.getServiceLookupFacility();
        try {
            rs = eventLookup.getReceivableService(serviceID);
        }
        catch (Exception e) {
            this.ra.getLog().warning("getReceivableService throw a UnrecognizedServiceException: " + e);
            rs = null;
        }
        return rs;
    }

    private ServiceLookupFacility getServiceLookupFacility() throws NamingException {
        return this.ra.getResourceAdaptorContext().getServiceLookupFacility();
    }
}

