/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.facilities.alarmfacility;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.AlarmMBeanProxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.slee.management.AlarmNotification;
import javax.slee.management.DeployableUnitID;

public class Test4465Test
implements SleeTCKTest,
NotificationListener {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 4465;
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private DeployableUnitID duID;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        this.result = new FutureResult(this.utils.getLog());
        TCKResourceTestInterface resource = this.utils.getResourceInterface();
        TCKActivityID activityID = resource.createActivity("Test4465InitialActivity");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", activityID, null);
        return this.result.waitForResultOrFail(this.utils.getTestTimeout(), "Timeout waiting for test result.", 4465);
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        this.utils.getLog().fine("Installing and activating service");
        AlarmMBeanProxy alarmMBeanProxy = this.utils.getMBeanProxyFactory().createAlarmMBeanProxy(this.utils.getSleeManagementMBeanProxy().getAlarmMBean());
        alarmMBeanProxy.addNotificationListener(this, null, null);
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils.install(duPath);
        this.utils.activateServices(this.duID, true);
    }

    public void tearDown() throws Exception {
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }

    public synchronized void handleNotification(Notification notification, Object handback) {
        if (notification instanceof AlarmNotification) {
            AlarmNotification alarmNotification = (AlarmNotification)notification;
            if (alarmNotification.getMessage().equals("Test4465AlarmMessage")) {
                this.result.setPassed();
            } else {
                this.result.setFailed(4465, "Message in AlarmNotification was not that set in AlarmFacility.createAlarm()");
            }
            return;
        }
        this.utils.getLog().info("Notification received: " + notification);
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            HashMap map = (HashMap)message.getMessage();
            Boolean passed = (Boolean)map.get("Result");
            String msgString = (String)map.get("Message");
            Test4465Test.this.utils.getLog().info("Received message from SBB.");
            if (passed.booleanValue()) {
                Test4465Test.this.result.setPassed();
            } else {
                Test4465Test.this.result.setFailed(4465, msgString);
            }
        }

        public void onException(Exception e) throws RemoteException {
            Test4465Test.this.utils.getLog().warning("Received exception from SBB");
            Test4465Test.this.utils.getLog().warning(e);
            Test4465Test.this.result.setError(e);
        }
    }
}

