/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.facilities.alarmfacility;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.AlarmMBeanProxy;
import java.rmi.RemoteException;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.slee.facilities.AlarmLevel;
import javax.slee.management.AlarmNotification;

public class Test1113514Test
extends AbstractSleeTCKTest {
    public static final String SERVICE1_DU_PATH_PARAM = "service1DUPath";
    public static final String SERVICE2_DU_PATH_PARAM = "service2DUPath";
    private TCKResourceListener resourceListener;
    private NotificationListener listener;
    private AlarmMBeanProxy alarmMBeanProxy;
    private FutureResult result;
    private int receivedAlarmNotifications;
    private int expectedAlarmNotifications;
    private String testName = "Test1113514";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(FutureResult result) throws Exception {
        this.result = result;
        this.expectedAlarmNotifications = 30;
        this.receivedAlarmNotifications = 0;
        String activityName = "Test1113514Test";
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity(activityName);
        this.getLog().info("Firing event: com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", this.testName, activityID, null);
        this.getLog().info("Firing event: com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y1");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y1", this.testName, activityID, null);
        Test1113514Test test1113514Test = this;
        synchronized (test1113514Test) {
            this.wait(this.utils().getTestTimeout());
        }
        if (this.expectedAlarmNotifications == this.receivedAlarmNotifications) {
            result.setPassed();
        } else {
            result.setFailed(1113514, "Expected number of alarm messages not received, alarms were not delivered by the AlarmFacility (expected " + this.expectedAlarmNotifications + ", received " + this.receivedAlarmNotifications + ")");
        }
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.setResourceListener(this.resourceListener);
        this.getLog().fine("Installing and activating service");
        this.setupService(SERVICE1_DU_PATH_PARAM, true);
        this.setupService(SERVICE2_DU_PATH_PARAM, true);
        this.alarmMBeanProxy = this.utils().getAlarmMBeanProxy();
        this.listener = new AlarmNotificationListenerImpl();
        this.alarmMBeanProxy.addNotificationListener(this.listener, null, null);
    }

    public void tearDown() throws Exception {
        String[] listActiveAlarms = this.alarmMBeanProxy.getAlarms();
        if (this.alarmMBeanProxy.getAlarms().length > 0) {
            for (int i = 0; i < listActiveAlarms.length; ++i) {
                this.alarmMBeanProxy.clearAlarm(listActiveAlarms[i]);
            }
        }
        if (null != this.alarmMBeanProxy) {
            this.alarmMBeanProxy.removeNotificationListener(this.listener);
        }
        super.tearDown();
    }

    public class AlarmNotificationListenerImpl
    implements NotificationListener {
        public final void handleNotification(Notification notification, Object handback) {
            if (notification instanceof AlarmNotification) {
                AlarmNotification alarmNotification = (AlarmNotification)notification;
                Test1113514Test.this.getLog().debug("Received " + alarmNotification);
                if (alarmNotification.getAlarmLevel().equals((Object)AlarmLevel.CLEAR)) {
                    if (alarmNotification.getMessage().equals("Sbb1:CRITICAL:Test1113514AlarmMessage")) {
                        Test1113514Test.this.receivedAlarmNotifications = Test1113514Test.this.receivedAlarmNotifications + 1;
                    } else if (alarmNotification.getMessage().equals("Sbb2:CRITICAL:Test111514AlarmMessage")) {
                        Test1113514Test.this.receivedAlarmNotifications = Test1113514Test.this.receivedAlarmNotifications + 1;
                    } else if (alarmNotification.getMessage().equals("Sbb1:MAJOR:Test1113514AlarmMessage")) {
                        Test1113514Test.this.receivedAlarmNotifications = Test1113514Test.this.receivedAlarmNotifications + 2;
                    } else if (alarmNotification.getMessage().equals("Sbb2:MAJOR:Test111514AlarmMessage")) {
                        Test1113514Test.this.receivedAlarmNotifications = Test1113514Test.this.receivedAlarmNotifications + 2;
                    } else if (alarmNotification.getMessage().equals("Sbb1:WARNING:Test1113514AlarmMessage")) {
                        Test1113514Test.this.receivedAlarmNotifications = Test1113514Test.this.receivedAlarmNotifications + 3;
                    } else if (alarmNotification.getMessage().equals("Sbb2:WARNING:Test111514AlarmMessage")) {
                        Test1113514Test.this.receivedAlarmNotifications = Test1113514Test.this.receivedAlarmNotifications + 3;
                    } else if (alarmNotification.getMessage().equals("Sbb1:INDETERMINATE:Test1113514AlarmMessage")) {
                        Test1113514Test.this.receivedAlarmNotifications = Test1113514Test.this.receivedAlarmNotifications + 4;
                    } else if (alarmNotification.getMessage().equals("Sbb2:INDETERMINATE:Test111514AlarmMessage")) {
                        Test1113514Test.this.receivedAlarmNotifications = Test1113514Test.this.receivedAlarmNotifications + 4;
                    } else if (alarmNotification.getMessage().equals("Sbb1:MINOR:Test1113514AlarmMessage")) {
                        Test1113514Test.this.receivedAlarmNotifications = Test1113514Test.this.receivedAlarmNotifications + 5;
                    } else if (alarmNotification.getMessage().equals("Sbb2:MINOR:Test111514AlarmMessage")) {
                        Test1113514Test.this.receivedAlarmNotifications = Test1113514Test.this.receivedAlarmNotifications + 5;
                    }
                }
            }
        }
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Map sbbData = (Map)message.getMessage();
            String sbbTestName = "Test1113514Test";
            String sbbTestResult = (String)sbbData.get("result");
            String sbbTestMessage = (String)sbbData.get("message");
            int assertionID = (Integer)sbbData.get("id");
            Test1113514Test.this.getLog().info("Received message from SBB: testname=" + sbbTestName + ", result=" + sbbTestResult + ", message=" + sbbTestMessage + ", id=" + assertionID);
            try {
                Assert.assertEquals(assertionID, "Test " + sbbTestName + " failed.", "pass", sbbTestResult);
                Test1113514Test.this.result.setPassed();
            }
            catch (TCKTestFailureException ex) {
                Test1113514Test.this.result.setFailed(assertionID, sbbTestMessage);
            }
        }

        public void onException(Exception exception) throws RemoteException {
            Test1113514Test.this.getLog().warning("Received Exception from SBB or resource:");
            Test1113514Test.this.getLog().warning(exception);
            Test1113514Test.this.result.setError(exception);
        }
    }
}

