/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.facilities.alarmfacility;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.AlarmMBeanProxy;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.slee.facilities.AlarmLevel;
import javax.slee.management.AlarmNotification;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.NotificationSource;
import javax.slee.management.SbbNotification;

public class Test1113507Test
extends AbstractSleeTCKTest {
    private NotificationListener listener;
    private DeployableUnitID duID;
    private AlarmMBeanProxy alarmMBeanProxy;
    private FutureResult result;
    private int receivedAlarmNotifications;
    private int expectedAlarmNotifications;
    private String testName = "Test1113507";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(FutureResult result) throws Exception {
        this.result = result;
        this.expectedAlarmNotifications = 15;
        this.receivedAlarmNotifications = 0;
        String activityName = "Test1113507Test";
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity(activityName);
        this.getLog().info("Firing event: com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", this.testName, activityID, null);
        Test1113507Test test1113507Test = this;
        synchronized (test1113507Test) {
            this.wait(this.utils().getTestTimeout());
        }
        if (this.expectedAlarmNotifications == this.receivedAlarmNotifications) {
            result.setPassed();
        } else {
            result.setFailed(1113507, "Expected number of alarm messages not received, alarms were not delivered by the AlarmFacility (expected " + this.expectedAlarmNotifications + ", received " + this.receivedAlarmNotifications + ")");
        }
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to resource");
        this.getLog().fine("Installing and activating service");
        String duPath = this.utils().getTestParams().getProperty("serviceDUPath");
        this.duID = this.utils().install(duPath);
        this.utils().activateServices(this.duID, true);
        this.alarmMBeanProxy = this.utils().getAlarmMBeanProxy();
        this.listener = new AlarmNotificationListenerImpl();
        this.alarmMBeanProxy.addNotificationListener(this.listener, null, null);
    }

    public void tearDown() throws Exception {
        String[] listActiveAlarms = this.alarmMBeanProxy.getAlarms();
        if (this.alarmMBeanProxy.getAlarms().length > 0) {
            for (int i = 0; i < listActiveAlarms.length; ++i) {
                this.alarmMBeanProxy.clearAlarm(listActiveAlarms[i]);
            }
        }
        if (null != this.alarmMBeanProxy) {
            this.alarmMBeanProxy.removeNotificationListener(this.listener);
        }
        super.tearDown();
    }

    public class AlarmNotificationListenerImpl
    implements NotificationListener {
        public final void handleNotification(Notification notification, Object handback) {
            if (notification instanceof AlarmNotification) {
                AlarmNotification alarmNotification = (AlarmNotification)notification;
                Test1113507Test.this.getLog().info("Received " + alarmNotification);
                if (alarmNotification.getAlarmLevel().equals((Object)AlarmLevel.CLEAR)) {
                    String clearedAlarmType = alarmNotification.getAlarmType();
                    SbbNotification sbbNotification = (SbbNotification)alarmNotification.getNotificationSource();
                    try {
                        if (Test1113507Test.this.alarmMBeanProxy.clearAlarms((NotificationSource)sbbNotification, clearedAlarmType) >= 1) {
                            Test1113507Test.this.result.setFailed(1113509, "Some active alarms in the SLEE were cleared, butthere should not be any active alarms in the SLEE.");
                            return;
                        }
                    }
                    catch (Exception e) {
                        Test1113507Test.this.getLog().warning("Received Exception from SBB or resource:");
                        Test1113507Test.this.getLog().warning(e);
                        Test1113507Test.this.result.setError(e);
                    }
                }
                if (alarmNotification.getAlarmLevel().equals((Object)AlarmLevel.CLEAR)) {
                    if (alarmNotification.getMessage().equals("CRITICAL:Test1113484AlarmMessage")) {
                        Test1113507Test.this.receivedAlarmNotifications = Test1113507Test.this.receivedAlarmNotifications + 1;
                    } else if (alarmNotification.getMessage().equals("MAJOR:Test1113484AlarmMessage")) {
                        Test1113507Test.this.receivedAlarmNotifications = Test1113507Test.this.receivedAlarmNotifications + 2;
                    } else if (alarmNotification.getMessage().equals("WARNING:Test1113484AlarmMessage")) {
                        Test1113507Test.this.receivedAlarmNotifications = Test1113507Test.this.receivedAlarmNotifications + 3;
                    } else if (alarmNotification.getMessage().equals("INDETERMINATE:Test1113484AlarmMessage")) {
                        Test1113507Test.this.receivedAlarmNotifications = Test1113507Test.this.receivedAlarmNotifications + 4;
                    } else if (alarmNotification.getMessage().equals("MINOR:Test1113484AlarmMessage")) {
                        Test1113507Test.this.receivedAlarmNotifications = Test1113507Test.this.receivedAlarmNotifications + 5;
                    }
                }
            }
            Test1113507Test.this.getLog().info("Notification received: " + notification);
        }
    }
}

