/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.facilities.alarmfacility;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.AlarmMBeanProxy;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.slee.facilities.AlarmLevel;
import javax.slee.management.AlarmNotification;
import javax.slee.management.DeployableUnitID;

public class Test1113498Test
extends AbstractSleeTCKTest {
    private NotificationListener listener;
    private DeployableUnitID duID;
    private AlarmMBeanProxy alarmMBeanProxy;
    private FutureResult result;
    private String testName = "Test113498";

    public void run(FutureResult result) throws Exception {
        this.result = result;
        String activityName = "Test1113498Test";
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity(activityName);
        this.getLog().info("Firing event: com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", this.testName, activityID, null);
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to resource");
        this.getLog().fine("Installing and activating service");
        String duPath = this.utils().getTestParams().getProperty("serviceDUPath");
        this.duID = this.utils().install(duPath);
        this.utils().activateServices(this.duID, true);
        this.alarmMBeanProxy = this.utils().getAlarmMBeanProxy();
        this.listener = new AlarmNotificationListenerImpl();
        this.alarmMBeanProxy.addNotificationListener(this.listener, null, null);
    }

    public void tearDown() throws Exception {
        String[] listActiveAlarms = this.alarmMBeanProxy.getAlarms();
        if (this.alarmMBeanProxy.getAlarms().length > 0) {
            for (int i = 0; i < listActiveAlarms.length; ++i) {
                this.alarmMBeanProxy.clearAlarm(listActiveAlarms[i]);
            }
        }
        if (null != this.alarmMBeanProxy) {
            this.alarmMBeanProxy.removeNotificationListener(this.listener);
        }
        super.tearDown();
    }

    public class AlarmNotificationListenerImpl
    implements NotificationListener {
        public final void handleNotification(Notification notification, Object handback) {
            if (notification instanceof AlarmNotification) {
                AlarmNotification alarmNotification = (AlarmNotification)notification;
                if (alarmNotification.getAlarmLevel().equals((Object)AlarmLevel.MAJOR)) {
                    Test1113498Test.this.getLog().info("Received the raised alarm " + alarmNotification + " with " + alarmNotification.getAlarmLevel());
                } else if (alarmNotification.getAlarmLevel().equals((Object)AlarmLevel.CLEAR)) {
                    Test1113498Test.this.getLog().info("Received the cleared alarm " + alarmNotification + " with " + alarmNotification.getAlarmLevel());
                    String clearedAlarmID = alarmNotification.getAlarmID();
                    try {
                        if (Test1113498Test.this.alarmMBeanProxy.isActive(clearedAlarmID)) {
                            Test1113498Test.this.result.setFailed(1113500, "The cleared alarmID is still currently active in the SLEE.");
                            return;
                        }
                    }
                    catch (Exception e) {
                        Test1113498Test.this.getLog().warning("Received Exception from SBB or resource:");
                        Test1113498Test.this.getLog().warning(e);
                        Test1113498Test.this.result.setError(e);
                    }
                    Test1113498Test.this.result.setPassed();
                } else {
                    Test1113498Test.this.result.setFailed(1113498, "AlarmNotification.getAlarmLevel() didn't return the level of alarm being created in sbb or service.");
                }
                return;
            }
            Test1113498Test.this.getLog().info("Notification received: " + notification);
        }
    }
}

