/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.facilities.alarmfacility;

import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.facilities.AlarmFacility;
import javax.slee.facilities.AlarmLevel;
import javax.slee.facilities.Tracer;

public abstract class Test1113498Sbb
extends BaseTCKSbb {
    public static final String ALARM_MESSAGE = "Test1113498AlarmMessage";
    public static final String ALARM_INSTANCEID = "Test1113498AlarmInstanceID";
    public static final String ALARM_TYPE = "javax.slee.management.Alarm";
    public static final AlarmLevel ALARM_LEVEL = AlarmLevel.MAJOR;
    private Tracer tracer;

    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci) {
        try {
            this.tracer = this.getSbbContext().getTracer("com.test");
            this.tracer.info("Received " + event + " message", null);
            this.doTest1113501Test();
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    private void doTest1113501Test() throws Exception {
        this.tracer.info("Testing Assertion Number 1113501...");
        AlarmFacility facility = this.getAlarmFacility();
        boolean passed = false;
        try {
            facility.clearAlarm(null);
        }
        catch (NullPointerException e) {
            this.tracer.info("got expected NullPointerException when ALARM_ID is null", null);
            passed = true;
        }
        if (!passed) {
            this.sendResultToTCK("Test1113501Test", false, 1113501, "AlarmFacility.clearAlarm(null) should have thrown java.lang.NullPointerException.");
            return;
        }
        this.tracer.info("Testing Assertion Number 1113498...");
        try {
            this.setFirstAlarm(facility.raiseAlarm(ALARM_TYPE, ALARM_INSTANCEID, ALARM_LEVEL, ALARM_MESSAGE));
            if (!facility.clearAlarm(this.getFirstAlarm())) {
                this.sendResultToTCK("Test1113501Test", false, 1113498, "The alarm which has been raised cannot be cleared!");
                return;
            }
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    private void sendResultToTCK(String testName, boolean result, int failedAssertionID, String message) throws Exception {
        HashMap<String, Object> sbbData = new HashMap<String, Object>();
        sbbData.put("testname", testName);
        sbbData.put("result", result ? "pass" : "fail");
        sbbData.put("message", message);
        sbbData.put("id", new Integer(failedAssertionID));
        TCKSbbUtils.getResourceInterface().sendSbbMessage(sbbData);
    }

    private AlarmFacility getAlarmFacility() throws Exception {
        AlarmFacility facility = null;
        String JNDI_ALARMFACILITY_NAME = "java:comp/env/slee/facilities/alarm";
        try {
            facility = (AlarmFacility)new InitialContext().lookup(JNDI_ALARMFACILITY_NAME);
        }
        catch (Exception e) {
            this.tracer.warning("got unexpected Exception: " + e, null);
        }
        return facility;
    }

    public abstract void setFirstAlarm(String var1);

    public abstract String getFirstAlarm();
}

