/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.facilities.alarmfacility;

import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.facilities.AlarmFacility;
import javax.slee.facilities.AlarmLevel;
import javax.slee.facilities.Tracer;

public abstract class Test1113488Sbb
extends BaseTCKSbb {
    private static final String JNDI_ALARMFACILITY_NAME = "java:comp/env/slee/facilities/alarm";
    public static final String ALARM_MESSAGE = "Test1113488AlarmMessage";
    public static final String NEW_ALARM_MESSAGE = "Test1113488AlarmMessageNEW";
    public static final String ALARM_INSTANCEID = "Test1113488AlarmInstanceID";
    public static final String ALARM_TYPE = "javax.slee.management.Alarm";
    public static final AlarmLevel ALARM_LEVEL_MAJOR = AlarmLevel.MAJOR;
    private Tracer sbbTracer;

    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci) {
        try {
            this.sbbTracer = this.getSbbContext().getTracer("com.test");
            this.sbbTracer.info("Received " + event + " message", null);
            AlarmFacility facility = (AlarmFacility)new InitialContext().lookup(JNDI_ALARMFACILITY_NAME);
            this.setFirstAlarm(facility.raiseAlarm(ALARM_TYPE, ALARM_INSTANCEID, ALARM_LEVEL_MAJOR, ALARM_MESSAGE));
            if (this.getFirstAlarm() == null) {
                this.sendResultToTCK("Test1113488Test", false, 1113489, "A first alarm failed to raise!");
                return;
            }
            String secondAlarmID = facility.raiseAlarm(ALARM_TYPE, ALARM_INSTANCEID, ALARM_LEVEL_MAJOR, ALARM_MESSAGE);
            if (secondAlarmID == null) {
                this.sendResultToTCK("Test1113488Test", false, 1113489, "A second alarm failed to raise!");
                return;
            }
            if (!secondAlarmID.equals(this.getFirstAlarm())) {
                this.sendResultToTCK("Test1113488Test", false, 1113489, "If an alarm with the same identifying attributes (notification source, alarm type, instanceID) is already raised, but this method didn'treturn the identifier of the existing raised alarm");
                return;
            }
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onTCKResourceEventX2(TCKResourceEventX event, ActivityContextInterface aci) {
        try {
            this.sbbTracer = this.getSbbContext().getTracer("com.test");
            this.sbbTracer.info("Received " + event + " message", null);
            AlarmFacility facility = (AlarmFacility)new InitialContext().lookup(JNDI_ALARMFACILITY_NAME);
            String NEW_ALARM_INSTANCEID = "Test1113488AlarmInstanceIDNEW";
            String NEW_ALARM_TYPE = "javax.slee.management.Alarm.NEW";
            String newAlarmID = facility.raiseAlarm(NEW_ALARM_TYPE, NEW_ALARM_INSTANCEID, AlarmLevel.MINOR, NEW_ALARM_MESSAGE);
            if (newAlarmID == null) {
                this.sendResultToTCK("Test1113488Test", false, 1113490, "A new alarm failed to raise!");
                return;
            }
            if (newAlarmID.equals(this.getFirstAlarm())) {
                this.sendResultToTCK("Test1113488Test", false, 1113490, "The second raised alarmID should not equal to the first raised alarmID.");
                return;
            }
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    private void sendResultToTCK(String testName, boolean result, int failedAssertionID, String message) throws Exception {
        HashMap<String, Object> sbbData = new HashMap<String, Object>();
        sbbData.put("testname", testName);
        sbbData.put("result", result ? "pass" : "fail");
        sbbData.put("message", message);
        sbbData.put("id", new Integer(failedAssertionID));
        TCKSbbUtils.getResourceInterface().sendSbbMessage(sbbData);
    }

    public abstract void setFirstAlarm(String var1);

    public abstract String getFirstAlarm();
}

