/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.servicestarted;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ServiceManagementMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.SleeManagementMBeanProxy;
import java.rmi.RemoteException;
import java.util.Map;
import javax.slee.ComponentID;
import javax.slee.ServiceID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.SleeState;

public class Test1108168Test
extends AbstractSleeTCKTest {
    public static final String SERVICE_DU_PATH_PARAM = "serviceDUPath";
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private DeployableUnitID duID;

    public void run(FutureResult result) throws Exception {
        this.result = result;
        SleeManagementMBeanProxy management = this.utils().getSleeManagementMBeanProxy();
        this.getLog().info("Calling SleeManagementMBean.getState()");
        SleeState currentState = management.getState();
        if (currentState == null) {
            this.getLog().severe("Current state: " + currentState);
            result.setError("ERROR! returned " + currentState + " value for the current state");
            return;
        }
        if (!currentState.isRunning()) {
            this.getLog().warning("Current state: " + currentState);
            result.setError("ERROR! Current state: " + currentState);
            return;
        }
        this.getLog().info("Current state: " + currentState);
        DeploymentMBeanProxy duProxy = this.utils().getDeploymentMBeanProxy();
        ServiceManagementMBeanProxy serviceProxy = this.utils().getServiceManagementMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        ServiceID firstService = null;
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof ServiceID)) continue;
            ServiceID service = (ServiceID)components[i];
            if (firstService != null) continue;
            firstService = service;
            break;
        }
        if (firstService == null) {
            result.setError("Failed to find the test services.");
            return;
        }
        this.getLog().fine("Activating service");
        serviceProxy.activate(firstService);
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.setResourceListener(this.resourceListener);
        this.getLog().fine("Installing a service");
        String duPath = this.utils().getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils().install(duPath);
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Map sbbData = (Map)message.getMessage();
            String sbbTestName = "Test1108168Test";
            String sbbTestResult = (String)sbbData.get("result");
            String sbbTestMessage = (String)sbbData.get("message");
            int assertionID = (Integer)sbbData.get("id");
            Test1108168Test.this.getLog().info("Received message from SBB: testname=" + sbbTestName + ", result=" + sbbTestResult + ", message=" + sbbTestMessage + ", id=" + assertionID);
            try {
                Assert.assertEquals(assertionID, "Test " + sbbTestName + " failed.", "pass", sbbTestResult);
                Test1108168Test.this.result.setPassed();
            }
            catch (TCKTestFailureException ex) {
                Test1108168Test.this.result.setFailed(assertionID, sbbTestMessage);
            }
        }

        public void onException(Exception exception) throws RemoteException {
            Test1108168Test.this.getLog().warning("Received Exception from SBB or resource:");
            Test1108168Test.this.getLog().warning(exception);
            Test1108168Test.this.result.setError(exception);
        }
    }
}

