/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.sbbabstractclass;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import java.rmi.RemoteException;
import java.util.Map;

public class Test1108057Test
extends AbstractSleeTCKTest {
    public static final String SERVICE1_DU_PATH_PARAM = "service1DUPath";
    public static final String SERVICE2_DU_PATH_PARAM = "service2DUPath";
    private static final int defaultTimeout = 25000;
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private static final String testName = "Test1108057";
    private static final int expectedCount = 6;
    private int receivedCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(FutureResult result) throws Exception {
        this.result = result;
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity("Test1108057InitialActivity");
        this.getLog().fine("Firing TCKResourceEventX1 on Test1108057InitialActivity.");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", testName, activityID, null);
        Test1108057Test test1108057Test = this;
        synchronized (test1108057Test) {
            this.wait(3000L);
        }
        this.getLog().fine("Firing TCKResourceEventX2 on Test1108057InitialActivity.");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2", testName, activityID, null);
        test1108057Test = this;
        synchronized (test1108057Test) {
            this.wait(22000L);
        }
        if (this.receivedCount == 6) {
            result.setPassed();
        } else {
            result.setFailed(1108057, "Expected number of successful messages not received, messages werenot delivered by the SBBs (expected 6, received " + this.receivedCount + ")");
        }
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.setResourceListener(this.resourceListener);
        this.getLog().fine("Installing and activating service");
        this.setupService(SERVICE1_DU_PATH_PARAM, true);
        this.setupService(SERVICE2_DU_PATH_PARAM, true);
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Map sbbData = (Map)message.getMessage();
            String sbbTestName = (String)sbbData.get("testname");
            String sbbTestResult = (String)sbbData.get("result");
            String sbbTestMessage = (String)sbbData.get("message");
            int assertionID = (Integer)sbbData.get("id");
            Test1108057Test.this.getLog().info("Received message from SBB: testname=" + sbbTestName + ", result=" + sbbTestResult + ", message=" + sbbTestMessage + ", id=" + assertionID);
            try {
                Assert.assertEquals(assertionID, "Test " + sbbTestName + " failed.", "pass", sbbTestResult);
                if (sbbTestMessage.contains("Sbb1")) {
                    Test1108057Test.this.receivedCount++;
                } else if (sbbTestMessage.contains("Sbb2")) {
                    Test1108057Test.this.receivedCount = Test1108057Test.this.receivedCount + 2;
                }
            }
            catch (TCKTestFailureException ex) {
                Test1108057Test.this.result.setFailed(assertionID, sbbTestMessage);
            }
        }

        public void onException(Exception exception) throws RemoteException {
            Test1108057Test.this.getLog().warning("Received Exception from SBB or resource:");
            Test1108057Test.this.getLog().warning(exception);
            Test1108057Test.this.result.setError(exception);
        }
    }
}

