/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.maskperacpersbb;

import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.resource.sbbapi.TCKActivity;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import com.opencloud.sleetck.lib.sbbutils.events.TCKSbbEvent;
import com.opencloud.sleetck.lib.sbbutils.events.TCKSbbEventImpl;
import com.opencloud.sleetck.lib.testsuite.events.maskperacpersbb.Controllee;
import com.opencloud.sleetck.lib.testsuite.events.maskperacpersbb.Controller;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.slee.ActivityContextInterface;
import javax.slee.ActivityEndEvent;
import javax.slee.Address;
import javax.slee.ChildRelation;
import javax.slee.ComponentID;
import javax.slee.CreateException;
import javax.slee.NotAttachedException;
import javax.slee.SbbContext;
import javax.slee.SbbLocalObject;
import javax.slee.UnrecognizedActivityException;
import javax.slee.UnrecognizedEventException;
import javax.slee.facilities.ActivityContextNamingFacility;
import javax.slee.facilities.Level;
import javax.slee.facilities.NameAlreadyBoundException;
import javax.slee.nullactivity.NullActivity;
import javax.slee.nullactivity.NullActivityContextInterfaceFactory;
import javax.slee.nullactivity.NullActivityFactory;

public abstract class SetupSbb
extends BaseTCKSbb {
    private NullActivityFactory nullFactory;
    private NullActivityContextInterfaceFactory nullAcFactory;
    private ActivityContextNamingFacility acnf;
    private static final String NAME_BINDING = "events.maskperacpersbb";

    public void setSbbContext(SbbContext ctx) {
        super.setSbbContext(ctx);
        try {
            InitialContext ic = new InitialContext();
            this.nullFactory = (NullActivityFactory)ic.lookup("java:comp/env/slee/nullactivity/factory");
            this.nullAcFactory = (NullActivityContextInterfaceFactory)ic.lookup("java:comp/env/slee/nullactivity/activitycontextinterfacefactory");
            this.acnf = (ActivityContextNamingFacility)ic.lookup("java:comp/env/slee/facilities/activitycontextnaming");
        }
        catch (NamingException ne) {
            throw new RuntimeException(ne.getMessage());
        }
    }

    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci) {
        try {
            NullActivity nullActivity = this.nullFactory.createNullActivity();
            ActivityContextInterface nullAci = this.nullAcFactory.getActivityContextInterface(nullActivity);
            SbbLocalObject child = this.getChildRelation().create();
            nullAci.attach(child);
            aci.attach(child);
            this.acnf.bind(nullAci, NAME_BINDING);
            ((Controllee)child).initialiseMaskFor(nullAci);
            ((Controllee)child).installController((Controller)this.getSbbContext().getSbbLocalObject());
            this.fireFooEvent(new TCKSbbEventImpl(new Integer(6)), nullAci, null);
            this.fireBarEvent(new TCKSbbEventImpl(new Integer(7)), nullAci, null);
        }
        catch (NameAlreadyBoundException nabe) {
            throw new RuntimeException(nabe.getMessage());
        }
        catch (CreateException ce) {
            throw new RuntimeException(ce.getMessage());
        }
        catch (UnrecognizedActivityException uae) {
            throw new RuntimeException("the activity is not recognized");
        }
        catch (UnrecognizedEventException uee) {
            throw new RuntimeException("the event could not be masked because it is not recognized");
        }
        catch (NotAttachedException nae) {
            throw new RuntimeException("the event could not be masked because the SBB is not attached");
        }
    }

    public void onActivityEndEvent(ActivityEndEvent event, ActivityContextInterface aci) {
        if (aci.getActivity() instanceof TCKActivity) {
            ActivityContextInterface nullAci = this.acnf.lookup(NAME_BINDING);
            NullActivity nullActivity = (NullActivity)nullAci.getActivity();
            nullActivity.endActivity();
        }
    }

    public void eventReceivedBy(Controllee sbb) {
        if (sbb.hasReceivedFooEvent()) {
            this.sendTestFail("child received the Foo event when it should not have");
            return;
        }
        if (!sbb.hasReceivedBarEvent()) {
            this.sendTestFail("child did not receive the Bar event when it should have");
            return;
        }
        this.sendTestSuccess();
    }

    private void sendTestSuccess() {
        this.sendMessage("SUCCESS", "");
    }

    private void sendTestFail(String reason) {
        this.sendMessage("FAILURE", reason);
    }

    private void sendMessage(String arg1, String arg2) {
        try {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.FINE, "sending a message back with values: " + arg1 + ", and " + arg2, null);
            String[] message = new String[]{arg1, arg2};
            TCKSbbUtils.getResourceInterface().sendSbbMessage(message);
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public abstract void fireFooEvent(TCKSbbEvent var1, ActivityContextInterface var2, Address var3);

    public abstract void fireBarEvent(TCKSbbEvent var1, ActivityContextInterface var2, Address var3);

    public abstract ChildRelation getChildRelation();
}

